/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.els.modules.dataSource.config.DruidProperties;
import com.els.modules.dataSource.entity.ElsDataSource;
import com.els.modules.dataSource.service.ElsJdbcService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsJdbcServiceImpl
implements ElsJdbcService {
    private static final Logger log = LoggerFactory.getLogger(ElsJdbcServiceImpl.class);
    @Autowired
    private DruidProperties druidProperties;
    static Map<String, DruidDataSource> map = new ConcurrentHashMap<String, DruidDataSource>();

    public DruidDataSource getJdbcConnectionPool(ElsDataSource dataSource) {
        if (map.containsKey(dataSource.getId())) {
            return map.get(dataSource.getId());
        }
        if (!map.containsKey(dataSource.getId())) {
            DruidDataSource pool = this.druidProperties.dataSource(dataSource.getJdbcUrl(), dataSource.getUsername(), dataSource.getPassword(), dataSource.getDriverName());
            map.put(dataSource.getId(), pool);
            log.info("\u521b\u5efa\u8fde\u63a5\u6c60\u6210\u529f\uff1a{}", (Object)dataSource.getJdbcUrl());
        }
        return map.get(dataSource.getId());
    }

    @Override
    public void removeJdbcConnectionPool(String id) {
        try {
            DruidDataSource pool = map.get(id);
            if (pool != null) {
                log.info("remove pool success, datasourceId:{}", (Object)id);
                map.remove(id);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
    }

    @Override
    public Connection getPooledConnection(ElsDataSource dataSource) throws SQLException {
        DruidDataSource pool = this.getJdbcConnectionPool(dataSource);
        return pool.getConnection();
    }

    @Override
    public Connection getUnPooledConnection(ElsDataSource dataSource) throws SQLException {
        DruidDataSource druidDataSource = this.druidProperties.dataSource(dataSource.getJdbcUrl(), dataSource.getUsername(), dataSource.getPassword(), dataSource.getDriverName());
        return druidDataSource.getConnection();
    }
}

