/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.dataSource.entity.ElsChartDataSet;
import com.els.modules.dataSource.entity.ElsDataSource;
import com.els.modules.dataSource.entity.ElsOriginalDataDto;
import com.els.modules.dataSource.entity.ElsReportChartDataSet;
import com.els.modules.dataSource.entity.ElsReportChartDataSetParam;
import com.els.modules.dataSource.entity.ElsReportChartDataSetTransform;
import com.els.modules.dataSource.entity.ElsReportChartDataSource;
import com.els.modules.dataSource.enumerate.SetTypeEnum;
import com.els.modules.dataSource.mapper.ElsReportChartDataSetMapper;
import com.els.modules.dataSource.service.ElsReportChartDataSetParamService;
import com.els.modules.dataSource.service.ElsReportChartDataSetService;
import com.els.modules.dataSource.service.ElsReportChartDataSetTransformService;
import com.els.modules.dataSource.service.ElsReportChartDataSourceService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsReportChartDataSetServiceImpl
extends BaseServiceImpl<ElsReportChartDataSetMapper, ElsReportChartDataSet>
implements ElsReportChartDataSetService {
    private static final Logger log = LoggerFactory.getLogger(ElsReportChartDataSetServiceImpl.class);
    @Autowired
    private ElsReportChartDataSetParamService elsReportChartDataSetParamService;
    @Autowired
    private ElsReportChartDataSetTransformService elsReportChartDataSetTransformService;
    @Resource
    private ElsReportChartDataSourceService elsReportChartDataSourceService;

    @Override
    public void add(ElsReportChartDataSet elsReportChartDataSet) {
        ((ElsReportChartDataSetMapper)this.baseMapper).insert((Object)elsReportChartDataSet);
    }

    @Override
    public void edit(ElsReportChartDataSet elsReportChartDataSet) {
        int count = ((ElsReportChartDataSetMapper)this.baseMapper).updateById((Object)elsReportChartDataSet);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsReportChartDataSetMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsReportChartDataSetMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsChartDataSet detailSet(String setCode) {
        List list;
        ElsChartDataSet elsChartDataSet = new ElsChartDataSet();
        ElsReportChartDataSet elsReportChartDataSet = null;
        if (StringUtils.isNotBlank((CharSequence)setCode)) {
            elsReportChartDataSet = (ElsReportChartDataSet)((Object)((ElsReportChartDataSetMapper)this.baseMapper).selectById((Serializable)((Object)setCode)));
        }
        if (elsReportChartDataSet != null && CollectionUtil.isNotEmpty((Collection)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ElsReportChartDataSet::getSetCode, (Object)setCode)).list()))) {
            elsReportChartDataSet = (ElsReportChartDataSet)((Object)list.get(0));
        }
        if (elsReportChartDataSet != null) {
            BeanUtils.copyProperties((Object)((Object)elsReportChartDataSet), (Object)elsChartDataSet);
            return this.getDetailSet(elsChartDataSet, elsChartDataSet.getSetCode());
        }
        return elsChartDataSet;
    }

    public ElsChartDataSet getDetailSet(ElsChartDataSet dto, String setCode) {
        List dataSetParamList = this.elsReportChartDataSetParamService.list((Wrapper)new QueryWrapper().lambda().eq(ElsReportChartDataSetParam::getSetCode, (Object)setCode));
        dto.setDataSetParamDtoList(dataSetParamList);
        List dataSetTransformList = this.elsReportChartDataSetTransformService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ElsReportChartDataSetTransform::getSetCode, (Object)setCode)).orderByAsc(ElsReportChartDataSetTransform::getOrderNum));
        dto.setDataSetTransformDtoList(dataSetTransformList);
        if (StringUtils.isNotBlank((CharSequence)dto.getCaseResult())) {
            try {
                JSONArray jsonArray = JSONArray.parseArray((String)dto.getCaseResult());
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                dto.setSetParamList(jsonObject.keySet());
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
            }
        }
        return dto;
    }

    @Override
    @Transactional
    public ElsChartDataSet insertSet(ElsChartDataSet dto) {
        List<ElsReportChartDataSetParam> elsReportChartDataSetParams = dto.getDataSetParamDtoList();
        List<ElsReportChartDataSetTransform> elsReportChartDataSetTransforms = dto.getDataSetTransformDtoList();
        ElsReportChartDataSet dataSet = new ElsReportChartDataSet();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)dataSet));
        ((ElsReportChartDataSetMapper)this.baseMapper).insert((Object)dataSet);
        this.dataSetParamBatch(elsReportChartDataSetParams, dto.getSetCode());
        this.dataSetTransformBatch(elsReportChartDataSetTransforms, dto.getSetCode());
        return dto;
    }

    @Override
    @Transactional
    public void updateSet(ElsChartDataSet dto) {
        List<ElsReportChartDataSetParam> elsReportChartDataSetParams = dto.getDataSetParamDtoList();
        List<ElsReportChartDataSetTransform> elsReportChartDataSetTransforms = dto.getDataSetTransformDtoList();
        ElsReportChartDataSet dataSet = new ElsReportChartDataSet();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)dataSet));
        ((ElsReportChartDataSetMapper)this.baseMapper).updateById((Object)dataSet);
        this.dataSetParamBatch(elsReportChartDataSetParams, dto.getSetCode());
        this.dataSetTransformBatch(elsReportChartDataSetTransforms, dto.getSetCode());
    }

    @Override
    public void deleteSet(String id) {
        ElsReportChartDataSet dataSet = (ElsReportChartDataSet)((Object)((ElsReportChartDataSetMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        String setCode = dataSet.getSetCode();
        ((ElsReportChartDataSetMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.elsReportChartDataSetParamService.deleteBySetCode(setCode);
        this.elsReportChartDataSetTransformService.deleteBySetCode(setCode);
    }

    @Override
    public ElsOriginalDataDto getData(ElsChartDataSet dto) {
        ElsReportChartDataSource dataSource;
        ElsOriginalDataDto originalDataDto = new ElsOriginalDataDto();
        String setCode = dto.getSetCode();
        ElsChartDataSet dataSetDto = this.detailSet(setCode);
        String dynSentence = dataSetDto.getDynSentence();
        if (StringUtils.isNotBlank((CharSequence)dataSetDto.getSetType()) && dataSetDto.getSetType().equals(SetTypeEnum.HTTP.getCodeValue())) {
            dataSource = new ElsReportChartDataSource();
            dataSource.setSourceConfig(dynSentence);
            dataSource.setSourceType("http");
            String body = JSONObject.parseObject((String)dynSentence).getString("body");
            dynSentence = StringUtils.isNotBlank((CharSequence)body) ? body : "{}";
        } else {
            dataSource = (ElsReportChartDataSource)((Object)this.elsReportChartDataSourceService.getOne((Wrapper)new QueryWrapper().lambda().eq(ElsReportChartDataSource::getSourceCode, (Object)setCode)));
        }
        log.debug("\u53c2\u6570\u6821\u9a8c\u66ff\u6362\u524d\uff1a{}", dto.getContextData());
        boolean verification = this.elsReportChartDataSetParamService.verification(dataSetDto.getDataSetParamDtoList(), dto.getContextData());
        if (!verification) {
            throw new ELSBootException("\u53c2\u6570\u6821\u9a8c\u68c0\u67e5\u9519\u8bef");
        }
        dynSentence = this.elsReportChartDataSetParamService.transform(dto.getContextData(), dynSentence);
        log.debug("\u53c2\u6570\u6821\u9a8c\u66ff\u6362\u540e\uff1a{}", dto.getContextData());
        ElsDataSource dataSourceDto = new ElsDataSource();
        BeanUtils.copyProperties((Object)((Object)dataSource), (Object)dataSourceDto);
        dataSourceDto.setDynSentence(dynSentence);
        dataSourceDto.setContextData(dto.getContextData());
        if (null != dto.getContextData() && dto.getContextData().containsKey("pageNumber") && dto.getContextData().containsKey("pageSize")) {
            long total = this.elsReportChartDataSourceService.total(dataSourceDto, dto);
            originalDataDto.setTotal(total);
        }
        List<JSONObject> data = this.elsReportChartDataSourceService.execute(dataSourceDto);
        List<JSONObject> transform = this.elsReportChartDataSetTransformService.transform(dataSetDto.getDataSetTransformDtoList(), data);
        originalDataDto.setData(transform);
        return originalDataDto;
    }

    @Override
    public ElsOriginalDataDto testTransform(ElsChartDataSet dto) {
        ElsReportChartDataSource dataSource;
        String dynSentence = dto.getDynSentence();
        ElsOriginalDataDto originalDataDto = new ElsOriginalDataDto();
        String sourceCode = dto.getSourceCode();
        if (dto.getSetType().equals(SetTypeEnum.HTTP.getCodeValue())) {
            dataSource = new ElsReportChartDataSource();
            dataSource.setSourceConfig(dynSentence);
            dataSource.setSourceType("http");
            String body = JSONObject.parseObject((String)dynSentence).getString("body");
            dynSentence = StringUtils.isNotBlank((CharSequence)body) ? body : "{}";
        } else {
            dataSource = (ElsReportChartDataSource)((Object)this.elsReportChartDataSourceService.getOne((Wrapper)new QueryWrapper().lambda().eq(ElsReportChartDataSource::getSourceCode, (Object)sourceCode)));
        }
        boolean verification = this.elsReportChartDataSetParamService.verification(dto.getDataSetParamDtoList(), null);
        if (!verification) {
            throw new ELSBootException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        }
        dynSentence = this.elsReportChartDataSetParamService.transform(dto.getDataSetParamDtoList(), dynSentence);
        ElsDataSource dataSourceDto = new ElsDataSource();
        BeanUtils.copyProperties((Object)((Object)dataSource), (Object)dataSourceDto);
        dataSourceDto.setDynSentence(dynSentence);
        dataSourceDto.setContextData(this.setContextData(dto.getDataSetParamDtoList()));
        Map<String, Object> collect = dto.getDataSetParamDtoList().stream().collect(Collectors.toMap(ElsReportChartDataSetParam::getParamName, ElsReportChartDataSetParam::getSampleItem));
        if (collect.containsKey("pageNumber") && collect.containsKey("pageSize")) {
            dto.setContextData(collect);
            long total = this.elsReportChartDataSourceService.total(dataSourceDto, dto);
            originalDataDto.setTotal(total);
        }
        List<JSONObject> data = this.elsReportChartDataSourceService.execute(dataSourceDto);
        List<JSONObject> transform = this.elsReportChartDataSetTransformService.transform(dto.getDataSetTransformDtoList(), data);
        originalDataDto.setData(transform);
        return originalDataDto;
    }

    @Override
    public List<ElsReportChartDataSet> queryAllDataSet() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{ElsReportChartDataSet::getSetCode, ElsReportChartDataSet::getSetName, ElsReportChartDataSet::getSetDesc, BaseEntity::getId}).ne(ElsReportChartDataSet::getSetType, (Object)"http")).eq(ElsReportChartDataSet::getEnableFlag, (Object)"1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return ((ElsReportChartDataSetMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void dataSetParamBatch(List<ElsReportChartDataSetParam> dataSetParamDtoList, String setCode) {
        this.elsReportChartDataSetParamService.deleteBySetCode(setCode);
        if (null == dataSetParamDtoList || dataSetParamDtoList.size() <= 0) {
            return;
        }
        dataSetParamDtoList.forEach(dataSetParamDto -> {
            ElsReportChartDataSetParam dataSetParam = new ElsReportChartDataSetParam();
            BeanUtils.copyProperties((Object)dataSetParamDto, (Object)((Object)dataSetParam));
            dataSetParam.setSetCode(setCode);
            this.elsReportChartDataSetParamService.add(dataSetParam);
        });
    }

    public void dataSetTransformBatch(List<ElsReportChartDataSetTransform> dataSetTransformDtoList, String setCode) {
        this.elsReportChartDataSetTransformService.deleteBySetCode(setCode);
        if (null == dataSetTransformDtoList || dataSetTransformDtoList.size() <= 0) {
            return;
        }
        for (int i = 0; i < dataSetTransformDtoList.size(); ++i) {
            ElsReportChartDataSetTransform dataSetTransform = new ElsReportChartDataSetTransform();
            BeanUtils.copyProperties((Object)((Object)dataSetTransformDtoList.get(i)), (Object)((Object)dataSetTransform));
            dataSetTransform.setOrderNum(i + 1);
            dataSetTransform.setSetCode(setCode);
            this.elsReportChartDataSetTransformService.add(dataSetTransform);
        }
    }

    public Map<String, Object> setContextData(List<ElsReportChartDataSetParam> dataSetParamDtoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != dataSetParamDtoList && dataSetParamDtoList.size() > 0) {
            dataSetParamDtoList.forEach(dataSetParamDto -> map.put(dataSetParamDto.getParamName(), dataSetParamDto.getSampleItem()));
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String token = JwtUtil.getOutToken((String)(loginUser.getElsAccount() + "_" + loginUser.getSubAccount()), (String)loginUser.getPassword());
        Environment env = (Environment)SpringContextUtils.getBean(Environment.class);
        String property = env.getProperty("els.service.address", "https://v5sit-");
        map.put("elsAccount", loginUser.getElsAccount());
        map.put("domainURL", property);
        map.put("elsToken", token);
        return map;
    }
}

