/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.dataSource.entity.ConnectionParam;
import com.els.modules.dataSource.entity.ElsChartDataSet;
import com.els.modules.dataSource.entity.ElsDataSource;
import com.els.modules.dataSource.entity.ElsReportChartDataSource;
import com.els.modules.dataSource.mapper.ElsReportChartDataSourceMapper;
import com.els.modules.dataSource.service.ElsJdbcService;
import com.els.modules.dataSource.service.ElsReportChartDataSetParamService;
import com.els.modules.dataSource.service.ElsReportChartDataSourceService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ElsReportChartDataSourceServiceImpl
extends BaseServiceImpl<ElsReportChartDataSourceMapper, ElsReportChartDataSource>
implements ElsReportChartDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(ElsReportChartDataSourceServiceImpl.class);
    @Resource(name="dataSourceRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private ElsReportChartDataSetParamService elsReportChartDataSetParamService;
    @Autowired
    private ElsJdbcService elsJdbcService;

    @Override
    public void add(ElsReportChartDataSource elsReportChartDataSource) {
        ((ElsReportChartDataSourceMapper)this.baseMapper).insert((Object)elsReportChartDataSource);
    }

    @Override
    public void edit(ElsReportChartDataSource elsReportChartDataSource) {
        ((ElsReportChartDataSourceMapper)this.baseMapper).updateById((Object)elsReportChartDataSource);
    }

    @Override
    public List<ElsReportChartDataSource> queryAllDataSource() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ElsReportChartDataSource::getSourceCode, ElsReportChartDataSource::getSourceName}).eq(ElsReportChartDataSource::getEnableFlag, (Object)"1");
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        return ((ElsReportChartDataSourceMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public Boolean testConnection(ConnectionParam connectionParam) {
        String sourceType = connectionParam.getSourceType();
        String sourceConfig = connectionParam.getSourceConfig();
        ElsDataSource dto = new ElsDataSource();
        dto.setSourceConfig(sourceConfig);
        switch (sourceType) {
            case "elasticsearch_sql": {
                this.testElasticsearchSqlConnection(dto);
                break;
            }
            case "mysql": 
            case "oracle": 
            case "mssqlserver": 
            case "jdbc": 
            case "postgresql": {
                this.testRelationalDb(dto);
                break;
            }
            case "http": {
                this.testHttp(dto);
                break;
            }
            default: {
                throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u7c7b\u578b");
            }
        }
        log.info("\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)connectionParam));
        return true;
    }

    @Override
    public List<JSONObject> execute(ElsDataSource dto) {
        String sourceType;
        switch (sourceType = dto.getSourceType()) {
            case "elasticsearch_sql": {
                return this.executeElasticsearchSql(dto);
            }
            case "mysql": 
            case "oracle": 
            case "mssqlserver": 
            case "jdbc": 
            case "postgresql": {
                return this.executeRelationalDb(dto);
            }
            case "http": {
                return this.executeHttp(dto);
            }
        }
        throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u7c7b\u578b");
    }

    @Override
    public long total(ElsDataSource sourceDto, ElsChartDataSet dto) {
        String sourceType;
        switch (sourceType = sourceDto.getSourceType()) {
            case "elasticsearch_sql": {
                return 0L;
            }
            case "mysql": {
                return this.mysqlTotal(sourceDto, dto);
            }
        }
        throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u7c7b\u578b");
    }

    public long mysqlTotal(ElsDataSource sourceDto, ElsChartDataSet dto) {
        String dynSentence = sourceDto.getDynSentence();
        String sql = "select count(1) as count from (" + dynSentence + ") as gaeaExecute";
        sourceDto.setDynSentence(sql);
        List<JSONObject> result = this.execute(sourceDto);
        int pageNumber = Integer.parseInt(dto.getContextData().getOrDefault("pageNumber", "1").toString());
        int pageSize = Integer.parseInt(dto.getContextData().getOrDefault("pageSize", "10").toString());
        String sqlLimit = " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
        sourceDto.setDynSentence(dynSentence.concat(sqlLimit));
        log.info("\u5f53\u524dtotal\uff1a{}, \u6dfb\u52a0\u5206\u9875\u53c2\u6570,sql\u8bed\u53e5\uff1a{}", (Object)JSONObject.toJSONString(result), (Object)sourceDto.getDynSentence());
        return result.get(0).getLongValue("count");
    }

    public List<JSONObject> executeElasticsearchSql(ElsDataSource dto) {
        ArrayList<JSONObject> result;
        ResponseEntity exchange;
        this.analysisHttpConfig(dto);
        HttpHeaders headers = new HttpHeaders();
        headers.setAll((Map)JSONObject.parseObject((String)dto.getHeader(), Map.class));
        HttpEntity entity = new HttpEntity((Object)dto.getDynSentence(), (MultiValueMap)headers);
        try {
            exchange = this.restTemplate.exchange(dto.getApiUrl(), HttpMethod.valueOf((String)dto.getMethod()), entity, JSONObject.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", new String[]{e.getMessage()});
        }
        if (exchange.getStatusCode().isError()) {
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25:" + exchange.getBody());
        }
        try {
            JSONObject body = (JSONObject)exchange.getBody();
            if (null == body) {
                return null;
            }
            JSONArray columns = body.getJSONArray("columns");
            JSONArray rows = body.getJSONArray("rows");
            result = new ArrayList<JSONObject>();
            for (int i = 0; i < rows.size(); ++i) {
                JSONArray row = rows.getJSONArray(i);
                JSONObject jsonObject = new JSONObject();
                for (int j = 0; j < row.size(); ++j) {
                    String name = columns.getJSONObject(j).getString("name");
                    String value = row.getString(j);
                    jsonObject.put(name, (Object)value);
                }
                result.add(jsonObject);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw new ELSBootException("\u6570\u636e\u6821\u9a8c\u5931\u8d25", new String[]{e.getMessage()});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<JSONObject> executeRelationalDb(ElsDataSource dto) {
        ArrayList<JSONObject> arrayList;
        this.analysisRelationalDbConfig(dto);
        Connection pooledConnection = null;
        try {
            pooledConnection = this.elsJdbcService.getPooledConnection(dto);
            String dynSentence = dto.getDynSentence();
            String transform = this.elsReportChartDataSetParamService.transform(dto.getContextData(), dynSentence);
            PreparedStatement statement = pooledConnection.prepareStatement(transform);
            ResultSet rs = statement.executeQuery();
            int columnCount = rs.getMetaData().getColumnCount();
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rs.getMetaData().getColumnLabel(i);
                columns.add(columnName);
            }
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            while (rs.next()) {
                JSONObject jo = new JSONObject();
                columns.forEach(t -> {
                    try {
                        Object value = rs.getObject((String)t);
                        Object result = this.dealResult(value);
                        jo.put(t, result);
                    }
                    catch (SQLException throwable) {
                        log.error("error", (Throwable)throwable);
                        throw new ELSBootException("sql\u6821\u9a8c\u5931\u8d25", new String[]{throwable.getMessage()});
                    }
                });
                list.add(jo);
            }
            arrayList = list;
        }
        catch (Exception throwable) {
            try {
                log.error("error", (Throwable)throwable);
                throw new ELSBootException("sql\u6821\u9a8c\u5931\u8d25", new String[]{throwable.getMessage()});
            }
            catch (Throwable throwable2) {
                try {
                    if (pooledConnection == null) throw throwable2;
                    pooledConnection.close();
                    throw throwable2;
                }
                catch (SQLException throwable3) {
                    log.error("error", (Throwable)throwable3);
                    throw new ELSBootException("\u6570\u636e\u8fde\u63a5\u5931\u8d25", new String[]{throwable3.getMessage()});
                }
            }
        }
        try {
            if (pooledConnection == null) return arrayList;
            pooledConnection.close();
            return arrayList;
        }
        catch (SQLException throwable) {
            log.error("error", (Throwable)throwable);
            throw new ELSBootException("\u6570\u636e\u8fde\u63a5\u5931\u8d25", new String[]{throwable.getMessage()});
        }
    }

    private Object dealResult(Object result) throws SQLException {
        if (null == result) {
            return result;
        }
        String type = result.getClass().getName();
        if ("oracle.sql.TIMESTAMP".equals(type)) {
            return new Date((Long)JSONObject.toJSON((Object)result));
        }
        return result;
    }

    public List<JSONObject> executeHttp(ElsDataSource dto) {
        ResponseEntity exchange;
        this.analysisHttpConfig(dto);
        HttpHeaders headers = new HttpHeaders();
        headers.setAll((Map)JSONObject.parseObject((String)dto.getHeader(), Map.class));
        HttpEntity entity = new HttpEntity((Object)dto.getDynSentence(), (MultiValueMap)headers);
        try {
            exchange = this.restTemplate.exchange(dto.getApiUrl(), HttpMethod.valueOf((String)dto.getMethod()), entity, Object.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", new String[]{e.getMessage()});
        }
        if (exchange.getStatusCode().isError()) {
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25" + exchange.getBody());
        }
        Object body = exchange.getBody();
        String jsonStr = JSONObject.toJSONString((Object)body);
        List<Object> result = new ArrayList<JSONObject>();
        if (jsonStr.trim().startsWith("{") && jsonStr.trim().endsWith("}")) {
            result.add(JSONObject.parseObject((String)jsonStr));
        } else if (jsonStr.trim().startsWith("[") && jsonStr.trim().endsWith("]")) {
            result = JSONArray.parseArray((String)jsonStr, JSONObject.class);
        } else {
            result.add(new JSONObject());
        }
        return result;
    }

    public void testRelationalDb(ElsDataSource dto) {
        this.analysisRelationalDbConfig(dto);
        try {
            Connection unPooledConnection = this.elsJdbcService.getUnPooledConnection(dto);
            String catalog = unPooledConnection.getCatalog();
            log.info("\u6570\u636e\u5e93\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\uff1a{}", (Object)catalog);
            unPooledConnection.close();
        }
        catch (SQLException e) {
            log.error("error", (Throwable)e);
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new ELSBootException("class is not found", (Throwable)e, new String[0]);
            }
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", (Throwable)e, new String[0]);
        }
    }

    public void testHttp(ElsDataSource dto) {
        this.analysisHttpConfig(dto);
        String apiUrl = dto.getApiUrl();
        String method = dto.getMethod();
        String body = dto.getBody();
        HttpHeaders headers = new HttpHeaders();
        headers.setAll((Map)JSONObject.parseObject((String)dto.getHeader(), Map.class));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            ResponseEntity exchange = this.restTemplate.exchange(apiUrl, HttpMethod.valueOf((String)method), entity, Object.class, new Object[0]);
            if (exchange.getStatusCode().isError()) {
                throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25" + exchange.getBody());
            }
        }
        catch (RestClientException e) {
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", new String[]{e.getMessage()});
        }
    }

    public void testElasticsearchSqlConnection(ElsDataSource dto) {
        this.analysisHttpConfig(dto);
        String apiUrl = dto.getApiUrl();
        String method = dto.getMethod();
        String body = dto.getBody();
        HttpHeaders headers = new HttpHeaders();
        headers.setAll((Map)JSONObject.parseObject((String)dto.getHeader(), Map.class));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            ResponseEntity exchange = this.restTemplate.exchange(apiUrl, HttpMethod.valueOf((String)method), entity, Object.class, new Object[0]);
            if (exchange.getStatusCode().isError()) {
                throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25" + exchange.getBody());
            }
        }
        catch (RestClientException e) {
            throw new ELSBootException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25", new String[]{e.getMessage()});
        }
    }

    public void analysisRelationalDbConfig(ElsDataSource dataSource) {
        JSONObject json = JSONObject.parseObject((String)dataSource.getSourceConfig());
        if (!json.containsKey((Object)"jdbcUrl") || !StringUtils.isNotBlank((CharSequence)json.getString("jdbcUrl"))) {
            throw new ELSBootException("jdbcUrl is entry");
        }
        if (!json.containsKey((Object)"driverName") || !StringUtils.isNotBlank((CharSequence)json.getString("driverName"))) {
            throw new ELSBootException("driverName is entry");
        }
        String jdbcUrl = json.getString("jdbcUrl");
        String username = json.getString("username");
        String password = json.getString("password");
        String driverName = json.getString("driverName");
        dataSource.setJdbcUrl(jdbcUrl);
        dataSource.setDriverName(driverName);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
    }

    public void analysisHttpConfig(ElsDataSource dto) {
        JSONObject json = JSONObject.parseObject((String)dto.getSourceConfig());
        String apiUrl = json.getString("apiUrl");
        String method = json.getString("method");
        String header = json.getString("header");
        String body = json.getString("body");
        apiUrl = this.elsReportChartDataSetParamService.transform(dto.getContextData(), apiUrl);
        header = this.elsReportChartDataSetParamService.transform(dto.getContextData(), header);
        dto.setApiUrl(apiUrl);
        dto.setMethod(method);
        dto.setHeader(header);
        dto.setBody(body);
    }
}

