/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.dataSource.entity.ElsReportChartDataSetTransform;
import com.els.modules.dataSource.service.IGroovyHandler;
import com.els.modules.dataSource.service.TransformStrategy;
import groovy.lang.GroovyClassLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GroovyTransformServiceImpl
implements TransformStrategy {
    private static final Logger log = LoggerFactory.getLogger(GroovyTransformServiceImpl.class);
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader();

    @Override
    public String type() {
        return "javaBean";
    }

    @Override
    public List<JSONObject> transform(ElsReportChartDataSetTransform def, List<JSONObject> data) {
        String transformScript = def.getTransformScript();
        Class clazz = this.groovyClassLoader.parseClass(transformScript);
        if (clazz != null) {
            try {
                Object instance = clazz.newInstance();
                if (instance != null) {
                    if (instance instanceof IGroovyHandler) {
                        IGroovyHandler handler = (IGroovyHandler)instance;
                        return handler.transform(data);
                    }
                    System.err.println("\u8f6c\u6362\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                log.info("\u6267\u884cjavaBean\u5f02\u5e38", (Throwable)e);
                throw new ELSBootException("\u6267\u884cjavaBean\u5f02\u5e38" + e.getMessage());
            }
        }
        return data;
    }
}

