/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dataSource.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.dataSource.entity.ElsReportChartDataSetTransform;
import com.els.modules.dataSource.service.TransformStrategy;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsTransformServiceImpl
implements TransformStrategy {
    private static final Logger log = LoggerFactory.getLogger(JsTransformServiceImpl.class);
    private ScriptEngine engine;

    public JsTransformServiceImpl() {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName("JavaScript");
    }

    @Override
    public String type() {
        return "js";
    }

    @Override
    public List<JSONObject> transform(ElsReportChartDataSetTransform def, List<JSONObject> data) {
        return this.getValueFromJs(def, data);
    }

    private List<JSONObject> getValueFromJs(ElsReportChartDataSetTransform def, List<JSONObject> data) {
        String js = def.getTransformScript();
        try {
            this.engine.eval(js);
            if (this.engine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)this.engine);
                return (List)invocable.invokeFunction("dataTransform", data);
            }
        }
        catch (Exception ex) {
            throw new ELSBootException("js\u683c\u5f0f\u9519\u8bef");
        }
        return null;
    }
}

