/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.jimu.rocketMq.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.jimu.service.JimuReportDtoService;
import com.els.ureport.UreportDatabaseProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class InitPrintReportConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitPrintReportConsumer.class);
    @Autowired
    private JimuReportDtoService jimuReportDtoService;
    @Autowired
    private UreportDatabaseProvider ureportDatabaseProvider;

    @StreamListener(value="inputPrintReport")
    public void receive(String msgBody) {
        try {
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            log.info("\u63a5\u6536\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + body.toJSONString());
            List account = JSONObject.parseArray((String)body.getString("elsAccount"), String.class);
            List reportId = JSONObject.parseArray((String)body.getString("reportId"), String.class);
            String shareType = body.getString("shareType");
            if ("print".equals(shareType)) {
                String printType = body.getString("printType");
                if ("ureport".equals(printType)) {
                    List ureportName = JSONObject.parseArray((String)body.getString("ureportName"), String.class);
                    this.ureportDatabaseProvider.savePrintFile(ureportName, account);
                } else if ("jimu".equals(printType)) {
                    this.jimuReportDtoService.shareElsReport(account, reportId);
                }
            }
        }
        catch (Exception e) {
            log.error("InitReportConsumer_receive_msgBody:" + msgBody, (Throwable)e);
            throw e;
        }
    }
}

