/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.jimu.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.jimu.entity.JimuReportDataSourceDto;
import com.els.modules.jimu.entity.JimuReportDbDto;
import com.els.modules.jimu.entity.JimuReportDbFieldDto;
import com.els.modules.jimu.entity.JimuReportDbParamDto;
import com.els.modules.jimu.entity.JimuReportDto;
import com.els.modules.jimu.entity.JimuReportLinkDto;
import com.els.modules.jimu.mapper.JimuReportDtoMapper;
import com.els.modules.jimu.service.JimuReportDataSourceDtoService;
import com.els.modules.jimu.service.JimuReportDbDtoService;
import com.els.modules.jimu.service.JimuReportDbFieldDtoService;
import com.els.modules.jimu.service.JimuReportDbParamDtoService;
import com.els.modules.jimu.service.JimuReportDtoService;
import com.els.modules.jimu.service.JimuReportLinkDtoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class JimuReportDtoServiceImpl
extends BaseServiceImpl<JimuReportDtoMapper, JimuReportDto>
implements JimuReportDtoService {
    @Autowired
    private JimuReportDataSourceDtoService jimuReportDataSourceDtoService;
    @Autowired
    private JimuReportDbDtoService jimuReportDbDtoService;
    @Autowired
    private JimuReportDbFieldDtoService jimuReportDbFieldDtoService;
    @Autowired
    private JimuReportDbParamDtoService jimuReportDbParamDtoService;
    @Autowired
    private JimuReportLinkDtoService jimuReportLinkDtoService;
    @Resource
    private JimuReportDtoMapper jimuReportDtoMapper;

    @Override
    public void saveJimuReportDto(JimuReportDto jimuReportDto) {
        ((JimuReportDtoMapper)this.baseMapper).insert((Object)jimuReportDto);
    }

    @Override
    public void updateJimuReportDto(JimuReportDto jimuReportDto) {
        ((JimuReportDtoMapper)this.baseMapper).updateById((Object)jimuReportDto);
    }

    @Override
    public void delJimuReportDto(String id) {
        ((JimuReportDtoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delReportDbFieldDto(String elsAccount, List<String> idList) {
        this.jimuReportDtoMapper.delReportDto(elsAccount, idList);
    }

    @Override
    public void delBatchJimuReportDto(List<String> idList) {
        ((JimuReportDtoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    @Async
    public void shareElsReport(List<String> elsAccountList, List<String> reportId) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseEntity::getId, reportId)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(JimuReportDto::getMenuFlag, (Object)0)).list();
        List jimuReportDbDtos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.jimuReportDbDtoService.lambdaQuery().in(JimuReportDbDto::getJimuReportId, reportId)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List dbIdList = jimuReportDbDtos.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List jimuReportDataSourceDtos = ((LambdaQueryChainWrapper)this.jimuReportDataSourceDtoService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List jimuReportDbParamDtos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.jimuReportDbParamDtoService.lambdaQuery().in(JimuReportDbParamDto::getJimuReportHeadId, dbIdList)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List jimuReportDbFieldDtos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.jimuReportDbFieldDtoService.lambdaQuery().in(JimuReportDbFieldDto::getJimuReportDbId, dbIdList)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List jimuReportLinkDtos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.jimuReportLinkDtoService.lambdaQuery().in(JimuReportLinkDto::getReportId, reportId)).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList<JimuReportDto> jimuReportDtoList = new ArrayList<JimuReportDto>();
        ArrayList<JimuReportDbDto> jimuReportDbDtoList = new ArrayList<JimuReportDbDto>();
        ArrayList<JimuReportDataSourceDto> jimuReportDataSourceDtoList = new ArrayList<JimuReportDataSourceDto>();
        ArrayList<JimuReportDbParamDto> jimuReportDbParamDtoList = new ArrayList<JimuReportDbParamDto>();
        ArrayList<JimuReportDbFieldDto> jimuReportDbFieldDtosList = new ArrayList<JimuReportDbFieldDto>();
        ArrayList<JimuReportLinkDto> jimuReportLinkDtoList = new ArrayList<JimuReportLinkDto>();
        for (String s : elsAccountList) {
            this.delReportMenuData(s);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.forEach(item -> {
                    JimuReportDto jimuReportDto = new JimuReportDto();
                    item.setElsAccount(s);
                    item.setCreateBy(s + "_1001");
                    item.setUpdateBy(s + "_1001");
                    item.setCreateTime(null);
                    item.setUpdateTime(null);
                    BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportDto));
                    jimuReportDtoList.add(jimuReportDto);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)jimuReportDbDtos)) {
                jimuReportDbDtos.forEach(item -> {
                    JimuReportDbDto jimuReportDbDto = new JimuReportDbDto();
                    item.setElsAccount(s);
                    item.setCreateBy(s + "_1001");
                    item.setUpdateBy(s + "_1001");
                    item.setCreateTime(null);
                    item.setUpdateTime(null);
                    BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportDbDto));
                    jimuReportDbDtoList.add(jimuReportDbDto);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)jimuReportDataSourceDtos)) {
                jimuReportDataSourceDtos.forEach(item -> {
                    JimuReportDataSourceDto jimuReportDataSourceDto = new JimuReportDataSourceDto();
                    item.setElsAccount(s);
                    item.setCreateBy(s + "_1001");
                    item.setUpdateBy(s + "_1001");
                    item.setCreateTime(null);
                    item.setUpdateTime(null);
                    BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportDataSourceDto));
                    jimuReportDataSourceDtoList.add(jimuReportDataSourceDto);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)jimuReportDbParamDtos)) {
                jimuReportDbParamDtos.forEach(item -> {
                    JimuReportDbParamDto jimuReportDbParamDto = new JimuReportDbParamDto();
                    item.setElsAccount(s);
                    item.setCreateBy(s + "_1001");
                    item.setUpdateBy(s + "_1001");
                    item.setCreateTime(null);
                    item.setUpdateTime(null);
                    BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportDbParamDto));
                    jimuReportDbParamDtoList.add(jimuReportDbParamDto);
                });
            }
            if (CollectionUtil.isNotEmpty((Collection)jimuReportDbFieldDtos)) {
                jimuReportDbFieldDtos.forEach(item -> {
                    JimuReportDbFieldDto jimuReportDbFieldDto = new JimuReportDbFieldDto();
                    item.setElsAccount(s);
                    item.setCreateBy(s + "_1001");
                    item.setUpdateBy(s + "_1001");
                    item.setCreateTime(null);
                    item.setUpdateTime(null);
                    BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportDbFieldDto));
                    jimuReportDbFieldDtosList.add(jimuReportDbFieldDto);
                });
            }
            if (!CollectionUtil.isNotEmpty((Collection)jimuReportLinkDtos)) continue;
            jimuReportLinkDtos.forEach(item -> {
                JimuReportLinkDto jimuReportLinkDto = new JimuReportLinkDto();
                item.setElsAccount(s);
                item.setCreateBy(s + "_1001");
                item.setUpdateBy(s + "_1001");
                item.setCreateTime(null);
                item.setUpdateTime(null);
                BeanUtils.copyProperties((Object)item, (Object)((Object)jimuReportLinkDto));
                jimuReportLinkDtoList.add(jimuReportLinkDto);
            });
        }
        this.saveReportMenuData(jimuReportDtoList, jimuReportDbDtoList, jimuReportDataSourceDtoList, jimuReportDbParamDtoList, jimuReportDbFieldDtosList, jimuReportLinkDtoList);
    }

    private void delReportMenuData(String elsAccount) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(JimuReportDto::getMenuFlag, (Object)0)).list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List<String> reportId = list.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            List jimuReportDbDtos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.jimuReportDbDtoService.lambdaQuery().in(JimuReportDbDto::getJimuReportId, reportId)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
            List<String> reportDbId = jimuReportDbDtos.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            this.jimuReportDbDtoService.delReportDbDto(elsAccount, reportId);
            this.jimuReportDataSourceDtoService.delReportDataSource(elsAccount, reportId);
            this.jimuReportDbParamDtoService.delReportDbParamDto(elsAccount, reportDbId);
            this.jimuReportDbFieldDtoService.delReportDbFieldDto(elsAccount, reportDbId);
            this.jimuReportLinkDtoService.delReportLinkDto(elsAccount, reportId);
            this.delReportDbFieldDto(elsAccount, reportId);
        }
    }

    @Async
    void saveReportMenuData(List<JimuReportDto> jimuReportDtoList, List<JimuReportDbDto> jimuReportDbDtoList, List<JimuReportDataSourceDto> jimuReportDataSourceDtoList, List<JimuReportDbParamDto> jimuReportDbParamDtoList, List<JimuReportDbFieldDto> jimuReportDbFieldDtosList, List<JimuReportLinkDto> jimuReportLinkDtoList) {
        if (CollectionUtil.isNotEmpty(jimuReportDtoList)) {
            this.saveBatch(jimuReportDtoList);
        }
        if (CollectionUtil.isNotEmpty(jimuReportDbDtoList)) {
            this.jimuReportDbDtoService.saveBatch(jimuReportDbDtoList);
        }
        if (CollectionUtil.isNotEmpty(jimuReportDataSourceDtoList)) {
            this.jimuReportDataSourceDtoService.saveBatch(jimuReportDataSourceDtoList);
        }
        if (CollectionUtil.isNotEmpty(jimuReportDbParamDtoList)) {
            this.jimuReportDbParamDtoService.saveBatch(jimuReportDbParamDtoList);
        }
        if (CollectionUtil.isNotEmpty(jimuReportDbFieldDtosList)) {
            this.jimuReportDbFieldDtoService.saveBatch(jimuReportDbFieldDtosList);
        }
        if (CollectionUtil.isNotEmpty(jimuReportLinkDtoList)) {
            this.jimuReportLinkDtoService.saveBatch(jimuReportLinkDtoList);
        }
    }
}

