/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.jmreport.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.SpringContextUtils;
import com.els.modules.jmreport.entity.ElsJmReportPrint;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportExportPdf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/elsJmReportPrint"})
@Api(tags={"\u6279\u91cf\u6253\u5370"})
public class ElsJmReportPrintController {
    private static final Logger log = LoggerFactory.getLogger(ElsJmReportPrintController.class);
    @Autowired
    private IJimuReportService jmReportDesignService;
    @Autowired
    private IJmReportExportPdf jmReportExportPdf;

    @AutoLog(value="\u79ef\u6728\u62a5\u8868\u6279\u91cf\u6253\u5370")
    @ApiOperation(value="\u79ef\u6728\u62a5\u8868\u6279\u91cf\u6253\u5370", notes="\u79ef\u6728\u62a5\u8868\u6279\u91cf\u6253\u5370")
    @PostMapping(value={"/batchPrint"})
    public void batchPrint(@RequestBody ElsJmReportPrint elsJmReportPrint) throws Exception {
        float dpi = 96.0f;
        if (elsJmReportPrint.getDpi() != null) {
            dpi = elsJmReportPrint.getDpi().floatValue();
        }
        String excelConfigId = elsJmReportPrint.getExcelConfigId();
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        List<Object> objectList = elsJmReportPrint.getObjectList();
        String parameter = elsJmReportPrint.getParameter();
        Map stringMap = (Map)JSONObject.parseObject((String)parameter, Map.class);
        for (int i = 0; i < objectList.size(); ++i) {
            Object o = objectList.get(i);
            JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
            JSONObject queryParam = new JSONObject();
            for (Map.Entry entry : stringMap.entrySet()) {
                String key = (String)entry.getKey();
                String name = (String)entry.getValue();
                if (!jsonObject.containsKey((Object)name)) continue;
                queryParam.put(key, jsonObject.get((Object)name));
            }
            Result result = this.jmReportDesignService.show(excelConfigId, queryParam.toJSONString(), null);
            JimuReport jimuReport = (JimuReport)result.getResult();
            Map resultMap = this.jmReportExportPdf.exportPdf(jimuReport, null, dpi);
            String file = (String)resultMap.get("file");
            byte[] buffer = Base64Utils.decodeFromString((String)file);
            mergePdf.addSource((InputStream)new ByteArrayInputStream(buffer));
        }
        HttpServletResponse response = SpringContextUtils.getHttpServletResponse();
        response.reset();
        response.setHeader("Content-Type", "application/pdf");
        response.setHeader("Content-Disposition", "attachment; filename=elsJmReportPrint.pdf");
        ServletOutputStream os = response.getOutputStream();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        mergePdf.setDestinationStream((OutputStream)byteOutputStream);
        mergePdf.mergeDocuments();
        ByteArrayOutputStream mergerUtilityDestinationStream = (ByteArrayOutputStream)mergePdf.getDestinationStream();
        mergerUtilityDestinationStream.writeTo((OutputStream)os);
        ((OutputStream)byteOutputStream).close();
        os.flush();
    }
}

