/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ureport.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.system.util.UreportExportUtil;
import com.els.modules.ureport.entity.ElsPrintBatch;
import com.els.modules.ureport.service.ElsUReportPrintService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElsUReportPrintServiceImpl
implements ElsUReportPrintService {
    private static final Logger log = LoggerFactory.getLogger(ElsUReportPrintServiceImpl.class);
    @Value(value="${els.path.printPath}")
    private String basePath;

    @Override
    public void downLoadPdfprint(ElsPrintBatch elsPrintBatch) {
        OutputStream os = null;
        OutputStream byteOutputStream = null;
        try {
            int i;
            File file = new File(this.basePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            List<Object> objectList = elsPrintBatch.getObjectList();
            String parameter = elsPrintBatch.getParameter();
            String ureportName = elsPrintBatch.getUreportName();
            PDFMergerUtility mergePdf = new PDFMergerUtility();
            Map stringMap = (Map)JSONObject.parseObject((String)parameter, Map.class);
            for (i = 0; i < objectList.size(); ++i) {
                Object o = objectList.get(i);
                JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("_t", "1,2,3,4,6,7");
                for (Map.Entry entry : stringMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    if (!jsonObject.containsKey((Object)name)) continue;
                    parameters.put(key, jsonObject.get((Object)name));
                }
                UreportExportUtil.genPdf(ureportName, parameters, this.basePath, jsonObject.get((Object)"id") + ".pdf");
            }
            for (i = 0; i < objectList.size(); ++i) {
                mergePdf.addSource(this.basePath + File.separator + JSONObject.parseObject((String)objectList.get(i).toString()).getString("id") + ".pdf");
            }
            HttpServletResponse response = SpringContextUtils.getHttpServletResponse();
            response.reset();
            response.setHeader("Content-Type", "application/pdf");
            response.setHeader("Content-Disposition", "attachment; filename=paymentBatchPrint.pdf");
            os = response.getOutputStream();
            byteOutputStream = new ByteArrayOutputStream();
            mergePdf.setDestinationStream(byteOutputStream);
            mergePdf.mergeDocuments();
            ByteArrayOutputStream mergerUtilityDestinationStream = (ByteArrayOutputStream)mergePdf.getDestinationStream();
            mergerUtilityDestinationStream.writeTo(os);
            byteOutputStream.close();
            this.deleteDir(this.basePath);
            os.flush();
        }
        catch (Exception e) {
            log.error("downLoadPdfprint failed!", (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zRfWGNW_84329c68", (String)("\u6279\u91cf\u6253\u5370\u51fa\u9519:" + e)));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            if (byteOutputStream != null) {
                try {
                    byteOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        this.deleteDir(this.basePath);
    }

    private boolean deleteDir(String dir) {
        boolean delete;
        File file = new File(dir);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children.length > 0) {
                for (int i = 0; i < children.length; ++i) {
                    boolean success = this.deleteDir(file.getPath() + "/" + children[i]);
                    if (success) continue;
                    return false;
                }
            }
            delete = file.delete();
            log.info("\u5220\u9664\u76ee\u5f55" + delete);
        } else {
            delete = file.delete();
            log.info("\u5220\u9664\u6587\u4ef6" + delete);
        }
        return delete;
    }

    private static String[] getFiles(String folder) throws IOException {
        File _folder = new File(folder);
        if (_folder.isDirectory()) {
            String[] filesInFolder = _folder.list();
            return filesInFolder;
        }
        throw new IOException("Path is not a directory");
    }
}

