/*
 * Decompiled with CFR 0.152.
 */
package com.els.report;

import cn.hutool.core.util.StrUtil;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.base.Splitter;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ReportTokenServiceImpl
implements JmReportTokenServiceI {
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private RedisUtil redisUtil;

    ReportTokenServiceImpl() {
    }

    public String getToken(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        String referer = request.getHeader("Referer");
        String token = request.getHeader("X-Access-Token");
        if (StrUtil.isBlank((CharSequence)referer)) {
            if (parameterMap.containsKey("token") || StrUtil.isBlank((CharSequence)token)) {
                token = request.getParameter("token");
            }
        } else {
            String params = referer.substring(referer.indexOf("?") + 1, referer.length());
            if (params.contains("=")) {
                Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
                token = (String)split.get("token");
            }
        }
        this.checkUserTokenIsEffect(token);
        return token;
    }

    public String getUsername(String token) {
        return JwtUtil.getAccount((String)token);
    }

    public Boolean verifyToken(String token) {
        return this.checkUserTokenIsEffect(token);
    }

    public boolean checkUserTokenIsEffect(String token) throws AuthenticationException {
        String account = JwtUtil.getAccount((String)token);
        if (account == null) {
            throw new AuthenticationException("token\u975e\u6cd5\u65e0\u6548");
        }
        LoginUserDTO loginUser = this.invokeAccountRpcService.getLoginUser(account);
        if (loginUser == null) {
            throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (loginUser.getStatus() != 1) {
            throw new AuthenticationException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (!this.jwtTokenRefresh(token, account, loginUser.getPassword())) {
            throw new AuthenticationException("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        LoginUserContext.setUser((LoginUser)((LoginUser)SysUtil.copyProperties((Object)loginUser, LoginUser.class)));
        return true;
    }

    public boolean jwtTokenRefresh(String token, String account, String passWord) {
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (ConvertUtils.isNotEmpty((Object)cacheToken)) {
            if (!JwtUtil.verify((String)cacheToken, (String)account, (String)passWord)) {
                String newAuthorization = JwtUtil.sign((String)account, (String)passWord);
                this.redisUtil.set("sys:token:" + token, (Object)newAuthorization);
                this.redisUtil.expire("sys:token:" + token, 3600L);
            }
            String elsAccount = account.split("_")[0];
            TenantContext.setTenant(elsAccount);
            return true;
        }
        return false;
    }
}

