/*
 * Decompiled with CFR 0.152.
 */
package com.els.shiro.authc.aop;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.exception.ELSBootExceptionHandler;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.shiro.authc.JwtToken;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class Ureport2Filter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(Ureport2Filter.class);
    private static Map<String, String> cookie = new HashMap<String, String>();

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            return this.executeLogin(request, response);
        }
        catch (Exception e) {
            log.error("isAccessAllowed Exception:", (Throwable)e);
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"));
        }
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
        I18nUtil.clear();
        AdminFlagUtil.clear();
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        Map parameterMap = request.getParameterMap();
        String referer = httpServletRequest.getHeader("Referer");
        Cookie[] cookies = httpServletRequest.getCookies();
        String token = httpServletRequest.getHeader("X-Access-Token");
        if (StrUtil.isBlank((CharSequence)referer) || !referer.contains("?")) {
            if (StrUtil.isBlank((CharSequence)token) && parameterMap.containsKey("token")) {
                token = ((String[])parameterMap.get("token"))[0];
            }
        } else {
            String params = referer.substring(referer.indexOf("?") + 1, referer.length());
            if (params.contains("=")) {
                Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
                token = (String)split.get("token");
            }
        }
        log.info("Token:" + token);
        if (StrUtil.isBlank((CharSequence)token)) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cook = cookies[i];
                if (!cookie.containsKey(cook.getValue())) continue;
                token = cookie.get(cook.getValue());
                break;
            }
        }
        JwtToken jwtToken = new JwtToken(token);
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cook = cookies[i];
            if (!cook.getName().equals("jsessionId")) continue;
            cookie.put(cook.getValue(), token);
        }
        try {
            this.getSubject(request, response).login((AuthenticationToken)jwtToken);
        }
        catch (AuthenticationException e) {
            ELSBootExceptionHandler handler = new ELSBootExceptionHandler();
            this.returnJson(response, JSON.toJSONString((Object)handler.handleAuthcException(e)));
            return false;
        }
        String language = ((HttpServletRequest)request).getHeader("language");
        I18nUtil.setCurrentLanguage((String)language);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(ServletResponse response, String json) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try {
            writer = response.getWriter();
            writer.print(json);
        }
        catch (IOException e) {
            log.error("response error", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Access-control-Allow-Origin", httpServletRequest.getHeader("Origin"));
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
        httpServletResponse.setHeader("Access-Control-Allow-Headers", httpServletRequest.getHeader("Access-Control-Request-Headers"));
        if (httpServletRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        return super.preHandle(request, response);
    }
}

