/*
 * Decompiled with CFR 0.152.
 */
package com.els.ureport;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.entity.UreportFile;
import com.els.mapper.UreportFileMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ureport.database.provider")
public class UreportDatabaseProvider
implements ReportProvider {
    private static final Logger log = LoggerFactory.getLogger(UreportDatabaseProvider.class);
    private static final String NAME = "mysql-provider";
    private String prefix = "mysql:";
    private boolean disabled;
    @Resource
    private UreportFileMapper ureportFileMapper;

    public InputStream loadReport(String file) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"name", (Object)this.getCorrectName(file));
        UreportFile ureportFileEntity = (UreportFile)this.ureportFileMapper.selectOne((Wrapper)queryWrapper);
        if (ureportFileEntity == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6253\u5370\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5Ureport\u62a5\u8868\u6587\u4ef6"));
        }
        byte[] content = ureportFileEntity.getContent();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        return inputStream;
    }

    public void deleteReport(String file) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"name", (Object)this.getCorrectName(file));
        this.ureportFileMapper.delete((Wrapper)queryWrapper);
    }

    public List<ReportFile> getReportFiles() {
        QueryWrapper ureportFileQueryWrapper = new QueryWrapper();
        ureportFileQueryWrapper.lambda().eq(UreportFile::getElsAccount, (Object)TenantContext.getTenant());
        log.info("\u83b7\u53d6TenantContext" + TenantContext.getTenant());
        List list = this.ureportFileMapper.selectList((Wrapper)ureportFileQueryWrapper);
        ArrayList<ReportFile> reportList = new ArrayList<ReportFile>();
        for (UreportFile ureportFileEntity : list) {
            reportList.add(new ReportFile(ureportFileEntity.getName(), ureportFileEntity.getUpdateTime()));
        }
        return reportList;
    }

    public void saveReport(String file, String content) {
        file = this.getCorrectName(file);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"name", (Object)file);
        UreportFile ureportFileEntity = (UreportFile)this.ureportFileMapper.selectOne((Wrapper)queryWrapper);
        if (ureportFileEntity == null) {
            ureportFileEntity = new UreportFile();
            ureportFileEntity.setName(file);
            ureportFileEntity.setContent(content.getBytes());
            this.ureportFileMapper.insert(ureportFileEntity);
        } else {
            ureportFileEntity.setContent(content.getBytes());
            this.ureportFileMapper.update(ureportFileEntity, (Wrapper)queryWrapper);
        }
    }

    public void savePrintFile(List<String> fileName, List<String> elsAccountList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List collect = fileName.stream().map(item -> item.substring(item.indexOf("_") + 1)).collect(Collectors.toList());
        queryWrapper.in((Object)"name", collect);
        List ureportFiles = this.ureportFileMapper.selectList((Wrapper)queryWrapper);
        ArrayList ureportFilesNew = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)ureportFiles)) {
            Map collect1 = ureportFiles.stream().collect(Collectors.toMap(UreportFile::getName, Function.identity(), (key1, key2) -> key2));
            for (String s : elsAccountList) {
                fileName.forEach(item -> {
                    String substring = item.substring(item.indexOf("_") + 1);
                    if (collect1.containsKey(substring)) {
                        UreportFile ureportFile = new UreportFile();
                        BeanUtils.copyProperties(collect1.get(substring), (Object)ureportFile);
                        ureportFile.setId(null);
                        ureportFile.setName((String)item);
                        ureportFile.setElsAccount(s);
                        ureportFile.setCreateBy(null);
                        ureportFile.setUpdateBy(null);
                        ureportFile.setCreateTime(null);
                        ureportFile.setUpdateTime(null);
                        ureportFilesNew.add(ureportFile);
                    }
                });
            }
            for (UreportFile ureportFile : ureportFilesNew) {
                this.ureportFileMapper.insert(ureportFile);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean disabled() {
        return this.disabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String getCorrectName(String name) {
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length(), name.length());
        }
        return name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setUreportFileMapper(UreportFileMapper ureportFileMapper) {
        this.ureportFileMapper = ureportFileMapper;
    }
}

