/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import com.alibaba.druid.pool.DruidDataSource;
import com.bstek.ureport.Utils;
import com.els.config.mybatis.ElsJimuTenantHandler;
import com.els.config.mybatis.TenantContext;
import com.els.config.mybatis.UreportTenantParser;
import com.els.util.ElsFreemarkerParseFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.ReflectHelper;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.config.HikariDataSourceConfig;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportAsyncService;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.util.JmreportFreemarkerParseFactory;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@Configuration(value="JmreportDynamicDbUtil")
public class JmreportDynamicDbUtil {
    private static final Logger log = LoggerFactory.getLogger(JmreportDynamicDbUtil.class);
    @Resource
    private HikariDataSourceConfig hikariDataSourceConfig;
    @Resource
    private IJimuReportAsyncService jimuReportAsyncService;

    @Deprecated
    private DruidDataSource getDruidDataSource(JmreportDynamicDataSourceVo dbSource) {
        DruidDataSource var2 = new DruidDataSource();
        String var3 = dbSource.getDbDriver();
        String var4 = dbSource.getDbUrl();
        String var5 = dbSource.getDbUsername();
        String var6 = dbSource.getDbPassword();
        var2.setDriverClassName(var3);
        var2.setUrl(var4);
        var2.setTestWhileIdle(true);
        var2.setTestOnBorrow(false);
        var2.setTestOnReturn(false);
        var2.setBreakAfterAcquireFailure(true);
        var2.setLoginTimeout(oConvertUtils.getInt((Object)(this.hikariDataSourceConfig.getConnectionTimeout() / 1000), (int)60));
        var2.setConnectionErrorRetryAttempts(0);
        var2.setUsername(var5);
        var2.setMaxWait(60000L);
        var2.setPassword(var6);
        log.debug("******************************************");
        log.debug("*                                        *");
        log.debug("*====\u3010" + dbSource.getCode() + "\u3011=====Druid\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.debug("*                                        *");
        log.debug("******************************************");
        return var2;
    }

    private HikariDataSource getHikariDataSource(JmreportDynamicDataSourceVo dbSource) {
        HikariDataSource var2 = new HikariDataSource();
        String var3 = dbSource.getDbDriver();
        String var4 = dbSource.getDbUrl();
        String var5 = dbSource.getDbUsername();
        String var6 = dbSource.getDbPassword();
        var2.setDriverClassName(var3);
        var2.setJdbcUrl(var4);
        var2.setUsername(var5);
        var2.setPassword(var6);
        var2.setAutoCommit(this.hikariDataSourceConfig.getAutoCommit().booleanValue());
        var2.setMaximumPoolSize(this.hikariDataSourceConfig.getMaximumPoolSize().intValue());
        var2.setMinimumIdle(this.hikariDataSourceConfig.getMinimumIdle().intValue());
        var2.setConnectionTimeout((long)this.hikariDataSourceConfig.getConnectionTimeout().intValue());
        var2.setIdleTimeout((long)this.hikariDataSourceConfig.getIdleTimeout().intValue());
        var2.setMaxLifetime((long)this.hikariDataSourceConfig.getMaxLifetime().intValue());
        var2.setPoolName(this.hikariDataSourceConfig.getPoolName());
        log.debug("******************************************");
        log.debug("*                                        *");
        log.debug("*====\u3010" + dbSource.getCode() + "\u3011=====Hikari\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.debug("*                                        *");
        log.debug("******************************************");
        return var2;
    }

    public DataSource getDbSourceByDbKey(String dbKey) {
        log.debug("----\u81ea\u5b9a\u4e49\u52a8\u6001\u6570\u636e\u6e90----------dbKey------: " + dbKey);
        DataSource var2 = JmreportDataSourceCachePool.getCacheBasicDataSource((String)dbKey);
        try {
            if (var2 != null) {
                log.debug("--------getDbSourceBydbKey------------------\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6DB\u8fde\u63a5-------------------");
                return var2;
            }
            JmreportDynamicDataSourceVo var3 = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel((String)dbKey);
            if (var3 == null) {
                throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff0cdbKey\uff1a" + dbKey);
            }
            if (var3.getConnectTimes() > 5) {
                throw new JimuReportException("\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef5\u6b21\u4ee5\u4e0a,\u8bf7\u68c0\u67e5,dbKey:" + dbKey);
            }
            HikariDataSource var4 = this.getHikariDataSource(var3);
            if (var4 != null) {
                JmreportDataSourceCachePool.putCacheBasicDataSource((String)dbKey, (DataSource)var4);
                log.debug("--------getDbSourceBydbKey------------------\u521b\u5efaDB\u6570\u636e\u5e93\u8fde\u63a5-------------------");
                return var4;
            }
            throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0cdbKey\uff1a" + dbKey);
        }
        catch (Exception var5) {
            log.warn(var5.getMessage(), (Throwable)var5);
            return var2;
        }
    }

    public void closeDbKey(String dbKey) {
        DataSource var2 = this.getDbSourceByDbKey(dbKey);
        try {
            if (var2 != null && !var2.getConnection().isClosed()) {
                var2.getConnection().commit();
                var2.getConnection().close();
                var2.getConnection().close();
            }
        }
        catch (SQLException var4) {
            var4.printStackTrace();
        }
    }

    private JdbcTemplate getJdbcTemplate(String dbKey) {
        DataSource var2 = this.getDbSourceByDbKey(dbKey);
        if (var2 == null) {
            throw new JimuReportException("\u6570\u636e\u6e90\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\uff01");
        }
        JdbcTemplate var3 = new JdbcTemplate(var2);
        var3.setQueryTimeout(oConvertUtils.getInt((Object)(this.hikariDataSourceConfig.getConnectionTimeout() / 1000), (int)60));
        return var3;
    }

    public int update(String dbKey, String sql, Object ... param) {
        JdbcTemplate var5 = null;
        try {
            var5 = this.getJdbcTemplate(dbKey);
            int var4 = oConvertUtils.isEmpty((Object)param) ? var5.update(sql) : var5.update(sql, param);
            return var4;
        }
        catch (Exception var7) {
            this.jimuReportAsyncService.testConnect(var5, dbKey);
            throw var7;
        }
    }

    public int updateByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate var5 = null;
        try {
            var5 = this.getJdbcTemplate(dbKey);
            sql = JmreportFreemarkerParseFactory.parseTemplateContent((String)sql, data);
            NamedParameterJdbcTemplate var6 = new NamedParameterJdbcTemplate(var5.getDataSource());
            int var4 = var6.update(sql, data);
            return var4;
        }
        catch (Exception var7) {
            this.jimuReportAsyncService.testConnect(var5, dbKey);
            throw var7;
        }
    }

    public Object findOne(String dbKey, String sql, Object ... param) {
        List<Map<String, Object>> var4 = this.findList(dbKey, sql, param);
        if (oConvertUtils.isEmpty(var4)) {
            log.error("Except one, but not find actually");
        }
        if (var4.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return var4.get(0);
    }

    public Object findOneByHash(String dbKey, String sql, HashMap<String, Object> data) {
        List<Map<String, Object>> var4 = this.findListByHash(dbKey, sql, data);
        if (oConvertUtils.isEmpty(var4)) {
            log.error("Except one, but not find actually");
        }
        if (var4.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return var4.get(0);
    }

    public <T> Object findOne(String dbKey, String sql, Class<T> clazz, Object ... param) {
        Map var5 = (Map)this.findOne(dbKey, sql, param);
        return ReflectHelper.setAll(clazz, (Map)var5);
    }

    public <T> Object findOneByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        Map var5 = (Map)this.findOneByHash(dbKey, sql, data);
        return ReflectHelper.setAll(clazz, (Map)var5);
    }

    public List<Map<String, Object>> findList(String dbKey, String sql, Object ... param) {
        JdbcTemplate var5 = null;
        try {
            var5 = this.getJdbcTemplate(dbKey);
            if (!ElsJimuTenantHandler.checkNeedTeant(sql)) {
                String tenantId = TenantContext.getTenant();
                log.info("\u7ec4\u88c5\u524dSQL:" + sql + ";\u5927B\u53c2\u6570:" + tenantId);
                sql = UreportTenantParser.addTenantCondition(sql, tenantId);
                log.info("\u7ec4\u88c5\u540eSQL:" + sql);
                Utils.logToConsole((String)("DESIGN SQL2:" + sql));
            }
            List var4 = oConvertUtils.isEmpty((Object)param) ? var5.queryForList(sql) : var5.queryForList(sql, param);
            return var4;
        }
        catch (Exception var7) {
            this.jimuReportAsyncService.testConnect(var5, dbKey);
            throw var7;
        }
    }

    public List<Map<String, Object>> findListByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate var5 = null;
        try {
            var5 = this.getJdbcTemplate(dbKey);
            sql = ElsFreemarkerParseFactory.parseTemplateContent(sql, data);
            NamedParameterJdbcTemplate var6 = new NamedParameterJdbcTemplate(var5.getDataSource());
            List var4 = var6.queryForList(sql, data);
            return var4;
        }
        catch (Exception var7) {
            this.jimuReportAsyncService.testConnect(var5, dbKey);
            throw var7;
        }
    }

    public <T> List<T> findList(String dbKey, String sql, Class<T> clazz, Object ... param) {
        JdbcTemplate var6 = null;
        try {
            var6 = this.getJdbcTemplate(dbKey);
            List var5 = oConvertUtils.isEmpty((Object)param) ? var6.queryForList(sql, clazz) : var6.queryForList(sql, clazz, param);
            return var5;
        }
        catch (Exception var8) {
            this.jimuReportAsyncService.testConnect(var6, dbKey);
            throw var8;
        }
    }

    public <T> List<T> findListByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        JdbcTemplate var6 = null;
        try {
            var6 = this.getJdbcTemplate(dbKey);
            sql = JmreportFreemarkerParseFactory.parseTemplateContent((String)sql, data);
            NamedParameterJdbcTemplate var7 = new NamedParameterJdbcTemplate(var6.getDataSource());
            List var5 = var7.queryForList(sql, data, clazz);
            return var5;
        }
        catch (Exception var8) {
            this.jimuReportAsyncService.testConnect(var6, dbKey);
            throw var8;
        }
    }

    public <T> List<T> findListEntities(String dbKey, String sql, Class<T> clazz, Object ... param) {
        List<Map<String, Object>> var5 = this.findList(dbKey, sql, param);
        return ReflectHelper.transList2Entrys(var5, clazz);
    }

    public <T> List<T> findListEntitiesByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        List<Map<String, Object>> var5 = this.findListByHash(dbKey, sql, data);
        return ReflectHelper.transList2Entrys(var5, clazz);
    }

    public <T> List<Map<String, Object>> executeProcedure(String dbKey, String procedure) {
        Object var3 = null;
        JdbcTemplate var4 = null;
        try {
            var4 = StringUtils.isBlank((CharSequence)dbKey) ? (JdbcTemplate)JimuSpringContextUtils.getApplicationContext().getBean(JdbcTemplate.class) : this.getJdbcTemplate(dbKey);
            return (List)var4.execute(procedure, new CallableStatementCallback(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ArrayList var2 = new ArrayList();
                    ResultSet var3 = cs.executeQuery();
                    while (var3.next()) {
                        HashMap<String, String> var4 = new HashMap<String, String>();
                        ResultSetMetaData var5 = var3.getMetaData();
                        for (int var6 = 1; var6 <= var5.getColumnCount(); ++var6) {
                            var4.put(var5.getColumnName(var6), var3.getString(var5.getColumnName(var6)));
                        }
                        var2.add(var4);
                    }
                    return var2;
                }
            });
        }
        catch (Exception var6) {
            this.jimuReportAsyncService.testConnect(var4, dbKey);
            return var3;
        }
    }
}

