/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.customers.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.customers.config.SourceCustomerImport;
import com.els.modules.customers.entity.CustomeBankInfo;
import com.els.modules.customers.entity.CustomerAddressInfo;
import com.els.modules.customers.entity.CustomerCertificatedInfo;
import com.els.modules.customers.entity.CustomerContactsInfo;
import com.els.modules.customers.entity.CustomerMasterCustom1;
import com.els.modules.customers.entity.CustomerMasterCustom10;
import com.els.modules.customers.entity.CustomerMasterCustom2;
import com.els.modules.customers.entity.CustomerMasterCustom3;
import com.els.modules.customers.entity.CustomerMasterCustom4;
import com.els.modules.customers.entity.CustomerMasterCustom5;
import com.els.modules.customers.entity.CustomerMasterCustom6;
import com.els.modules.customers.entity.CustomerMasterCustom7;
import com.els.modules.customers.entity.CustomerMasterCustom8;
import com.els.modules.customers.entity.CustomerMasterCustom9;
import com.els.modules.customers.entity.CustomerMasterData;
import com.els.modules.customers.enumerate.CustomerSourceEnum;
import com.els.modules.customers.enumerate.CustomerStatusEnum;
import com.els.modules.customers.mapper.CustomerMasterDataMapper;
import com.els.modules.customers.service.CustomeBankInfoService;
import com.els.modules.customers.service.CustomerAddressInfoService;
import com.els.modules.customers.service.CustomerCertificatedInfoService;
import com.els.modules.customers.service.CustomerContactsInfoService;
import com.els.modules.customers.service.CustomerMasterCustom10Service;
import com.els.modules.customers.service.CustomerMasterCustom1Service;
import com.els.modules.customers.service.CustomerMasterCustom2Service;
import com.els.modules.customers.service.CustomerMasterCustom3Service;
import com.els.modules.customers.service.CustomerMasterCustom4Service;
import com.els.modules.customers.service.CustomerMasterCustom5Service;
import com.els.modules.customers.service.CustomerMasterCustom6Service;
import com.els.modules.customers.service.CustomerMasterCustom7Service;
import com.els.modules.customers.service.CustomerMasterCustom8Service;
import com.els.modules.customers.service.CustomerMasterCustom9Service;
import com.els.modules.customers.service.CustomerMasterDataService;
import com.els.modules.customers.vo.CustomerMasterDataImportVo;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerMasterDataServiceImpl
extends BaseServiceImpl<CustomerMasterDataMapper, CustomerMasterData>
implements CustomerMasterDataService {
    @Autowired
    private CustomerContactsInfoService customerContactsInfoService;
    @Autowired
    private CustomeBankInfoService customeBankInfoService;
    @Autowired
    private CustomerAddressInfoService customerAddressInfoService;
    @Autowired
    private CustomerCertificatedInfoService customerCertificatedInfoService;
    @Autowired
    private CustomerMasterCustom1Service customerMasterCustom1Service;
    @Autowired
    private CustomerMasterCustom2Service customerMasterCustom2Service;
    @Autowired
    private CustomerMasterCustom3Service customerMasterCustom3Service;
    @Autowired
    private CustomerMasterCustom4Service customerMasterCustom4Service;
    @Autowired
    private CustomerMasterCustom5Service customerMasterCustom5Service;
    @Autowired
    private CustomerMasterCustom6Service customerMasterCustom6Service;
    @Autowired
    private CustomerMasterCustom7Service customerMasterCustom7Service;
    @Autowired
    private CustomerMasterCustom8Service customerMasterCustom8Service;
    @Autowired
    private CustomerMasterCustom9Service customerMasterCustom9Service;
    @Autowired
    private CustomerMasterCustom10Service customerMasterCustom10Service;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private SrmToIPaasRpcService srmToIPaasRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public CustomerMasterData saveMain(CustomerMasterData customerMasterData) {
        LoginUser loginUser = SysUtil.getLoginUser();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"customer_name", (Object)customerMasterData.getCustomerName());
        wrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        if (!this.list((Wrapper)wrapper).isEmpty()) {
            throw new ELSBootException("\u3010" + customerMasterData.getCustomerName() + "\u3011\u5ba2\u6237\u5df2\u6dfb\u52a0\uff01");
        }
        List localCompanys = this.elsEnterpriseInfoRpcService.selectList(customerMasterData.getCustomerName());
        if (localCompanys != null && localCompanys.size() > 0) {
            wrapper.clear();
            List toElsAccounts = localCompanys.stream().map(BaseDTO::getElsAccount).distinct().collect(Collectors.toList());
            wrapper.in((Object)"to_els_account", toElsAccounts);
            wrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
            if (!this.list((Wrapper)wrapper).isEmpty()) {
                throw new ELSBootException("\u3010" + customerMasterData.getCustomerName() + "\u3011\u5ba2\u6237\u5df2\u6dfb\u52a0\uff01");
            }
            customerMasterData.setToElsAccount(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getElsAccount());
            customerMasterData.setName(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getName());
            customerMasterData.setCustomerName(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getName());
        } else {
            JSONObject result = this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSData(customerMasterData.getCustomerName(), null, loginUser.getElsAccount(), "0", null), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
            if (result.getBoolean("success").booleanValue()) {
                ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
                ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
                if (enterpriseInfo != null) {
                    wrapper.clear();
                    wrapper.eq((Object)"to_els_account", (Object)enterpriseInfo.getElsAccount());
                    wrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
                    if (!this.list((Wrapper)wrapper).isEmpty()) {
                        throw new ELSBootException("\u3010" + customerMasterData.getCustomerName() + "\u3011\u5ba2\u6237\u5df2\u6dfb\u52a0\uff01");
                    }
                    customerMasterData.setToElsAccount(enterpriseInfo.getElsAccount());
                    customerMasterData.setCustomerName(enterpriseInfo.getName());
                    customerMasterData.setName(enterpriseInfo.getName());
                } else {
                    ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
                    this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSRelationData(TenantContext.getTenant(), ElsEnterpriseInfoDTO2.getElsAccount()), "enterpriseRelationship", null);
                    this.elsEnterpriseInfoRpcService.insert(ElsEnterpriseInfoDTO2);
                    customerMasterData.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
                    customerMasterData.setCustomerName(ElsEnterpriseInfoDTO2.getName());
                    customerMasterData.setName(ElsEnterpriseInfoDTO2.getName());
                }
            } else {
                throw new ELSBootException("\u5ba2\u6237\u6dfb\u52a0\u5931\u8d25\uff1a" + result.getString("message"));
            }
        }
        customerMasterData.setNeedAudit("0");
        customerMasterData.setSourceType(CustomerSourceEnum.NEW.getValue());
        customerMasterData.setCustomerStatus(CustomerStatusEnum.COOPERATION.getValue());
        customerMasterData.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((CustomerMasterDataMapper)this.baseMapper).insert((Object)customerMasterData);
        return customerMasterData;
    }

    private JSONObject getIpaaSRelationData(String purchaserElsAccount, String providerElsAccount) {
        JSONObject data = new JSONObject();
        data.put("purchaserElsAccount", (Object)purchaserElsAccount);
        data.put("providerElsAccount", (Object)providerElsAccount);
        return data;
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount, String update, String account) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        if ("1".equals(update)) {
            body.put("is_update", (Object)update);
            body.put("account", (Object)account);
        } else {
            body.put("channel", (Object)sourceType);
            body.put("auth", (Object)"1");
            body.put("failIsCreateAccount", (Object)"1");
        }
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CustomerMasterData customerMasterData, List<CustomerContactsInfo> customerContactsInfoList, List<CustomeBankInfo> customeBankInfoList, List<CustomerAddressInfo> customerAddressInfoList, List<CustomerCertificatedInfo> customerCertificatedInfoList, List<CustomerMasterCustom1> customerMasterCustom1List, List<CustomerMasterCustom2> customerMasterCustom2List, List<CustomerMasterCustom3> customerMasterCustom3List, List<CustomerMasterCustom4> customerMasterCustom4List, List<CustomerMasterCustom5> customerMasterCustom5List, List<CustomerMasterCustom6> customerMasterCustom6List, List<CustomerMasterCustom7> customerMasterCustom7List, List<CustomerMasterCustom8> customerMasterCustom8List, List<CustomerMasterCustom9> customerMasterCustom9List, List<CustomerMasterCustom10> customerMasterCustom10List) {
        int count = ((CustomerMasterDataMapper)this.baseMapper).updateById((Object)customerMasterData);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.customerContactsInfoService.deleteByMainId(customerMasterData.getId());
        this.customeBankInfoService.deleteByMainId(customerMasterData.getId());
        this.customerAddressInfoService.deleteByMainId(customerMasterData.getId());
        this.customerCertificatedInfoService.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom1Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom2Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom3Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom4Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom5Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom6Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom7Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom8Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom9Service.deleteByMainId(customerMasterData.getId());
        this.customerMasterCustom10Service.deleteByMainId(customerMasterData.getId());
        this.insertData(customerMasterData, customerContactsInfoList, customeBankInfoList, customerAddressInfoList, customerCertificatedInfoList, customerMasterCustom1List, customerMasterCustom2List, customerMasterCustom3List, customerMasterCustom4List, customerMasterCustom5List, customerMasterCustom6List, customerMasterCustom7List, customerMasterCustom8List, customerMasterCustom9List, customerMasterCustom10List);
    }

    private void insertData(CustomerMasterData customerMasterData, List<CustomerContactsInfo> customerContactsInfoList, List<CustomeBankInfo> customeBankInfoList, List<CustomerAddressInfo> customerAddressInfoList, List<CustomerCertificatedInfo> customerCertificatedInfoList, List<CustomerMasterCustom1> customerMasterCustom1List, List<CustomerMasterCustom2> customerMasterCustom2List, List<CustomerMasterCustom3> customerMasterCustom3List, List<CustomerMasterCustom4> customerMasterCustom4List, List<CustomerMasterCustom5> customerMasterCustom5List, List<CustomerMasterCustom6> customerMasterCustom6List, List<CustomerMasterCustom7> customerMasterCustom7List, List<CustomerMasterCustom8> customerMasterCustom8List, List<CustomerMasterCustom9> customerMasterCustom9List, List<CustomerMasterCustom10> customerMasterCustom10List) {
        if (!CollectionUtils.isEmpty(customerContactsInfoList)) {
            for (CustomerContactsInfo customerContactsInfo : customerContactsInfoList) {
                customerContactsInfo.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerContactsInfo, (BaseEntity)customerMasterData);
                customerContactsInfo.setElsAccount(customerMasterData.getElsAccount());
                customerContactsInfo.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerContactsInfoService.saveBatch(customerContactsInfoList, 2000);
        }
        if (!CollectionUtils.isEmpty(customeBankInfoList)) {
            for (CustomeBankInfo customeBankInfo : customeBankInfoList) {
                customeBankInfo.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customeBankInfo, (BaseEntity)customerMasterData);
                customeBankInfo.setElsAccount(customerMasterData.getElsAccount());
                customeBankInfo.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customeBankInfoService.saveBatch(customeBankInfoList, 2000);
        }
        if (!CollectionUtils.isEmpty(customerAddressInfoList)) {
            for (CustomerAddressInfo customerAddressInfo : customerAddressInfoList) {
                customerAddressInfo.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerAddressInfo, (BaseEntity)customerMasterData);
            }
            this.customerAddressInfoService.saveBatch(customerAddressInfoList, 2000);
        }
        if (!CollectionUtils.isEmpty(customerCertificatedInfoList)) {
            for (CustomerCertificatedInfo customerCertificatedInfo : customerCertificatedInfoList) {
                customerCertificatedInfo.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerCertificatedInfo, (BaseEntity)customerMasterData);
                customerCertificatedInfo.setElsAccount(customerMasterData.getElsAccount());
                customerCertificatedInfo.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerCertificatedInfoService.saveBatch(customerCertificatedInfoList, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom1List)) {
            for (CustomerMasterCustom1 customerMasterCustom1 : customerMasterCustom1List) {
                customerMasterCustom1.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom1, (BaseEntity)customerMasterData);
                customerMasterCustom1.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom1.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom1Service.saveBatch(customerMasterCustom1List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom2List)) {
            for (CustomerMasterCustom2 customerMasterCustom2 : customerMasterCustom2List) {
                customerMasterCustom2.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom2, (BaseEntity)customerMasterData);
                customerMasterCustom2.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom2.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom2Service.saveBatch(customerMasterCustom2List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom3List)) {
            for (CustomerMasterCustom3 customerMasterCustom3 : customerMasterCustom3List) {
                customerMasterCustom3.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom3, (BaseEntity)customerMasterData);
                customerMasterCustom3.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom3.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom3Service.saveBatch(customerMasterCustom3List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom4List)) {
            for (CustomerMasterCustom4 customerMasterCustom4 : customerMasterCustom4List) {
                customerMasterCustom4.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom4, (BaseEntity)customerMasterData);
                customerMasterCustom4.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom4.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom4Service.saveBatch(customerMasterCustom4List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom5List)) {
            for (CustomerMasterCustom5 customerMasterCustom5 : customerMasterCustom5List) {
                customerMasterCustom5.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom5, (BaseEntity)customerMasterData);
                customerMasterCustom5.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom5.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom5Service.saveBatch(customerMasterCustom5List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom6List)) {
            for (CustomerMasterCustom6 customerMasterCustom6 : customerMasterCustom6List) {
                customerMasterCustom6.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom6, (BaseEntity)customerMasterData);
                customerMasterCustom6.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom6.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom6Service.saveBatch(customerMasterCustom6List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom7List)) {
            for (CustomerMasterCustom7 customerMasterCustom7 : customerMasterCustom7List) {
                customerMasterCustom7.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom7, (BaseEntity)customerMasterData);
                customerMasterCustom7.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom7.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom7Service.saveBatch(customerMasterCustom7List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom8List)) {
            for (CustomerMasterCustom8 customerMasterCustom8 : customerMasterCustom8List) {
                customerMasterCustom8.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom8, (BaseEntity)customerMasterData);
                customerMasterCustom8.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom8.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom8Service.saveBatch(customerMasterCustom8List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom9List)) {
            for (CustomerMasterCustom9 customerMasterCustom9 : customerMasterCustom9List) {
                customerMasterCustom9.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom9, (BaseEntity)customerMasterData);
                customerMasterCustom9.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom9.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom9Service.saveBatch(customerMasterCustom9List, 2000);
        }
        if (!CollectionUtils.isEmpty(customerMasterCustom10List)) {
            for (CustomerMasterCustom10 customerMasterCustom10 : customerMasterCustom10List) {
                customerMasterCustom10.setHeadId(customerMasterData.getId());
                SysUtil.setSysParam((BaseEntity)customerMasterCustom10, (BaseEntity)customerMasterData);
                customerMasterCustom10.setElsAccount(customerMasterData.getElsAccount());
                customerMasterCustom10.setToElsAccount(customerMasterData.getToElsAccount());
            }
            this.customerMasterCustom10Service.saveBatch(customerMasterCustom10List, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.customerContactsInfoService.deleteByMainId(id);
        this.customeBankInfoService.deleteByMainId(id);
        this.customerAddressInfoService.deleteByMainId(id);
        this.customerCertificatedInfoService.deleteByMainId(id);
        this.customerMasterCustom1Service.deleteByMainId(id);
        this.customerMasterCustom2Service.deleteByMainId(id);
        this.customerMasterCustom3Service.deleteByMainId(id);
        this.customerMasterCustom4Service.deleteByMainId(id);
        this.customerMasterCustom5Service.deleteByMainId(id);
        this.customerMasterCustom6Service.deleteByMainId(id);
        this.customerMasterCustom7Service.deleteByMainId(id);
        this.customerMasterCustom8Service.deleteByMainId(id);
        this.customerMasterCustom9Service.deleteByMainId(id);
        this.customerMasterCustom10Service.deleteByMainId(id);
        ((CustomerMasterDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.customerContactsInfoService.deleteByMainId(serializable.toString());
            this.customeBankInfoService.deleteByMainId(serializable.toString());
            this.customerAddressInfoService.deleteByMainId(serializable.toString());
            this.customerCertificatedInfoService.deleteByMainId(serializable.toString());
            this.customerMasterCustom1Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom2Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom3Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom4Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom5Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom6Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom7Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom8Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom9Service.deleteByMainId(serializable.toString());
            this.customerMasterCustom10Service.deleteByMainId(serializable.toString());
            ((CustomerMasterDataMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void importCustomersData(List<CustomerMasterData> customerMasterDataList, LoginUser loginUser) {
        this.saveBatch(customerMasterDataList, 2000);
        CustomerMasterDataImportVo importVo = null;
        for (CustomerMasterData entity : customerMasterDataList) {
            importVo = new CustomerMasterDataImportVo(entity, loginUser.getElsAccount(), loginUser, null);
            String infoJson = JSON.toJSONString((Object)importVo);
            String key = IdWorker.getIdStr();
            this.invokeBaseRpcService.saveRecord(loginUser.getElsAccount(), key, infoJson, "customerMasterDataImportMessage");
            ((SourceCustomerImport)SpringContextUtils.getBean(SourceCustomerImport.class)).outputCustomerImport().send(MessageBuilder.withPayload((Object)infoJson).setHeader("KEYS", (Object)key).build());
        }
    }

    @Override
    public List<String> getAllCustomerNames(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        List customers = this.list((Wrapper)wrapper);
        if (!customers.isEmpty()) {
            return customers.stream().map(CustomerMasterData::getCustomerName).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void importSupplierMasterDataAsynsDo(CustomerMasterDataImportVo importVo) {
        CustomerMasterData customerMasterData = importVo.getCustomerMasterData();
        LoginUser loginUser = importVo.getLoginUser();
        String tenant = importVo.getTenant();
        String token = importVo.getToken();
        LoginUserContext.setUser((LoginUser)loginUser);
        TenantContext.setTenant((String)tenant);
        TokenContext.setToken((String)token);
        List localCompanys = this.elsEnterpriseInfoRpcService.selectList(customerMasterData.getCustomerName());
        QueryWrapper wrapper = new QueryWrapper();
        if (localCompanys != null && localCompanys.size() > 0) {
            wrapper.clear();
            List toElsAccounts = localCompanys.stream().map(BaseDTO::getElsAccount).distinct().collect(Collectors.toList());
            wrapper.in((Object)"to_els_account", toElsAccounts);
            wrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
            if (!this.list((Wrapper)wrapper).isEmpty()) {
                this.deleteMain(customerMasterData.getId());
                throw new ELSBootException("\u3010" + customerMasterData.getCustomerName() + "\u3011\u5ba2\u6237\u5df2\u6dfb\u52a0\uff01");
            }
            customerMasterData.setToElsAccount(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getElsAccount());
            customerMasterData.setName(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getName());
            customerMasterData.setCustomerName(((ElsEnterpriseInfoDTO)localCompanys.get(0)).getName());
        } else {
            JSONObject result = this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSData(customerMasterData.getCustomerName(), null, loginUser.getElsAccount(), "0", null), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
            if (result.getBoolean("success").booleanValue()) {
                ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
                ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
                if (enterpriseInfo != null) {
                    wrapper.clear();
                    wrapper.eq((Object)"to_els_account", (Object)enterpriseInfo.getElsAccount());
                    wrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
                    if (!this.list((Wrapper)wrapper).isEmpty()) {
                        this.deleteMain(customerMasterData.getId());
                        throw new ELSBootException("\u3010" + customerMasterData.getCustomerName() + "\u3011\u5ba2\u6237\u5df2\u6dfb\u52a0\uff01");
                    }
                    customerMasterData.setToElsAccount(enterpriseInfo.getElsAccount());
                    customerMasterData.setCustomerName(enterpriseInfo.getName());
                    customerMasterData.setName(enterpriseInfo.getName());
                } else {
                    ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
                    this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSRelationData(TenantContext.getTenant(), ElsEnterpriseInfoDTO2.getElsAccount()), "enterpriseRelationship", null);
                    this.elsEnterpriseInfoRpcService.insert(ElsEnterpriseInfoDTO2);
                    customerMasterData.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
                    customerMasterData.setCustomerName(ElsEnterpriseInfoDTO2.getName());
                    customerMasterData.setName(ElsEnterpriseInfoDTO2.getName());
                }
            }
        }
        customerMasterData.setNeedAudit("0");
        customerMasterData.setSourceType(CustomerSourceEnum.NEW.getValue());
        customerMasterData.setCustomerStatus(CustomerStatusEnum.COOPERATION.getValue());
        customerMasterData.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        this.updateById((Object)customerMasterData);
    }

    @Override
    public void updateBaseInfo(String id) {
        CustomerMasterData customerMasterData = (CustomerMasterData)((Object)this.getById((Serializable)((Object)id)));
        JSONObject result = this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSData(customerMasterData.getCustomerName(), null, customerMasterData.getElsAccount(), "1", customerMasterData.getToElsAccount()), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        if (!result.getBoolean("success").booleanValue()) {
            throw new ELSBootException("\u66f4\u65b0\u5931\u8d25\uff1a" + result.getString("message"));
        }
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(customerMasterData.getToElsAccount());
        elsEnterpriseInfoDTO.setId(enterpriseInfo.getId());
        this.elsEnterpriseInfoRpcService.updateById(elsEnterpriseInfoDTO);
        customerMasterData.setCustomerName(elsEnterpriseInfoDTO.getName());
        this.updateById((Object)customerMasterData);
    }
}

