/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.customers.excel;

import cn.hutool.core.collection.CollUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.customers.entity.CustomerMasterData;
import com.els.modules.customers.service.CustomerMasterDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="customersMasterDataExcelHandler")
public class CustomersMasterDataExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final String BUSSINESS_TYPE = "customersMasterData";
    @Resource
    private CustomerMasterDataService customerMasterDataService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        LoginUser LoginUser2 = SysUtil.getLoginUser();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType(BUSSINESS_TYPE);
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWRdXdWFWESWCLWIrW_969a25c1", (String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3011\u4e1a\u52a1\u3010\u9ed8\u8ba4\u3011\u6a21\u677f\u3002"));
        ArrayList<String> customersName = new ArrayList<String>();
        ArrayList<CustomerMasterData> customerMasterDataList = new ArrayList<CustomerMasterData>();
        List<String> localCustomers = this.customerMasterDataService.getAllCustomerNames(LoginUser2.getElsAccount());
        for (Map data : dataList) {
            String customerName = (String)data.get("customerName");
            if (customersName.contains(customerName)) {
                String msg = "\u5bfc\u5165\u6570\u636e\u4e2d\u5ba2\u6237\u540d[" + customerName + "]\u5b58\u5728\u91cd\u590d";
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (CollUtil.isNotEmpty(localCustomers) && localCustomers.contains(customerName)) {
                this.errorAdd(excelImportDTO, "[" + customerName + "]\u5ba2\u6237\u5df2\u5b58\u5728\u5ba2\u6237\u4e3b\u6570\u636e\u4e2d", data);
                continue;
            }
            CustomerMasterData entity = new CustomerMasterData();
            entity.setCustomerName(customerName);
            entity.setElsAccount(LoginUser2.getElsAccount());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion() + "");
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            customersName.add(customerName);
            customerMasterDataList.add(entity);
        }
        this.customerMasterDataService.importCustomersData(customerMasterDataList, LoginUser2);
        return dataList;
    }
}

