/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.customers.listener;

import com.alibaba.fastjson.JSON;
import com.els.common.context.TokenContext;
import com.els.common.util.LoginUserContext;
import com.els.config.mybatis.TenantContext;
import com.els.modules.customers.entity.CustomerMasterData;
import com.els.modules.customers.mapper.CustomerMasterDataMapper;
import com.els.modules.customers.service.CustomerMasterDataService;
import com.els.modules.customers.vo.CustomerMasterDataImportVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class CustomerMasterDataImportMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(CustomerMasterDataImportMessageConsumer.class);
    @Autowired
    private CustomerMasterDataService customerMasterDataService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private CustomerMasterDataMapper customerMasterDataMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(value="inputCustomerImport")
    public void receive(Message<String> message) {
        String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
        String msgBody = (String)message.getPayload();
        CustomerMasterDataImportVo importVo = new CustomerMasterDataImportVo();
        log.info("\u5ba2\u6237\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log:  " + msgBody);
        String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
        if ("1".equals(msgStatus)) {
            log.error("\u5ba2\u6237\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39-\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
            return;
        }
        String errorInfo = "";
        try {
            importVo = (CustomerMasterDataImportVo)JSON.parseObject((String)msgBody, CustomerMasterDataImportVo.class);
            this.customerMasterDataService.importSupplierMasterDataAsynsDo(importVo);
            log.info(msgBody);
            msgStatus = "1";
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u4e3b\u6570\u636e\u5bfc\u5165MQ\u6d88\u8d39 log failed:" + msgBody, (Throwable)e);
            msgStatus = "2";
            errorInfo = e.getMessage();
            CustomerMasterData customerMasterData = importVo.getCustomerMasterData();
            this.customerMasterDataMapper.deleteById((Serializable)((Object)customerMasterData.getId()));
        }
        finally {
            this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
            LoginUserContext.clear();
            TenantContext.clear();
            TokenContext.clear();
        }
    }
}

