/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.customers.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.customers.dto.CustomerMasterDataDTO;
import com.els.modules.customers.entity.CustomerMasterData;
import com.els.modules.customers.enumerate.CustomerSourceEnum;
import com.els.modules.customers.service.CustomerMasterDataAPiService;
import com.els.modules.customers.service.CustomerMasterDataService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerMasterDataApiServiceImpl
implements CustomerMasterDataAPiService {
    @Resource
    private CustomerMasterDataService customerMasterDataService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private SrmToIPaasRpcService srmToIPaasRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public CustomerMasterDataDTO getByCustomerName(String elsAccount, String customerName) {
        CustomerMasterDataDTO customerMasterDataDTO = new CustomerMasterDataDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"customer_name", (Object)customerName);
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        CustomerMasterData one = (CustomerMasterData)((Object)this.customerMasterDataService.getOne((Wrapper)queryWrapper));
        if (one != null) {
            customerMasterDataDTO.setId(one.getId());
        }
        return customerMasterDataDTO;
    }

    public String saveMainDTO(CustomerMasterDataDTO customerMasterDataDTO) {
        CustomerMasterData customerMasterData = new CustomerMasterData();
        customerMasterData.setTemplateAccount(customerMasterDataDTO.getTemplateAccount());
        customerMasterData.setTemplateNumber(customerMasterDataDTO.getTemplateNumber());
        customerMasterData.setTemplateName(customerMasterDataDTO.getTemplateName());
        customerMasterData.setTemplateVersion(customerMasterDataDTO.getTemplateVersion());
        customerMasterData.setName(customerMasterDataDTO.getName());
        customerMasterData.setNeedAudit(customerMasterDataDTO.getNeedAudit());
        customerMasterData.setCustomerName(customerMasterDataDTO.getCustomerName());
        customerMasterData.setCustomerStatus(customerMasterDataDTO.getCustomerStatus());
        customerMasterData.setCustomerType(customerMasterDataDTO.getCustomerType());
        customerMasterData.setFbk3(customerMasterDataDTO.getFbk3());
        customerMasterData.setFbk1(customerMasterDataDTO.getFbk1());
        customerMasterData.setFbk6(customerMasterDataDTO.getFbk6());
        customerMasterData.setSourceType(CustomerSourceEnum.NEW.getValue());
        customerMasterData.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        customerMasterData.setFbk10(customerMasterDataDTO.getToElsAccount());
        LoginUser LoginUser2 = SysUtil.getLoginUser();
        List<String> localCustomers = this.customerMasterDataService.getAllCustomerNames(LoginUser2.getElsAccount());
        if (CollUtil.isNotEmpty(localCustomers)) {
            ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2;
            ElsEnterpriseInfoDTO enterpriseInfo;
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"customer_name", (Object)customerMasterData.getCustomerName())).or()).eq((Object)"to_els_account", (Object)customerMasterDataDTO.getToElsAccount());
            CustomerMasterData one = (CustomerMasterData)((Object)this.customerMasterDataService.getOne((Wrapper)queryWrapper));
            if (one != null) {
                return one.getToElsAccount();
            }
            LoginUser loginUser = new LoginUser();
            JSONObject result = this.srmToIPaasRpcService.callIPaasInterface(this.getIpaaSData(customerMasterData.getCustomerName(), null, loginUser.getElsAccount(), "0", null, customerMasterData.getIsPerson(), customerMasterData.getPhone()), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
            if (result.getBoolean("success").booleanValue() && (enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount((ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class)).getElsAccount())) != null) {
                return enterpriseInfo.getElsAccount();
            }
            CustomerMasterData customerMasterData1 = this.customerMasterDataService.saveMain(customerMasterData);
            return customerMasterData1.getToElsAccount();
        }
        return null;
    }

    public List<String> getTemplateByDesc() {
        ArrayList<String> list = new ArrayList<String>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        List list1 = this.customerMasterDataService.list((Wrapper)queryWrapper);
        list.add(((CustomerMasterData)((Object)list1.get(0))).getTemplateAccount());
        list.add(((CustomerMasterData)((Object)list1.get(0))).getTemplateNumber());
        list.add(((CustomerMasterData)((Object)list1.get(0))).getTemplateName());
        list.add(((CustomerMasterData)((Object)list1.get(0))).getTemplateVersion());
        return list;
    }

    public String getCustomerNumber(String customerName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"customer_name", (Object)customerName);
        CustomerMasterData masterDataServiceOne = (CustomerMasterData)((Object)this.customerMasterDataService.getOne((Wrapper)queryWrapper));
        if (masterDataServiceOne == null) {
            return null;
        }
        return masterDataServiceOne.getToElsAccount();
    }

    public String update(String industry, String toElsAccount) {
        LambdaUpdateWrapper customerMasterDataLambdaUpdateWrapper = new UpdateWrapper().lambda();
        customerMasterDataLambdaUpdateWrapper.eq(CustomerMasterData::getCustomerName, (Object)toElsAccount);
        customerMasterDataLambdaUpdateWrapper.set(CustomerMasterData::getFbk6, (Object)industry);
        this.customerMasterDataService.update((Wrapper)customerMasterDataLambdaUpdateWrapper);
        return null;
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount, String update, String account, String isPerson, String phone) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("is_person", (Object)isPerson);
        body.put("phone", (Object)phone);
        if ("1".equals(update)) {
            body.put("is_update", (Object)update);
            body.put("account", (Object)account);
        } else {
            body.put("channel", (Object)sourceType);
            body.put("auth", (Object)"1");
            body.put("failIsCreateAccount", (Object)"1");
        }
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }
}

