/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.email;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.email.sender.CommonMailSender;
import com.els.common.email.sender.ElsMailSender;
import com.els.common.email.sender.ExchangeMailSender;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.enumerate.MailProtocolType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class ElsEmailBuilder {
    private static final Logger log = LoggerFactory.getLogger(ElsEmailBuilder.class);

    public static boolean sendEmail(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        config.setContent(content);
        config.setEmailCc(cc);
        config.setNeedCc(needCc);
        config.setSubject(subject);
        config.setTo(new String[]{to});
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender(config, null, null);
        return mailSender.sendEmail(config, (BiFunction)null);
    }

    public static void sendEmailWithEp(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        config.setContent(content);
        config.setEmailCc(cc);
        config.setNeedCc(needCc);
        config.setSubject(subject);
        config.setTo(new String[]{to});
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender(config, null, null);
        mailSender.sendEmailWithThrowException(config, (BiFunction)null);
    }

    public static void sendEmailWithEp(ElsEmailConfigDTO config, String[] to, String subject, String content, String cc, boolean needCc) {
        config.setContent(content);
        config.setEmailCc(cc);
        config.setNeedCc(needCc);
        config.setSubject(subject);
        config.setTo(to);
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender(config, null, null);
        mailSender.sendEmailWithThrowException(config, (BiFunction)null);
    }

    public static ElsMailSender buildElsMailSender(ElsEmailConfigDTO config, Properties properties, BiConsumer<ElsEmailConfigDTO, Object> enhanceBuilder) {
        MailProtocolType protocolType = MailProtocolType.buildMailProtocolType((String)config.getType());
        if (null == protocolType) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u652f\u6301${0}\u90ae\u7bb1\u534f\u8bae\u914d\u7f6e", (String[])new String[]{config.getType()}));
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        if (null != config.getProps()) {
            JSONObject map = (JSONObject)JSON.parseObject((String)config.getProps(), JSONObject.class);
            prop = new HashMap();
            for (String k : map.keySet()) {
                prop.put(k, map.getString(k));
            }
        }
        switch (protocolType) {
            case imap: 
            case pop3: 
            case smtp: {
                return new CommonMailSender(ElsEmailBuilder.buildJavaMailSender(config, prop, enhanceBuilder));
            }
            case exchange: {
                return new ExchangeMailSender(ElsEmailBuilder.buildExchangeServiceSender(config, prop, enhanceBuilder));
            }
        }
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u652f\u6301${0}\u90ae\u7bb1\u534f\u8bae\u914d\u7f6e", (String[])new String[]{config.getType()}));
    }

    public static JavaMailSender buildJavaMailSender(ElsEmailConfigDTO config, Map<String, String> prop) {
        return ElsEmailBuilder.buildJavaMailSender(config, prop, null);
    }

    public static JavaMailSender buildJavaMailSender(ElsEmailConfigDTO config, Map<String, String> prop, BiConsumer<ElsEmailConfigDTO, Object> emailSenderEnhanceBuilder) {
        Properties defaultProperties = MailProtocolType.buildDefaultProperties((ElsEmailConfigDTO)config, (boolean)config.getType().equals(config.getProtocol() + "s"), (String)null);
        for (String key : prop.keySet()) {
            defaultProperties.put(key, prop.get(key));
        }
        ElsEmailBuilder.configCheck(config);
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setProtocol(CharSequenceUtil.isEmpty((CharSequence)config.getProtocol()) ? "stmp" : config.getProtocol());
        sender.setHost(config.getEmailHost());
        sender.setUsername(config.getEmailUsername());
        sender.setPassword(config.getEmailPassword());
        sender.setPort(null == config.getEmailPort() ? 25 : config.getEmailPort());
        sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(defaultProperties);
        if (null != emailSenderEnhanceBuilder) {
            emailSenderEnhanceBuilder.accept(config, sender);
        }
        return sender;
    }

    public static ExchangeService buildExchangeServiceSender(ElsEmailConfigDTO config, Map<String, String> prop) {
        return ElsEmailBuilder.buildExchangeServiceSender(config, prop, null);
    }

    public static ExchangeService buildExchangeServiceSender(ElsEmailConfigDTO config, Map<String, String> prop, BiConsumer<ElsEmailConfigDTO, Object> emailSenderEnhanceBuilder) {
        ElsEmailBuilder.configCheck(config);
        ExchangeVersion exchangeVersion = ExchangeVersion.Exchange2010;
        if (null != config.getExchangeVersion()) {
            exchangeVersion = ExchangeVersion.valueOf((String)config.getExchangeVersion().name());
        }
        try {
            ExchangeService exchangeService = new ExchangeService(exchangeVersion);
            WebCredentials exchangeCredentials = new WebCredentials(config.getEmailUsername(), config.getEmailPassword(), CharSequenceUtil.isEmpty((CharSequence)config.getDomain()) ? "" : config.getDomain());
            exchangeService.setCredentials((ExchangeCredentials)exchangeCredentials);
            exchangeService.setUrl(new URI("https://" + config.getEmailHost() + "/ews/Exchange.asmx"));
            if (null != emailSenderEnhanceBuilder) {
                emailSenderEnhanceBuilder.accept(config, exchangeService);
            }
            return exchangeService;
        }
        catch (Exception var6) {
            throw new ELSBootException(var6.getMessage());
        }
    }

    private static void configCheck(ElsEmailConfigDTO config) {
        if (null == config) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (!StringUtils.isEmpty((CharSequence)config.getEmailUsername()) && !StringUtils.isEmpty((CharSequence)config.getEmailPassword())) {
            if (StringUtils.isEmpty((CharSequence)config.getEmailHost())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001host\u4e0d\u80fd\u4e3a\u7a7a))"));
            }
            if (StringUtils.isEmpty((CharSequence)config.getType())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u534f\u8baetype\u4e0d\u80fd\u4e3a\u7a7a))"));
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
    }

    private static void applyProperties(MailProperties properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (!properties.getProperties().isEmpty()) {
            sender.setJavaMailProperties(ElsEmailBuilder.asProperties(properties.getProperties()));
        }
    }

    private static Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }
}

