/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.changeApply.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.changeApply.entity.PurchaseChangeApply;
import com.els.modules.changeApply.enumerate.ChangeApplyTypeEnum;
import com.els.modules.changeApply.service.PurchaseChangeApplyService;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseChangeApplyAuditCallBackServiceImpl")
public class PurchaseChangeApplyAuditCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseChangeApplyService purchaseChangeApplyService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper changeApplyLambdaQueryWrapper = new QueryWrapper().lambda();
        changeApplyLambdaQueryWrapper.eq(PurchaseChangeApply::getAuditStatus, (Object)AuditStatusEnum.AUDIT_DOING.getValue());
        changeApplyLambdaQueryWrapper.eq(BaseEntity::getCreateBy, (Object)loginUser.getSubAccount());
        List purchaseChangeApplyList = this.purchaseChangeApplyService.list((Wrapper)changeApplyLambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)purchaseChangeApplyList)) {
            throw new ELSBootException("\u6709\u5f02\u52a8\u7533\u8bf7\u5904\u7406\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4");
        }
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseChangeApply dbChangeApply = (PurchaseChangeApply)((Object)this.purchaseChangeApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (dbChangeApply != null) {
            PurchaseChangeApply purchaseChangeApply = new PurchaseChangeApply();
            purchaseChangeApply.setId(inputParamVO.getBusinessId());
            purchaseChangeApply.setAuditStatus(outputParamVO.getAuditStatus());
            purchaseChangeApply.setFlowId(outputParamVO.getProcessRootId());
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseChangeApply.getAuditStatus())) {
                LambdaUpdateWrapper employeInfoLambdaUpdateWrapper = new UpdateWrapper().lambda();
                employeInfoLambdaUpdateWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)dbChangeApply.getApplyUserId());
                if (ChangeApplyTypeEnum.DEPART.getValue().equals(dbChangeApply.getChangeType())) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getDepartment, (Object)dbChangeApply.getAfterPridep());
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getRole, (Object)dbChangeApply.getAfterPost());
                } else if (ChangeApplyTypeEnum.SKIP_DEPARTMEMT.getValue().equals(dbChangeApply.getChangeType())) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getRole, (Object)dbChangeApply.getAfterPost());
                } else if (ChangeApplyTypeEnum.POST_CHANGE.getValue().equals(dbChangeApply.getChangeType())) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getRole, (Object)dbChangeApply.getAfterPost());
                } else if (ChangeApplyTypeEnum.BASE_CHANGE.getValue().equals(dbChangeApply.getChangeType())) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getUserImages, (Object)dbChangeApply.getAfterCity());
                } else if (!ChangeApplyTypeEnum.SOCIE_CHANGE.getValue().equals(dbChangeApply.getChangeType()) && ChangeApplyTypeEnum.CONTRACT_CHANGE.getValue().equals(dbChangeApply.getChangeType())) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getCompany, (Object)dbChangeApply.getAfterContract());
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getPersonnelType, (Object)dbChangeApply.getPersonnelType());
                }
                this.elsEmployeInfoService.update((Wrapper)employeInfoLambdaUpdateWrapper);
            }
            this.purchaseChangeApplyService.updateById((Object)purchaseChangeApply);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

