/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.conversionApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.changeApply.utils.GetDepartmentLevelUtil;
import com.els.modules.conversionApply.entity.PurchaseConversionApply;
import com.els.modules.conversionApply.mapper.PurchaseConversionApplyMapper;
import com.els.modules.conversionApply.service.PurchaseConversionApplyService;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseConversionApplyServiceImpl
extends BaseServiceImpl<PurchaseConversionApplyMapper, PurchaseConversionApply>
implements PurchaseConversionApplyService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseConversionApply purchaseConversionApply, List<PurchaseAttachment> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper conversionApplyLambdaQueryWrapper = new QueryWrapper().lambda();
        conversionApplyLambdaQueryWrapper.eq(PurchaseConversionApply::getApplyUserId, (Object)loginUser.getId());
        PurchaseConversionApply dbConversionApply = (PurchaseConversionApply)((Object)this.getOne((Wrapper)conversionApplyLambdaQueryWrapper));
        if (dbConversionApply != null) {
            throw new ELSBootException("\u5f53\u524d\u8d26\u53f7\u5df2\u7ecf\u586b\u5199\u8fc7\u8f6c\u6b63\u7533\u8bf7\u4e0d\u80fd\u91cd\u590d\u521b\u5efa!");
        }
        purchaseConversionApply.setApplyUser(loginUser.getRealname());
        purchaseConversionApply.setApplyUserId(loginUser.getId());
        LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
        lambdaQueryWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)loginUser.getId());
        ElsEmployeInfo elsEmployeInfo = (ElsEmployeInfo)((Object)this.elsEmployeInfoService.getOne((Wrapper)lambdaQueryWrapper));
        if (elsEmployeInfo != null) {
            if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
                throw new ELSBootException("\u5f53\u524d\u8d26\u6237\u5458\u5de5\u72b6\u6001\u4e3a\u5df2\u79bb\u804c,\u4e0d\u80fd\u521b\u5efa\u7533\u8bf7\u5355!");
            }
            purchaseConversionApply.setEntryDate(elsEmployeInfo.getHireDate());
            purchaseConversionApply.setPost(elsEmployeInfo.getRole());
            purchaseConversionApply.setDepartment(elsEmployeInfo.getDepartment());
        }
        purchaseConversionApply.setApplyNum(this.invokeBaseRpcService.getNextCode("convertApply", (Object)purchaseConversionApply));
        purchaseConversionApply.setFbk1(String.valueOf(GetDepartmentLevelUtil.getNextDivision(purchaseConversionApply.getDepartment(), loginUser.getId())));
        ((PurchaseConversionApplyMapper)this.baseMapper).insert((Object)purchaseConversionApply);
        super.setHeadDefaultValue((BaseEntity)purchaseConversionApply);
        this.insertData(purchaseConversionApply, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseConversionApply purchaseConversionApply, List<PurchaseAttachment> purchaseAttachmentList) {
        int count = ((PurchaseConversionApplyMapper)this.baseMapper).updateById((Object)purchaseConversionApply);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(purchaseConversionApply.getId());
        this.insertData(purchaseConversionApply, purchaseAttachmentList);
    }

    private void insertData(PurchaseConversionApply purchaseConversionApply, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseConversionApply.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseConversionApply);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
        ((PurchaseConversionApplyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAttachmentService.deleteByMainId(serializable.toString());
            ((PurchaseConversionApplyMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

