/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.employ.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.employ.config.FinanceConfig;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartmentSyncScheduleJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentSyncScheduleJob.class);
    private Map<String, String> configMap = ((FinanceConfig)SpringContextUtils.getBean(FinanceConfig.class)).getConfig();
    private String tokenUrl = this.configMap.get("tokenUrl");
    private String departmentUrl = this.configMap.get("departmentUrl");
    private String clientId = this.configMap.get("clientId");
    private String clientSecret = this.configMap.get("clientSecret");
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;

    public void execute(String parameter) {
        long timestamp;
        HashMap<String, Object> map;
        Map parentOrgMap;
        List purchaseOrganizationInfoDTOS;
        List superExecutiveIdList;
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        List centerCostList = this.purchaseOrganizationInfoRpcService.listByCateCode(tenantId, "centerCost");
        List deptList = this.purchaseOrganizationInfoRpcService.listByCateCode(tenantId, "dept");
        ArrayList dataMaps = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)deptList)) {
            superExecutiveIdList = deptList.stream().map(PurchaseOrganizationInfoDTO::getSuperExecutiveId).collect(Collectors.toList());
            purchaseOrganizationInfoDTOS = this.purchaseOrganizationInfoRpcService.listByIds(superExecutiveIdList);
            parentOrgMap = purchaseOrganizationInfoDTOS.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
            for (PurchaseOrganizationInfoDTO dept : deptList) {
                ElsSubAccount subAccount;
                map = new HashMap<String, Object>();
                if (StringUtils.isNotBlank((String)dept.getOrgCode())) {
                    map.put("code", dept.getOrgCode());
                }
                map.put("cost_center_flag", "N");
                PurchaseOrganizationInfoDTO organizationInfoDTO = (PurchaseOrganizationInfoDTO)parentOrgMap.get(dept.getSuperExecutiveId());
                if (organizationInfoDTO != null) {
                    map.put("parent_code", organizationInfoDTO.getOrgCode());
                }
                if (StringUtils.isNotBlank((String)dept.getOrgName()) && "CEO".equals(dept.getOrgName())) {
                    map.put("parent_code", "B1");
                }
                if (StringUtils.isNotBlank((String)dept.getOrgName())) {
                    map.put("department_name", dept.getOrgName());
                }
                map.put("approval_level", dept.getOrgCode().length());
                if (StringUtils.isNotEmpty((String)dept.getFbk1()) && (subAccount = (ElsSubAccount)((ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class)).getById((Serializable)((Object)dept.getFbk1()))) != null) {
                    map.put("supervisor", subAccount.getWorkNo());
                }
                if ("1".equals(dept.getStatus())) {
                    map.put("enabled_flag", "Y");
                } else {
                    map.put("enabled_flag", "N");
                }
                map.put("type", "D");
                dataMaps.add(map);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)centerCostList)) {
            superExecutiveIdList = centerCostList.stream().map(PurchaseOrganizationInfoDTO::getSuperExecutiveId).collect(Collectors.toList());
            purchaseOrganizationInfoDTOS = this.purchaseOrganizationInfoRpcService.listByIds(superExecutiveIdList);
            parentOrgMap = purchaseOrganizationInfoDTOS.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
            for (PurchaseOrganizationInfoDTO costCenter : centerCostList) {
                ElsSubAccount subAccount;
                map = new HashMap();
                map.put("code", costCenter.getOrgCode());
                if (StringUtils.isNotBlank((String)costCenter.getSuperExecutiveId())) {
                    PurchaseOrganizationInfoDTO parentOrg = (PurchaseOrganizationInfoDTO)parentOrgMap.get(costCenter.getSuperExecutiveId());
                    if (parentOrg != null) {
                        map.put("parent_code", parentOrg.getOrgCode());
                    }
                } else {
                    map.put("parent_code", "B1");
                }
                map.put("department_name", costCenter.getOrgName());
                if (StringUtils.isNotEmpty((String)costCenter.getFbk1()) && (subAccount = (ElsSubAccount)((ElsSubAccountService)SpringContextUtils.getBean(ElsSubAccountService.class)).getById((Serializable)((Object)costCenter.getFbk1()))) != null) {
                    map.put("supervisor", subAccount.getWorkNo());
                }
                map.put("type", "C");
                if ("1".equals(costCenter.getStatus())) {
                    map.put("enabled_flag", "Y");
                } else {
                    map.put("enabled_flag", "N");
                }
                map.put("cost_center_flag", "Y");
                dataMaps.add(map);
            }
        }
        log.error("\u4e0a\u4f20\u90e8\u95e8\u4fe1\u606f\u7684map\u96c6\u5408\u6570\u636e==================={}", (Object)dataMaps.size());
        Object[] reqArrs = dataMaps.toArray();
        log.error("\u4e0a\u4f20\u90e8\u95e8\u6570\u636e\u4fe1\u606f============{}", (Object)reqArrs.length);
        String bizld = IdWorker.getIdStr();
        String token = this.getToken();
        log.error("\u4e91\u7b80token\uff1a=========={}", (Object)token);
        String departmentSynchronizationUrl = this.departmentUrl + "?access_token=" + token;
        long starttime = timestamp = System.currentTimeMillis();
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("bizld", bizld);
        reqMap.put("timestamp", timestamp);
        reqMap.put("data", reqArrs);
        String s = JSONObject.toJSONString(reqMap);
        log.error("\u90e8\u95e8\u8bf7\u6c42\u53c2\u6570==================={}", (Object)s);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = ((HttpRequest)HttpRequest.post((String)departmentSynchronizationUrl).addHeaders(header)).body(s).execute().body();
        JSONObject responseObj = JSONObject.parseObject((String)response);
        log.error("\u4e91\u7b80\u63a5\u53e3\u6279\u91cf\u540c\u6b65\u90e8\u95e8\u4fe1\u606f===={}", (Object)responseObj.toJSONString());
        long end = System.currentTimeMillis();
        log.error("\u6279\u91cf\u540c\u6b65\u4eba\u5458\u7a0b\u5e8f\u6267\u884c\u4e86" + (end - starttime) + "\u79d2\u3002==============");
    }

    private String getToken() {
        HashMap<String, String> reqtokenMap = new HashMap<String, String>();
        reqtokenMap.put("grant_type", "client_credentials");
        reqtokenMap.put("client_id", this.clientId);
        reqtokenMap.put("client_secret", this.clientSecret);
        HttpRequest httpRequest = HttpUtil.createGet((String)this.tokenUrl);
        httpRequest.form(reqtokenMap);
        String result = httpRequest.execute().body();
        JSONObject responseObj = JSONObject.parseObject((String)result);
        JSONObject jsonObject = (JSONObject)responseObj.get((Object)"data");
        String token = (String)jsonObject.get((Object)"access_token");
        return token;
    }

    private String convertCompanyCode(String company) {
        if ("C001".equals(company)) {
            return "B1";
        }
        if ("C010".equals(company)) {
            return "B2";
        }
        if ("C004".equals(company)) {
            return "B3";
        }
        if ("C002".equals(company)) {
            return "B4";
        }
        if ("C005".equals(company)) {
            return "B5";
        }
        if ("C006".equals(company)) {
            return "B6";
        }
        return null;
    }
}

