/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.employ.job;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.employ.config.FinanceConfig;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EmploySyncScheduleJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(EmploySyncScheduleJob.class);
    private Map<String, String> configMap = ((FinanceConfig)SpringContextUtils.getBean(FinanceConfig.class)).getConfig();
    private String tokenUrl = this.configMap.get("tokenUrl");
    private String userUrl = this.configMap.get("userUrl");
    private String clientId = this.configMap.get("clientId");
    private String clientSecret = this.configMap.get("clientSecret");
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    public void execute(String parameter) {
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        List employeInfoList = this.elsEmployeInfoService.list();
        if (!CollectionUtils.isEmpty((Collection)employeInfoList)) {
            int pageSize = 1500;
            int pages = employeInfoList.size() % pageSize == 0 ? employeInfoList.size() / pageSize : employeInfoList.size() / pageSize + 1;
            for (int currentPage = 1; currentPage <= pages; ++currentPage) {
                long timestamp;
                int firstIndex = (currentPage - 1) * pageSize + 1;
                int lastIndex = currentPage * pageSize;
                if (lastIndex > employeInfoList.size()) {
                    lastIndex = employeInfoList.size();
                }
                ArrayList userMaps = new ArrayList();
                for (int i = firstIndex; i <= lastIndex; ++i) {
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    ElsEmployeInfo elsEmployeInfo = (ElsEmployeInfo)((Object)employeInfoList.get(i - 1));
                    userMap.put("branch_code", this.convertCompanyCode(elsEmployeInfo.getCompany()));
                    userMap.put("code", elsEmployeInfo.getWorkNum());
                    userMap.put("nationality", "CHN");
                    String nickName = elsEmployeInfo.getLoginName();
                    if (nickName.contains("1") || nickName.contains("2") || nickName.contains("3") || nickName.contains("4") || nickName.contains("5") || nickName.contains("6") || nickName.contains("7") || nickName.contains("8") || nickName.contains("9")) {
                        nickName = nickName.substring(0, nickName.length() - 1);
                    }
                    userMap.put("full_name", nickName);
                    userMap.put("email_address", elsEmployeInfo.getEmail());
                    userMap.put("department_code", elsEmployeInfo.getDepartment());
                    userMap.put("cost_center_code", elsEmployeInfo.getCostCenter());
                    userMap.put("mobile", elsEmployeInfo.getPhone());
                    userMap.put("user_name", elsEmployeInfo.getEmail());
                    String enabledFlag = "Y";
                    if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
                        enabledFlag = "N";
                    } else if (elsEmployeInfo.getTermDate() != null && new Date().compareTo(elsEmployeInfo.getTermDate()) > 0) {
                        enabledFlag = "N";
                    }
                    userMap.put("enabled_flag", enabledFlag);
                    userMap.put("gender", elsEmployeInfo.getSex());
                    if (StringUtils.isNotEmpty((String)elsEmployeInfo.getUserImages())) {
                        userMap.put("base_city", elsEmployeInfo.getUserImages());
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (elsEmployeInfo.getBirthDate() != null) {
                        userMap.put("birthday", simpleDateFormat.format(elsEmployeInfo.getBirthDate()));
                    }
                    if (elsEmployeInfo.getHireDate() != null) {
                        userMap.put("date_of_joining", simpleDateFormat.format(elsEmployeInfo.getHireDate()));
                    }
                    if (elsEmployeInfo.getTermDate() != null) {
                        userMap.put("resignation_date", simpleDateFormat.format(elsEmployeInfo.getTermDate()));
                    } else {
                        userMap.put("resignation_date", null);
                    }
                    if (StringUtils.isNotEmpty((String)elsEmployeInfo.getIdNumber())) {
                        userMap.put("id_card", elsEmployeInfo.getIdNumber());
                    }
                    userMaps.add(userMap);
                }
                log.error("\u4e0a\u4f20\u5458\u5de5\u4fe1\u606f\u7684map\u96c6\u5408\u6570\u636e==================={}", (Object)userMaps.size());
                Object[] reqArrs = userMaps.toArray();
                log.error("\u4e0a\u4f20\u4eba\u5458\u6570\u636e\u4fe1\u606f============{}", (Object)reqArrs.length);
                String bizld = IdWorker.getIdStr();
                String token = this.getToken();
                log.error("\u4e91\u7b80token\uff1a=========={}", (Object)token);
                String userSynchronizationUrl = this.userUrl + "?access_token=" + token;
                long starttime = timestamp = System.currentTimeMillis();
                HashMap<String, Object> reqMap = new HashMap<String, Object>();
                reqMap.put("bizld", bizld);
                reqMap.put("timestamp", timestamp);
                reqMap.put("data", reqArrs);
                String s = JSONObject.toJSONString(reqMap);
                log.error("\u8bf7\u6c42\u53c2\u6570==================={}", (Object)s);
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Content-Type", "application/json");
                String response = ((HttpRequest)HttpRequest.post((String)userSynchronizationUrl).addHeaders(header)).body(s).execute().body();
                JSONObject responseObj = JSONObject.parseObject((String)response);
                log.error("\u4e91\u7b80\u63a5\u53e3\u6279\u91cf\u540c\u6b65\u4eba\u5458\u4fe1\u606f===={}", (Object)responseObj.toJSONString());
                long end = System.currentTimeMillis();
                log.error("\u6279\u91cf\u540c\u6b65\u4eba\u5458\u7a0b\u5e8f\u6267\u884c\u4e86" + (end - starttime) + "\u79d2\u3002==============");
            }
        }
    }

    private String getToken() {
        HashMap<String, String> reqtokenMap = new HashMap<String, String>();
        reqtokenMap.put("grant_type", "client_credentials");
        reqtokenMap.put("client_id", this.clientId);
        reqtokenMap.put("client_secret", this.clientSecret);
        HttpRequest httpRequest = HttpUtil.createGet((String)this.tokenUrl);
        httpRequest.form(reqtokenMap);
        String result = httpRequest.execute().body();
        JSONObject responseObj = JSONObject.parseObject((String)result);
        JSONObject jsonObject = (JSONObject)responseObj.get((Object)"data");
        String token = (String)jsonObject.get((Object)"access_token");
        return token;
    }

    private String convertCompanyCode(String company) {
        if ("C001".equals(company)) {
            return "B1";
        }
        if ("C002".equals(company)) {
            return "B2";
        }
        if ("C004".equals(company)) {
            return "B3";
        }
        if ("C006".equals(company)) {
            return "B4";
        }
        if ("C005".equals(company)) {
            return "B5";
        }
        if ("C007".equals(company)) {
            return "B6";
        }
        return null;
    }
}

