/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.employ.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.mapper.ElsEmployeInfoMapper;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.employCost.entity.PurchaseBaseEmployeeCost;
import com.els.modules.employCost.service.PurchaseBaseEmployeeCostService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.postToRole.entity.PurchasePostRole;
import com.els.modules.postToRole.enumerate.PostToRoleStatusEnum;
import com.els.modules.postToRole.service.PurchasePostRoleService;
import com.els.modules.system.controller.ElsSubAccountController;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsEmployeInfoServiceImpl
extends BaseServiceImpl<ElsEmployeInfoMapper, ElsEmployeInfo>
implements ElsEmployeInfoService {
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private ElsSubAccountController elsSubAccountController;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PurchasePostRoleService purchasePostRoleService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Autowired
    private PurchaseBaseEmployeeCostService purchaseBaseEmployeeCostService;

    @Override
    @Transactional
    public void add(ElsEmployeInfo elsEmployeInfo, List<PurchaseAttachment> purchaseAttachmentList) {
        String employNumber = this.invokeBaseRpcService.getNextCode("employeInfo", (Object)elsEmployeInfo);
        employNumber = employNumber.replace("MM", elsEmployeInfo.getPersonnelType());
        elsEmployeInfo.setWorkNum(employNumber);
        if (EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
            LambdaQueryWrapper postRoleLambdaQueryWrapper = new QueryWrapper().lambda();
            postRoleLambdaQueryWrapper.eq(PurchasePostRole::getPostId, (Object)elsEmployeInfo.getRole());
            postRoleLambdaQueryWrapper.eq(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.START.getValue());
            postRoleLambdaQueryWrapper.ne(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.CANCEL.getValue());
            PurchasePostRole postRole = (PurchasePostRole)((Object)this.purchasePostRoleService.getOne((Wrapper)postRoleLambdaQueryWrapper));
            if (postRole == null) {
                throw new ELSBootException("\u5f53\u524d\u7684\u5c97\u4f4d\u6ca1\u6709\u5728\u5c97\u4f4d\u89d2\u8272\u914d\u7f6e\u4e2d\u6ca1\u6709\u6570\u636e!");
            }
            PurchaseOrganizationInfoDTO orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", elsEmployeInfo.getDepartment());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("selectedroles", (Object)postRole.getRoleIds());
            jsonObject.put("realname", (Object)elsEmployeInfo.getLoginName());
            jsonObject.put("subAccount", (Object)elsEmployeInfo.getLoginNamePy());
            jsonObject.put("password", (Object)elsEmployeInfo.getPhone());
            jsonObject.put("workNo", (Object)employNumber);
            if (orgInfo != null) {
                jsonObject.put("orgCode", (Object)orgInfo.getId());
                jsonObject.put("superiorLeader", (Object)orgInfo.getExecutivePerson());
            }
            jsonObject.put("phone", (Object)elsEmployeInfo.getPhone());
            jsonObject.put("email", (Object)elsEmployeInfo.getEmail());
            jsonObject.put("workNo", (Object)employNumber);
            Result result = this.elsSubAccountController.add(jsonObject);
            JSONObject subAccount = (JSONObject)result.getResult();
            elsEmployeInfo.setSubAccountId(subAccount.getString("id"));
        }
        if (StringUtils.isNotEmpty((String)elsEmployeInfo.getDepartment())) {
            PurchaseOrganizationInfoDTO depyOrg = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", elsEmployeInfo.getDepartment());
            if (depyOrg != null) {
                elsEmployeInfo.setCostCenter(depyOrg.getFbk5());
            } else {
                elsEmployeInfo.setCostCenter("");
            }
        }
        if (StringUtils.isNotEmpty((String)elsEmployeInfo.getCostcategory())) {
            this.addEmployCost(elsEmployeInfo);
        }
        ((ElsEmployeInfoMapper)this.baseMapper).insert((Object)elsEmployeInfo);
        this.insertData(elsEmployeInfo, purchaseAttachmentList);
    }

    private void addEmployCost(ElsEmployeInfo elsEmployeInfo) {
        String employeeCostText = this.invokeBaseRpcService.queryDictTextByKey("employee_cost", elsEmployeInfo.getCostcategory(), TenantContext.getTenant());
        PurchaseBaseEmployeeCost purchaseBaseEmployeeCost = new PurchaseBaseEmployeeCost();
        purchaseBaseEmployeeCost.setId(IdWorker.getIdStr());
        purchaseBaseEmployeeCost.setTemplateNumber("TC2022121302");
        purchaseBaseEmployeeCost.setTemplateName("\u6210\u672c\u7ba1\u7406\u6807\u51c6\u6a21\u7248");
        purchaseBaseEmployeeCost.setTemplateVersion("1");
        purchaseBaseEmployeeCost.setTemplateAccount("100000");
        purchaseBaseEmployeeCost.setElsAccount(TenantContext.getTenant());
        purchaseBaseEmployeeCost.setBusAccount(TenantContext.getTenant());
        purchaseBaseEmployeeCost.setCostCategory(employeeCostText);
        purchaseBaseEmployeeCost.setCostValue(Integer.parseInt(elsEmployeInfo.getCostcategory()));
        purchaseBaseEmployeeCost.setCostStartDate(new Date());
        purchaseBaseEmployeeCost.setEnable(CommonConstant.YES_1);
        purchaseBaseEmployeeCost.setOneDayWorkHours(new BigDecimal("8"));
        purchaseBaseEmployeeCost.setUserId(elsEmployeInfo.getSubAccountId());
        purchaseBaseEmployeeCost.setLoginName(elsEmployeInfo.getLoginName());
        purchaseBaseEmployeeCost.setNickName(elsEmployeInfo.getLoginNamePy());
        purchaseBaseEmployeeCost.setDepartment(elsEmployeInfo.getDepartment());
        purchaseBaseEmployeeCost.setWorkNum(elsEmployeInfo.getWorkNum());
        this.purchaseBaseEmployeeCostService.add(purchaseBaseEmployeeCost);
    }

    private void insertData(ElsEmployeInfo elsEmployeInfo, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(elsEmployeInfo.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsEmployeInfo);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional
    public void edit(ElsEmployeInfo elsEmployeInfo, List<PurchaseAttachment> purchaseAttachmentList) {
        ElsEmployeInfo dbElsEmployeInfo = (ElsEmployeInfo)((Object)this.getById((Serializable)((Object)elsEmployeInfo.getId())));
        if (dbElsEmployeInfo == null) {
            throw new ELSBootException("\u8be5\u5355\u636e\u4e0d\u5b58\u5728\u8bf7\u4ed4\u7ec6\u68c0\u67e5");
        }
        if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus()) && StringUtils.isNotEmpty((String)elsEmployeInfo.getSubAccountId())) {
            this.frozenSubaccountInfo(elsEmployeInfo);
        } else if ((EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) && StringUtils.isEmpty((String)elsEmployeInfo.getSubAccountId())) {
            this.createSubaccountInfo(elsEmployeInfo);
        } else if ((EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) && StringUtils.isNotEmpty((String)elsEmployeInfo.getSubAccountId())) {
            this.syncSubaccountInfo(elsEmployeInfo, dbElsEmployeInfo);
        }
        this.settingCostCenter(elsEmployeInfo);
        this.syncCostCategory(elsEmployeInfo, dbElsEmployeInfo);
        int count = ((ElsEmployeInfoMapper)this.baseMapper).updateById((Object)elsEmployeInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(elsEmployeInfo.getId());
        this.insertData(elsEmployeInfo, purchaseAttachmentList);
    }

    private void syncCostCategory(ElsEmployeInfo elsEmployeInfo, ElsEmployeInfo dbElsEmployeInfo) {
        if (StringUtils.isNotEmpty((String)elsEmployeInfo.getCostcategory()) && StringUtils.isNotEmpty((String)dbElsEmployeInfo.getCostcategory()) && (dbElsEmployeInfo == null || !dbElsEmployeInfo.getCostcategory().equals(elsEmployeInfo.getCostcategory()))) {
            this.syncEmployCost(elsEmployeInfo);
        }
    }

    private void settingCostCenter(ElsEmployeInfo elsEmployeInfo) {
        if (StringUtils.isNotEmpty((String)elsEmployeInfo.getDepartment())) {
            PurchaseOrganizationInfoDTO depyOrg = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", elsEmployeInfo.getDepartment());
            if (depyOrg != null) {
                elsEmployeInfo.setCostCenter(depyOrg.getFbk5());
            } else {
                elsEmployeInfo.setCostCenter("");
            }
        }
    }

    private void frozenSubaccountInfo(ElsEmployeInfo elsEmployeInfo) {
        LambdaUpdateWrapper subAccountWrapper = new UpdateWrapper().lambda();
        subAccountWrapper.eq(BaseEntity::getId, (Object)elsEmployeInfo.getSubAccountId());
        subAccountWrapper.set(ElsSubAccount::getStatus, (Object)AccountStatusEnum.FROZEN.getCode());
        this.elsSubAccountService.update((Wrapper)subAccountWrapper);
    }

    private void syncSubaccountInfo(ElsEmployeInfo elsEmployeInfo, ElsEmployeInfo dbElsEmployeInfo) {
        if (!elsEmployeInfo.getRole().equals(dbElsEmployeInfo.getRole())) {
            this.removeAllRoles(dbElsEmployeInfo);
            LambdaQueryWrapper postRoleLambdaQueryWrapper = new QueryWrapper().lambda();
            postRoleLambdaQueryWrapper.eq(PurchasePostRole::getPostId, (Object)elsEmployeInfo.getRole());
            postRoleLambdaQueryWrapper.eq(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.START.getValue());
            postRoleLambdaQueryWrapper.ne(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.CANCEL.getValue());
            PurchasePostRole postRole = (PurchasePostRole)((Object)this.purchasePostRoleService.getOne((Wrapper)postRoleLambdaQueryWrapper));
            if (postRole != null) {
                List<String> roleIds = Arrays.asList(postRole.getRoleIds().split(","));
                ArrayList<UserRole> paramsUserRole = new ArrayList<UserRole>();
                for (String roleId : roleIds) {
                    UserRole userRole = new UserRole();
                    userRole.setId(IdWorker.getIdStr());
                    userRole.setUserId(elsEmployeInfo.getSubAccountId());
                    userRole.setRoleId(roleId);
                    paramsUserRole.add(userRole);
                }
                this.userRoleService.saveBatch(paramsUserRole);
            }
        }
        PurchaseOrganizationInfoDTO orgInfo = this.getSuperOrg(elsEmployeInfo);
        LambdaUpdateWrapper subAccountWrapper = new UpdateWrapper().lambda();
        subAccountWrapper.eq(BaseEntity::getId, (Object)elsEmployeInfo.getSubAccountId());
        subAccountWrapper.set(ElsSubAccount::getStatus, (Object)AccountStatusEnum.NORMAL.getCode());
        if (orgInfo != null) {
            subAccountWrapper.set(ElsSubAccount::getOrgCode, (Object)orgInfo.getId());
            subAccountWrapper.set(ElsSubAccount::getSuperiorLeader, (Object)orgInfo.getExecutivePerson());
        }
        this.elsSubAccountService.update((Wrapper)subAccountWrapper);
    }

    private void createSubaccountInfo(ElsEmployeInfo elsEmployeInfo) {
        LambdaQueryWrapper postRoleLambdaQueryWrapper = new QueryWrapper().lambda();
        postRoleLambdaQueryWrapper.eq(PurchasePostRole::getPostId, (Object)elsEmployeInfo.getRole());
        postRoleLambdaQueryWrapper.eq(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.START.getValue());
        postRoleLambdaQueryWrapper.ne(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.CANCEL.getValue());
        PurchasePostRole postRole = (PurchasePostRole)((Object)this.purchasePostRoleService.getOne((Wrapper)postRoleLambdaQueryWrapper));
        if (postRole == null) {
            throw new ELSBootException("\u5f53\u524d\u7684\u5c97\u4f4d\u6ca1\u6709\u5728\u5c97\u4f4d\u89d2\u8272\u914d\u7f6e\u4e2d\u6ca1\u6709\u6570\u636e!");
        }
        PurchaseOrganizationInfoDTO orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", elsEmployeInfo.getDepartment());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("selectedroles", (Object)postRole.getRoleIds());
        jsonObject.put("realname", (Object)elsEmployeInfo.getLoginName());
        jsonObject.put("subAccount", (Object)elsEmployeInfo.getLoginNamePy());
        jsonObject.put("password", (Object)elsEmployeInfo.getPhone());
        jsonObject.put("workNo", (Object)elsEmployeInfo.getWorkNum());
        if (orgInfo != null) {
            jsonObject.put("orgCode", (Object)orgInfo.getId());
            jsonObject.put("superiorLeader", (Object)orgInfo.getExecutivePerson());
        }
        jsonObject.put("phone", (Object)elsEmployeInfo.getPhone());
        jsonObject.put("email", (Object)elsEmployeInfo.getEmail());
        Result result = this.elsSubAccountController.add(jsonObject);
        JSONObject subAccount = (JSONObject)result.getResult();
        elsEmployeInfo.setSubAccountId(subAccount.getString("id"));
    }

    private PurchaseOrganizationInfoDTO getSuperOrg(ElsEmployeInfo elsEmployeInfo) {
        PurchaseOrganizationInfoDTO orgInfo;
        PurchaseOrganizationInfoDTO tempOrg = orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", elsEmployeInfo.getDepartment());
        while (tempOrg != null) {
            if (!(elsEmployeInfo.getLoginNamePy() + "_" + elsEmployeInfo.getLoginName()).equals(tempOrg.getExecutivePerson())) {
                orgInfo.setExecutivePerson(tempOrg.getExecutivePerson());
                break;
            }
            tempOrg = this.purchaseOrganizationInfoRpcService.selectById(tempOrg.getSuperExecutiveId());
        }
        return orgInfo;
    }

    private void syncEmployCost(ElsEmployeInfo elsEmployeInfo) {
        LambdaQueryWrapper employeeCostLambdaQueryWrapper = new QueryWrapper().lambda();
        employeeCostLambdaQueryWrapper.eq(PurchaseBaseEmployeeCost::getUserId, (Object)elsEmployeInfo.getSubAccountId());
        employeeCostLambdaQueryWrapper.eq(PurchaseBaseEmployeeCost::getEnable, (Object)CommonConstant.YES_1);
        PurchaseBaseEmployeeCost baseEmployeeCost = (PurchaseBaseEmployeeCost)((Object)this.purchaseBaseEmployeeCostService.getOne((Wrapper)employeeCostLambdaQueryWrapper));
        if (baseEmployeeCost == null) {
            this.addEmployCost(elsEmployeInfo);
        } else {
            this.updateEmployCost(elsEmployeInfo, baseEmployeeCost);
        }
    }

    private void updateEmployCost(ElsEmployeInfo elsEmployeInfo, PurchaseBaseEmployeeCost baseEmployeeCost) {
        String employeeCostText = this.invokeBaseRpcService.queryDictTextByKey("employee_cost", elsEmployeInfo.getCostcategory(), TenantContext.getTenant());
        baseEmployeeCost.setCostStartDate(new Date());
        baseEmployeeCost.setCostCategory(employeeCostText);
        baseEmployeeCost.setCostValue(Integer.parseInt(elsEmployeInfo.getCostcategory()));
        this.purchaseBaseEmployeeCostService.edit(baseEmployeeCost);
    }

    @Override
    @Transactional
    public void delete(String id) {
        ((ElsEmployeInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> idList) {
        ((ElsEmployeInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void syncUserDepartment() {
        List elsEmployeInfoList = this.list();
        int i = 1;
        for (ElsEmployeInfo elsEmployeInfo : elsEmployeInfoList) {
            System.out.println("\u5904\u7406" + i + "/" + elsEmployeInfoList.size());
            ++i;
            if (StringUtils.isEmpty((String)elsEmployeInfo.getSubAccountId())) continue;
            PurchaseOrganizationInfoDTO orgInfo = this.getSuperOrg(elsEmployeInfo);
            LambdaUpdateWrapper subAccountWrapper = new UpdateWrapper().lambda();
            subAccountWrapper.eq(BaseEntity::getId, (Object)elsEmployeInfo.getSubAccountId());
            if (orgInfo == null) continue;
            subAccountWrapper.set(ElsSubAccount::getOrgCode, (Object)orgInfo.getId());
            subAccountWrapper.set(ElsSubAccount::getSuperiorLeader, (Object)orgInfo.getExecutivePerson());
            this.elsSubAccountService.update((Wrapper)subAccountWrapper);
        }
        System.out.println("\u6267\u884c\u5b8c\u6210");
    }

    private void removeAllRoles(ElsEmployeInfo employInfo) {
        if (StringUtils.isNotEmpty((String)employInfo.getSubAccountId())) {
            LambdaQueryWrapper userRoleLambdaQueryWrapper = new QueryWrapper().lambda();
            userRoleLambdaQueryWrapper.eq(UserRole::getUserId, (Object)employInfo.getSubAccountId());
            List userRoleList = this.userRoleService.list((Wrapper)userRoleLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)userRoleList)) {
                List userRoleIds = userRoleList.stream().map(UserRole::getId).distinct().collect(Collectors.toList());
                this.userRoleService.removeByIds(userRoleIds);
            }
        }
    }
}

