/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.employCost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.employCost.entity.PurchaseBaseEmployeeCost;
import com.els.modules.employCost.entity.PurchaseBaseEmployeeCostHis;
import com.els.modules.employCost.mapper.PurchaseBaseEmployeeCostMapper;
import com.els.modules.employCost.service.PurchaseBaseEmployeeCostHisService;
import com.els.modules.employCost.service.PurchaseBaseEmployeeCostService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBaseEmployeeCostServiceImpl
extends BaseServiceImpl<PurchaseBaseEmployeeCostMapper, PurchaseBaseEmployeeCost>
implements PurchaseBaseEmployeeCostService {
    @Autowired
    private PurchaseBaseEmployeeCostHisService employeeCostHisService;

    @Override
    public void add(PurchaseBaseEmployeeCost purchaseBaseEmployeeCost) {
        this.validateData(purchaseBaseEmployeeCost);
        BigDecimal temp = new BigDecimal(purchaseBaseEmployeeCost.getCostValue()).divide(purchaseBaseEmployeeCost.getOneDayWorkHours(), 2, 4);
        purchaseBaseEmployeeCost.setHoursCost(temp);
        ((PurchaseBaseEmployeeCostMapper)this.baseMapper).insert((Object)purchaseBaseEmployeeCost);
    }

    private void validateData(PurchaseBaseEmployeeCost purchaseBaseEmployeeCost) {
        BigDecimal oneDayWorkHours;
        BigDecimal bigDecimal = oneDayWorkHours = purchaseBaseEmployeeCost.getOneDayWorkHours() == null ? BigDecimal.ZERO : purchaseBaseEmployeeCost.getOneDayWorkHours();
        if (oneDayWorkHours.compareTo(BigDecimal.ZERO) < 0) {
            throw new ELSBootException("\u5de5\u4f5c\u65f6\u957f\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (oneDayWorkHours.compareTo(new BigDecimal("24")) > 0) {
            throw new ELSBootException("\u5de5\u4f5c\u65f6\u957f\u4e0d\u80fd\u5927\u4e8e24");
        }
        LambdaQueryWrapper employeeCostLambdaQueryWrapper = new QueryWrapper().lambda();
        employeeCostLambdaQueryWrapper.eq(PurchaseBaseEmployeeCost::getUserId, (Object)purchaseBaseEmployeeCost.getUserId());
        employeeCostLambdaQueryWrapper.ne(PurchaseBaseEmployeeCost::getEnable, (Object)"1");
        PurchaseBaseEmployeeCost baseEmployeeCost = (PurchaseBaseEmployeeCost)((Object)this.getOne((Wrapper)employeeCostLambdaQueryWrapper));
        if (baseEmployeeCost != null) {
            throw new ELSBootException("\u6b64\u7528\u6237\u5df2\u6dfb\u52a0\u4e86\u6210\u672c\u4fe1\u606f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
    }

    @Override
    public void edit(PurchaseBaseEmployeeCost purchaseBaseEmployeeCost) {
        this.validateData(purchaseBaseEmployeeCost);
        PurchaseBaseEmployeeCost dbBaseEmployeeCost = (PurchaseBaseEmployeeCost)((Object)this.getById((Serializable)((Object)purchaseBaseEmployeeCost.getId())));
        BigDecimal temp = new BigDecimal(purchaseBaseEmployeeCost.getCostValue()).divide(purchaseBaseEmployeeCost.getOneDayWorkHours(), 2, 4);
        purchaseBaseEmployeeCost.setHoursCost(temp);
        int count = ((PurchaseBaseEmployeeCostMapper)this.baseMapper).updateById((Object)purchaseBaseEmployeeCost);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if (!DateUtils.isSameDay((Date)purchaseBaseEmployeeCost.getCostStartDate(), (Date)dbBaseEmployeeCost.getCostStartDate())) {
            PurchaseBaseEmployeeCostHis hisCost = new PurchaseBaseEmployeeCostHis();
            BeanUtils.copyProperties((Object)((Object)dbBaseEmployeeCost), (Object)((Object)hisCost));
            hisCost.setId(null);
            hisCost.setUpdateTime(null);
            hisCost.setHisId(dbBaseEmployeeCost.getId());
            hisCost.setCreateTime(new Date());
            hisCost.setCostEndDate(dbBaseEmployeeCost.getCostStartDate());
            this.employeeCostHisService.save((Object)hisCost);
        }
    }

    @Override
    public void delete(String id) {
        ((PurchaseBaseEmployeeCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseBaseEmployeeCostMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

