/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.manLeaveApply.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.manLeaveApply.entity.PurchaseManLeave;
import com.els.modules.manLeaveApply.enumerate.BackHolidayStatusEnum;
import com.els.modules.manLeaveApply.service.PurchaseManLeaveService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseManLeaveApplyAuditCallBackServiceImpl")
public class PurchaseManLeaveApplyAuditCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseManLeaveService purchaseManLeaveService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseManLeave dbManLeave = (PurchaseManLeave)((Object)this.purchaseManLeaveService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (dbManLeave != null) {
            PurchaseManLeave purchaseManLeave = new PurchaseManLeave();
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(dbManLeave.getAuditStatus())) {
                purchaseManLeave.setId(inputParamVO.getBusinessId());
                if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
                    purchaseManLeave.setRemoveLeaveStatus(BackHolidayStatusEnum.HAD_BACK.getValue());
                } else {
                    purchaseManLeave.setRemoveLeaveStatus(BackHolidayStatusEnum.BACKING.getValue());
                }
                purchaseManLeave.setRemoveLeaveFlowId(outputParamVO.getProcessRootId());
            } else {
                purchaseManLeave.setId(inputParamVO.getBusinessId());
                purchaseManLeave.setAuditStatus(outputParamVO.getAuditStatus());
                purchaseManLeave.setFlowId(outputParamVO.getProcessRootId());
            }
            this.purchaseManLeaveService.updateById((Object)purchaseManLeave);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

