/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.manLeaveApply.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.manLeaveApply.entity.PurchaseManLeave;
import com.els.modules.manLeaveApply.enumerate.LeaveTypeEnum;
import com.els.modules.manLeaveApply.excel.PurchaseManLeaveExportServiceImpl;
import com.els.modules.manLeaveApply.service.PurchaseManLeaveService;
import com.els.modules.manLeaveApply.vo.PurchaseManLeaveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/manLeaveApply/purchaseManLeave"})
@Api(tags={"\u8bf7\u5047\u7533\u8bf7"})
public class PurchaseManLeaveController
extends BaseController<PurchaseManLeave, PurchaseManLeaveService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseManLeaveController.class);
    @Autowired
    private PurchaseManLeaveService purchaseManLeaveService;
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:list"})
    @PermissionDataView(businessType="manLeaveApply")
    public Result<?> queryPageList(PurchaseManLeave purchaseManLeave, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseManLeave), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseManLeaveService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @FormCommit
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:add"})
    public Result<?> add(@RequestBody PurchaseManLeaveVO purchaseManLeavePage) {
        PurchaseManLeave purchaseManLeave = new PurchaseManLeave();
        BeanUtils.copyProperties((Object)((Object)purchaseManLeavePage), (Object)((Object)purchaseManLeave));
        if (LeaveTypeEnum.EXCHANGE_LEAVE.getValue().equals(purchaseManLeave.getLeaveType()) && StringUtils.isEmpty((String)purchaseManLeave.getOvertimeDate())) {
            throw new ELSBootException("\u5f53\u524d\u5355\u636e\u8bf7\u5047\u7c7b\u578b\u4e3a\u8c03\u4f11\uff0c\u8bf7\u586b\u5199\u8c03\u4f11\u65e5\u671f");
        }
        this.purchaseManLeaveService.saveMain(purchaseManLeave, purchaseManLeavePage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseManLeave));
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u8ba1\u7b97\u8bf7\u5047\u5929\u6570")
    @ApiOperation(value="\u8ba1\u7b97\u8bf7\u5047\u5929\u6570", notes="\u8ba1\u7b97\u8bf7\u5047\u5929\u6570")
    @PostMapping(value={"/computerHoliday"})
    @FormCommit
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:add"})
    public Result<?> computerHoliday(@RequestBody PurchaseManLeaveVO purchaseManLeavePage) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String leaveDays = this.purchaseManLeaveService.daysNoHolidays(purchaseManLeavePage.getLeaveType(), purchaseManLeavePage.getLeaveStartDate(), purchaseManLeavePage.getLeaveEndDate(), loginUser.getElsAccount());
        return Result.ok((String)leaveDays);
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u7533\u8bf7\u9500\u5047")
    @ApiOperation(value="\u7533\u8bf7\u9500\u5047", notes="\u7533\u8bf7\u9500\u5047")
    @PostMapping(value={"/backHoliDay"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:backHoliDay"})
    public Result<?> backHoliDay(@RequestBody PurchaseManLeaveVO purchaseManLeavePage) {
        PurchaseManLeave purchaseManLeave = new PurchaseManLeave();
        BeanUtils.copyProperties((Object)((Object)purchaseManLeavePage), (Object)((Object)purchaseManLeave));
        this.purchaseManLeaveService.backHoliDay(purchaseManLeave, purchaseManLeavePage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseManLeave));
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @FormCommit
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:edit"})
    public Result<?> edit(@RequestBody PurchaseManLeaveVO purchaseManLeavePage) {
        PurchaseManLeave purchaseManLeave = new PurchaseManLeave();
        BeanUtils.copyProperties((Object)((Object)purchaseManLeavePage), (Object)((Object)purchaseManLeave));
        this.purchaseManLeaveService.updateMain(purchaseManLeave, purchaseManLeavePage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseManLeaveService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u8bf7\u5047\u7533\u8bf7", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseManLeaveService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseManLeave purchaseManLeave = (PurchaseManLeave)((Object)this.purchaseManLeaveService.getById((Serializable)((Object)id)));
        PurchaseManLeaveVO purchaseManLeaveVO = new PurchaseManLeaveVO();
        BeanUtils.copyProperties((Object)((Object)purchaseManLeave), (Object)((Object)purchaseManLeaveVO));
        List purchaseAttachmentList = this.purchaseAttachmentService.selectByMainId(id);
        purchaseManLeaveVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseManLeaveVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u8bf7\u5047\u7533\u8bf7id\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u8bf7\u5047\u7533\u8bf7id\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:queryById"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id") String id) {
        List purchaseAttachmentList = this.purchaseAttachmentService.selectByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(value="manLeaveApply")
    @RequiresPermissions(value={"manLeaveApply#purchaseManLeave:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseManLeaveExportServiceImpl.class);
    }
}

