/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.manLeaveApply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.changeApply.utils.GetDepartmentLevelUtil;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.manLeaveApply.entity.PurchaseManLeave;
import com.els.modules.manLeaveApply.enumerate.BackHolidayStatusEnum;
import com.els.modules.manLeaveApply.enumerate.HrbpEnum;
import com.els.modules.manLeaveApply.enumerate.LeaveTypeEnum;
import com.els.modules.manLeaveApply.mapper.PurchaseManLeaveMapper;
import com.els.modules.manLeaveApply.service.PurchaseManLeaveService;
import com.els.modules.workflow.api.service.impl.WorkflowAuditBeanServiceImpl;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workhours.service.EmployeeWorkHoursService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseManLeaveServiceImpl
extends BaseServiceImpl<PurchaseManLeaveMapper, PurchaseManLeave>
implements PurchaseManLeaveService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;
    @Autowired
    private WorkflowAuditBeanServiceImpl workflowAuditBeanServiceImpl;
    @Autowired
    private EmployeeWorkHoursService employeeWorkHoursService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (purchaseManLeave.getLeaveStartDate() != null && purchaseManLeave.getLeaveEndDate() != null) {
            String leaveDays = this.daysNoHolidays(purchaseManLeave.getLeaveType(), purchaseManLeave.getLeaveStartDate(), purchaseManLeave.getLeaveEndDate(), loginUser.getElsAccount());
            purchaseManLeave.setLeaveDays(new BigDecimal(leaveDays));
        }
        purchaseManLeave.setUserName(loginUser.getRealname());
        purchaseManLeave.setUserId(loginUser.getId());
        purchaseManLeave.setManLeaveNum(this.invokeBaseRpcService.getNextCode("manLeaveApply", (Object)purchaseManLeave));
        LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
        lambdaQueryWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)loginUser.getId());
        ElsEmployeInfo elsEmployeInfo = (ElsEmployeInfo)((Object)this.elsEmployeInfoService.getOne((Wrapper)lambdaQueryWrapper));
        if (elsEmployeInfo != null) {
            if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
                throw new ELSBootException("\u5f53\u524d\u8d26\u6237\u5458\u5de5\u72b6\u6001\u4e3a\u5df2\u79bb\u804c,\u4e0d\u80fd\u521b\u5efa\u8bf7\u5047\u5355!");
            }
            purchaseManLeave.setPost(elsEmployeInfo.getRole());
            purchaseManLeave.setDepartment(elsEmployeInfo.getDepartment());
            purchaseManLeave.setCostDepartment(elsEmployeInfo.getCostCenter());
        }
        purchaseManLeave.setRemoveLeaveStatus(BackHolidayStatusEnum.NO_BACK.getValue());
        purchaseManLeave.setFbk1(String.valueOf(GetDepartmentLevelUtil.getNextDivision(purchaseManLeave.getDepartment(), loginUser.getId())));
        purchaseManLeave.setFbk2(this.findBpByDepartment(purchaseManLeave.getDepartment()));
        ((PurchaseManLeaveMapper)this.baseMapper).insert((Object)purchaseManLeave);
        super.setHeadDefaultValue((BaseEntity)purchaseManLeave);
        this.insertData(purchaseManLeave, purchaseAttachmentList);
    }

    public String findBpByDepartment(String department) {
        if (department.length() > 2) {
            String department1 = department.substring(0, 3);
            return this.getNumByDepartment(department1);
        }
        return this.getNumByDepartment(department);
    }

    public String getNumByDepartment(String department) {
        if (department.contains("06")) {
            return HrbpEnum.HHM.getValue();
        }
        if (department.contains("11")) {
            return HrbpEnum.SQY.getValue();
        }
        if (department.contains("07") || department.contains("030") || department.contains("042")) {
            return HrbpEnum.WHH.getValue();
        }
        if (department.contains("045") || department.contains("046") || department.contains("041") || department.contains("031")) {
            return HrbpEnum.LWJ.getValue();
        }
        if (department.contains("040") || department.contains("047") || department.contains("05")) {
            return HrbpEnum.ZGH.getValue();
        }
        return HrbpEnum.CJ.getValue();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        int count;
        if (purchaseManLeave.getLeaveStartDate() != null && purchaseManLeave.getLeaveEndDate() != null) {
            String leaveDays = this.daysNoHolidays(purchaseManLeave.getLeaveType(), purchaseManLeave.getLeaveStartDate(), purchaseManLeave.getLeaveEndDate(), purchaseManLeave.getElsAccount());
            purchaseManLeave.setLeaveDays(new BigDecimal(leaveDays));
        }
        Assert.isTrue(((count = ((PurchaseManLeaveMapper)this.baseMapper).updateById((Object)purchaseManLeave)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(purchaseManLeave.getId());
        this.insertData(purchaseManLeave, purchaseAttachmentList);
    }

    private void insertData(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseManLeave.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseManLeave);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
        ((PurchaseManLeaveMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAttachmentService.deleteByMainId(serializable.toString());
            ((PurchaseManLeaveMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void backHoliDay(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        PurchaseManLeave dbManLeave = (PurchaseManLeave)((Object)this.getById((Serializable)((Object)purchaseManLeave.getId())));
        if (!AuditStatusEnum.AUDIT_FINISH.getValue().equals(dbManLeave.getAuditStatus())) {
            throw new ELSBootException("\u5f53\u524d\u8bf7\u5047\u6d41\u7a0b\u6ca1\u6709\u901a\u8fc7\uff0c\u65e0\u9700\u9500\u5047");
        }
        PurchaseManLeave paramsManLeave = new PurchaseManLeave();
        paramsManLeave.setId(purchaseManLeave.getId());
        paramsManLeave.setLeaveCancellYesOrNo("1");
        paramsManLeave.setRemoveLeaveStatus(BackHolidayStatusEnum.BACKING.getValue());
        paramsManLeave.setRemoveLeaveReason(purchaseManLeave.getRemoveLeaveReason());
        paramsManLeave.setRemvoeLeaveNum(this.invokeBaseRpcService.getNextCode("backHoliday", (Object)purchaseManLeave));
        this.updateById((Object)paramsManLeave);
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(purchaseManLeave.getId());
        auditInputParamVO.setBusinessType("eightDisciplines");
        auditInputParamVO.setAuditSubject("\u8bf7\u5047\u7533\u8bf7-\u9500\u5047\u5ba1\u6279:" + paramsManLeave.getRemvoeLeaveNum());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)purchaseManLeave)));
        this.workflowAuditBeanServiceImpl.submit(auditInputParamVO);
    }

    @Override
    public String daysNoHolidays(String leaveType, Date startDay, Date endDay, String elsAccount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        Date nextDate = startDay;
        String format = sdf.format(startDay);
        String substring = format.substring(0, format.indexOf(" "));
        String format1 = sdf.format(endDay);
        String substring2 = format1.substring(0, format.indexOf(" "));
        long nd = 86400000L;
        long nh = 3600000L;
        int i = 0;
        ArrayList<Date> dateList = new ArrayList<Date>();
        if (substring.equals(substring2)) {
            long hour = endDay.getTime() - startDay.getTime();
            long differenceHour = hour % nd / nh;
            String stringHour = String.valueOf(differenceHour);
            Integer integerHour = Integer.valueOf(stringHour);
            if (integerHour <= 5 && integerHour > 0) {
                return String.valueOf(0.5);
            }
            if (integerHour == 0) {
                return String.valueOf(0);
            }
            return String.valueOf(1);
        }
        double oneHalfDay = 0.0;
        double lastHalfDay = 0.0;
        String noonTime = substring + " 13:00:00";
        String afternoonTime = substring + " 18:00:00";
        String endMorningTime = substring2 + " 09:00:00";
        String endNoonTime = substring2 + " 13:00:00";
        try {
            Date noonDate = sdf.parse(noonTime);
            Date afternoonDate = sdf.parse(afternoonTime);
            Date endMorningDate = sdf.parse(endMorningTime);
            Date endNoonDate = sdf.parse(endNoonTime);
            if (!startDay.before(afternoonDate)) {
                cal.setTime(startDay);
                cal.add(5, 1);
                startDay = cal.getTime();
            }
            if (!startDay.before(noonDate) && startDay.before(afternoonDate)) {
                cal.setTime(startDay);
                cal.add(5, 1);
                startDay = cal.getTime();
                oneHalfDay = 0.5;
            }
            if (!endDay.after(endMorningDate)) {
                cal.setTime(endDay);
                cal.add(5, -1);
                cal.set(cal.get(1), cal.get(2), cal.get(5), 18, 0, 0);
                endDay = cal.getTime();
            }
            if (endDay.after(endMorningDate) && !endDay.after(endNoonDate)) {
                cal.setTime(endDay);
                cal.add(5, -1);
                endDay = cal.getTime();
                lastHalfDay = 0.5;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List workDateList = this.employeeWorkHoursService.findWorkDateList4ManLeave(elsAccount, startDay, endDay);
        while (nextDate.before(endDay)) {
            dateList.add(startDay);
            cal.setTime(startDay);
            cal.add(5, 1);
            nextDate = startDay = cal.getTime();
            ++i;
        }
        if (LeaveTypeEnum.MARRIAGE_LEAVE.getValue().equals(leaveType) || LeaveTypeEnum.MATERNITY_LEAVE.getValue().equals(leaveType) || LeaveTypeEnum.PATERNITY_LEAVE.getValue().equals(leaveType) || LeaveTypeEnum.FUNERAL_LEAVE.getValue().equals(leaveType)) {
            return String.valueOf(i);
        }
        for (Date date : dateList) {
            String startDateStr = DateUtil.formatDate((Date)date);
            if (workDateList.contains(startDateStr)) continue;
            --i;
        }
        if (oneHalfDay != 0.0 && lastHalfDay == 0.0 || lastHalfDay != 0.0 && oneHalfDay == 0.0) {
            return String.valueOf((double)i + 0.5);
        }
        if (oneHalfDay != 0.0 && lastHalfDay != 0.0) {
            return String.valueOf(i + 1);
        }
        return String.valueOf(i);
    }
}

