/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.postToRole.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.postToRole.entity.PurchasePostRole;
import com.els.modules.postToRole.enumerate.PostToRoleStatusEnum;
import com.els.modules.postToRole.mapper.PurchasePostRoleMapper;
import com.els.modules.postToRole.service.PurchasePostRoleService;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.service.UserRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchasePostRoleServiceImpl
extends BaseServiceImpl<PurchasePostRoleMapper, PurchasePostRole>
implements PurchasePostRoleService {
    @Autowired
    private UserRoleService userRoleService;

    @Override
    public void add(PurchasePostRole purchasePostRole) {
        LambdaQueryWrapper postToRoleQueryWrapper = new LambdaQueryWrapper();
        postToRoleQueryWrapper.eq(PurchasePostRole::getPostId, (Object)purchasePostRole.getPostId());
        if (StringUtils.isNotEmpty((String)purchasePostRole.getId())) {
            postToRoleQueryWrapper.ne(BaseEntity::getId, (Object)purchasePostRole.getId());
        }
        postToRoleQueryWrapper.ne(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.CANCEL.getValue());
        PurchasePostRole dbPostRole = (PurchasePostRole)((Object)this.getOne((Wrapper)postToRoleQueryWrapper));
        if (dbPostRole != null) {
            throw new ELSBootException("\u5f53\u524d\u5c97\u4f4d\u5df2\u6709\u89d2\u8272\u914d\u7f6e\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e");
        }
        purchasePostRole.setDocumentStatus(PostToRoleStatusEnum.NEW.getValue());
        ((PurchasePostRoleMapper)this.baseMapper).insert((Object)purchasePostRole);
    }

    @Override
    public void edit(PurchasePostRole purchasePostRole) {
        LambdaQueryWrapper postToRoleQueryWrapper = new LambdaQueryWrapper();
        postToRoleQueryWrapper.eq(PurchasePostRole::getPostId, (Object)purchasePostRole.getPostId());
        if (StringUtils.isNotEmpty((String)purchasePostRole.getId())) {
            postToRoleQueryWrapper.ne(BaseEntity::getId, (Object)purchasePostRole.getId());
        }
        postToRoleQueryWrapper.ne(PurchasePostRole::getDocumentStatus, (Object)PostToRoleStatusEnum.CANCEL.getValue());
        PurchasePostRole dbPostRole = (PurchasePostRole)((Object)this.getOne((Wrapper)postToRoleQueryWrapper));
        if (dbPostRole != null) {
            throw new ELSBootException("\u5f53\u524d\u5c97\u4f4d\u5df2\u6709\u89d2\u8272\u914d\u7f6e\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e");
        }
        int count = ((PurchasePostRoleMapper)this.baseMapper).updateById((Object)purchasePostRole);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchasePostRoleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchasePostRoleMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void cancel(PurchasePostRole purchasePostRole) {
        PurchasePostRole dbPostRole = (PurchasePostRole)((Object)this.getById((Serializable)((Object)purchasePostRole.getId())));
        if (dbPostRole == null) {
            throw new ELSBootException("\u7cfb\u7edf\u6ca1\u6709\u5f53\u524d\u7684\u6570\u636e,\u8bf7\u68c0\u67e5!");
        }
        PurchasePostRole paramPostToRole = new PurchasePostRole();
        paramPostToRole.setId(purchasePostRole.getId());
        paramPostToRole.setDocumentStatus(PostToRoleStatusEnum.CANCEL.getValue());
        int count = ((PurchasePostRoleMapper)this.baseMapper).updateById((Object)paramPostToRole);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<ElsEmployeInfo> employInfoList = PurchasePostRoleServiceImpl.getElsEmployInfoByPostId(dbPostRole);
        this.removeAllRoles(employInfoList);
    }

    private void removeAllRoles(List<ElsEmployeInfo> employInfoList) {
        List subAccountIds = employInfoList.stream().map(ElsEmployeInfo::getSubAccountId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(subAccountIds)) {
            LambdaQueryWrapper userRoleLambdaQueryWrapper = new QueryWrapper().lambda();
            userRoleLambdaQueryWrapper.in(UserRole::getUserId, subAccountIds);
            List userRoleList = this.userRoleService.list((Wrapper)userRoleLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)userRoleList)) {
                List userRoleIds = userRoleList.stream().map(UserRole::getId).distinct().collect(Collectors.toList());
                this.userRoleService.removeByIds(userRoleIds);
            }
        }
    }

    private static List<ElsEmployeInfo> getElsEmployInfoByPostId(PurchasePostRole dbPostRole) {
        LambdaQueryWrapper employeInfoLambdaQueryWrapper = new QueryWrapper().lambda();
        employeInfoLambdaQueryWrapper.eq(ElsEmployeInfo::getRole, (Object)dbPostRole.getPostId());
        List employInfoList = ((ElsEmployeInfoService)SpringContextUtils.getBean(ElsEmployeInfoService.class)).list((Wrapper)employeInfoLambdaQueryWrapper);
        return employInfoList;
    }

    @Override
    public void submit(PurchasePostRole purchasePostRole) {
        PurchasePostRole dbPostRole = (PurchasePostRole)((Object)this.getById((Serializable)((Object)purchasePostRole.getId())));
        if (dbPostRole == null) {
            throw new ELSBootException("\u7cfb\u7edf\u6ca1\u6709\u5f53\u524d\u7684\u6570\u636e,\u8bf7\u68c0\u67e5!");
        }
        PurchasePostRole paramPostToRole = new PurchasePostRole();
        paramPostToRole.setId(purchasePostRole.getId());
        paramPostToRole.setDocumentStatus(PostToRoleStatusEnum.START.getValue());
        int count = ((PurchasePostRoleMapper)this.baseMapper).updateById((Object)paramPostToRole);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<ElsEmployeInfo> employInfoList = PurchasePostRoleServiceImpl.getElsEmployInfoByPostId(dbPostRole);
        this.removeAllRoles(employInfoList);
        List<String> roleIds = Arrays.asList(dbPostRole.getRoleIds().split(","));
        ArrayList<UserRole> paramsUserRole = new ArrayList<UserRole>();
        for (ElsEmployeInfo elsEmployeInfo : employInfoList) {
            for (String roleId : roleIds) {
                UserRole userRole = new UserRole();
                userRole.setId(IdWorker.getIdStr());
                userRole.setUserId(elsEmployeInfo.getSubAccountId());
                userRole.setRoleId(roleId);
                paramsUserRole.add(userRole);
            }
        }
        this.userRoleService.saveBatch(paramsUserRole);
    }
}

