/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.resignationApply.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.resignationApply.entity.PurchaseResignationApply;
import com.els.modules.resignationApply.enumerate.ResigantionStatusEnum;
import com.els.modules.resignationApply.service.PurchaseResignationApplyService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseResignationApplyAuditCallBackServiceImpl")
public class PurchaseResignationApplyAuditCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseResignationApplyService purchaseResignationApplyService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper resignationApplyLambdaQueryWrapper = new QueryWrapper().lambda();
        resignationApplyLambdaQueryWrapper.eq(PurchaseResignationApply::getAuditStatus, (Object)AuditStatusEnum.AUDIT_DOING.getValue());
        resignationApplyLambdaQueryWrapper.eq(BaseEntity::getCreateBy, (Object)loginUser.getSubAccount());
        List purchaseResignationApplyList = this.purchaseResignationApplyService.list((Wrapper)resignationApplyLambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)purchaseResignationApplyList)) {
            throw new ELSBootException("\u6709\u8f9e\u804c\u7533\u8bf7\u5904\u7406\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4");
        }
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseResignationApply purchaseResignationApply = new PurchaseResignationApply();
        purchaseResignationApply.setId(inputParamVO.getBusinessId());
        purchaseResignationApply.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseResignationApply.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseResignationApply.getAuditStatus())) {
            PurchaseResignationApply dbResignationApply = (PurchaseResignationApply)((Object)this.purchaseResignationApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
            if (dbResignationApply != null) {
                purchaseResignationApply.setAgreeResignationTime(new Date());
                LambdaUpdateWrapper employeInfoLambdaUpdateWrapper = new UpdateWrapper().lambda();
                employeInfoLambdaUpdateWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)dbResignationApply.getApplyUserId());
                employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getTermDate, (Object)new Date());
                if (new Date().compareTo(dbResignationApply.getApplyResignationTime()) >= 0) {
                    employeInfoLambdaUpdateWrapper.set(ElsEmployeInfo::getEmployeeStatus, (Object)EmployInfoStatusEnum.ON_LEAVE.getValue());
                }
                this.elsEmployeInfoService.update((Wrapper)employeInfoLambdaUpdateWrapper);
            }
            purchaseResignationApply.setProcessStatus(ResigantionStatusEnum.ON_SUCCESS.getValue());
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(purchaseResignationApply.getAuditStatus())) {
            purchaseResignationApply.setProcessStatus(ResigantionStatusEnum.ON_WAIT.getValue());
        } else {
            purchaseResignationApply.setProcessStatus(ResigantionStatusEnum.ON_WORKING.getValue());
        }
        this.purchaseResignationApplyService.updateById((Object)purchaseResignationApply);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

