/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.expense.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.expense.entity.CostExpense;
import com.els.modules.expense.entity.CostExpenseItem;
import com.els.modules.expense.excel.CostExpenseExcelServiceImpl;
import com.els.modules.expense.service.CostExpenseItemService;
import com.els.modules.expense.service.CostExpenseService;
import com.els.modules.expense.vo.CostExpenseVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/expense/costExpense"})
@Api(tags={"\u8d39\u7528\u62a5\u9500"})
public class CostExpenseController
extends BaseController<CostExpense, CostExpenseService> {
    @Autowired
    private CostExpenseService costExpenseService;
    @Autowired
    private CostExpenseItemService costExpenseItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"expense#costExpense:list"})
    public Result<?> queryItemPageList(CostExpense costExpense, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)costExpense), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.costExpenseService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"expense#costExpense:list"})
    @PermissionDataView(businessType="costExpense")
    public Result<?> queryPageList(CostExpense costExpense, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)costExpense), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<CostExpense>)queryWrapper, costExpense);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.costExpenseService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"expense#costExpense:list"})
    @PermissionDataView(businessType="costExpense")
    public Result<?> queryTabsCounts(CostExpense costExpense, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)costExpense), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<CostExpense>)queryWrapper, costExpense);
        queryWrapper.groupBy((Object)"check_status");
        List list = ((CostExpenseService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(CostExpense::getCheckStatus, CostExpense::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("checkStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    private void buildQueryWrapper(QueryWrapper<CostExpense> queryWrapper, CostExpense costExpense) {
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"expense#costExpense:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CostExpense costExpense = (CostExpense)((Object)this.costExpenseService.getById((Serializable)((Object)id)));
        CostExpenseVO costExpenseVO = new CostExpenseVO();
        BeanUtils.copyProperties((Object)((Object)costExpense), (Object)((Object)costExpenseVO));
        List<CostExpenseItem> costExpenseItemList = this.costExpenseItemService.selectByMainId(id);
        costExpenseVO.setCostExpenseItemList(costExpenseItemList);
        return Result.ok((Object)((Object)costExpenseVO));
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="costExpense")
    @RequiresPermissions(value={"expense#costExpense:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, CostExpenseExcelServiceImpl.class);
    }

    @PostMapping(value={"/duplicateCheck"})
    public void duplicateCheck() {
        this.costExpenseService.duplicateCheck();
    }
}

