/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.expense.job;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.expense.entity.CostExpense;
import com.els.modules.expense.entity.CostExpenseItem;
import com.els.modules.expense.service.CostExpenseItemService;
import com.els.modules.expense.service.CostExpenseService;
import com.els.modules.mainData.api.service.OrgRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CostExpenseSyncServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(CostExpenseSyncServiceImpl.class);
    @Value(value="${finance.config.tokenUrl}")
    private String tokenUrl;
    @Value(value="${finance.config.expenseUrl}")
    private String expenseUrl;
    @Value(value="${finance.config.clientId}")
    private String clientId;
    @Value(value="${finance.config.clientSecret}")
    private String clientSecret;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private CostExpenseService costExpenseService;
    @Autowired
    private CostExpenseItemService costExpenseItemService;
    @Autowired
    private AccountExtendRpcService accountExtendRpcService;
    @Autowired
    private OrgRpcService orgRpcService;

    public void execute(String parameter) {
        log.info("execute_ProjectInfoSyncServiceImpl:" + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String elsAccount = paramObj.getString("elsAccount");
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException("elsAccount_isBlank !");
        }
        DateTime startTime = DateUtil.parseDateTime((CharSequence)"2023-01-01 00:00:00");
        int total = this.getCostExpense(1, (Date)startTime, elsAccount);
        for (int num = 2; num <= total / 100 + 1; ++num) {
            this.getCostExpense(num, (Date)startTime, elsAccount);
        }
    }

    private int getCostExpense(int currentNum, Date lastTime, String elsAccount) {
        JSONObject reqMap = new JSONObject();
        reqMap.put("page_size", (Object)100);
        reqMap.put("page_num", (Object)currentNum);
        String[] arrayType = new String[]{"101", "102", "104", "105"};
        reqMap.put("type_codes", (Object)arrayType);
        String[] arrayStatus = new String[]{"approved", "closed"};
        reqMap.put("statuses", (Object)arrayStatus);
        reqMap.put("start_datetime", (Object)lastTime.getTime());
        reqMap.put("end_datetime", (Object)new Date().getTime());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String synchronizationUrl = this.expenseUrl + "?access_token=" + this.getToken();
        String response = ((HttpRequest)HttpRequest.post((String)synchronizationUrl).addHeaders(header)).body(reqMap.toJSONString()).execute().body();
        log.info("\u63a5\u53e3\u8fd4\u56de\uff1a" + response);
        JSONObject resultObj = JSONObject.parseObject((String)response);
        String resCode = resultObj.getString("resCode");
        int totalCount = 0;
        if ("200000".equals(resCode)) {
            JSONObject data = resultObj.getJSONObject("data");
            totalCount = data.getIntValue("total_count");
            if (totalCount == 0) {
                return totalCount;
            }
            JSONArray array = data.getJSONArray("page_info");
            for (Object obj : array) {
                String value_meaning;
                JSONObject headObj = (JSONObject)obj;
                CostExpense costExpense = new CostExpense();
                costExpense.setElsAccount(elsAccount);
                costExpense.setTemplateName("\u6807\u51c6\u6a21\u677f");
                costExpense.setTemplateNumber("TC2022122701");
                costExpense.setTemplateAccount("100000");
                costExpense.setTemplateVersion(1);
                JSONObject header_type = (JSONObject)headObj.get((Object)"header_type");
                String code = header_type.get((Object)"code").toString();
                if (!Arrays.asList(arrayType).contains(code)) continue;
                String orderNo = headObj.get((Object)"code").toString();
                CostExpense costDb = (CostExpense)((Object)this.costExpenseService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"order_no", (Object)orderNo)).last("limit 1")));
                if (costDb != null) continue;
                costExpense.setOrderNo(orderNo);
                costExpense.setId(IdWorker.getIdStr());
                switch (code) {
                    case "101": {
                        costExpense.setCostType("project");
                        break;
                    }
                    case "102": {
                        costExpense.setCostType("presale");
                        break;
                    }
                    case "104": {
                        costExpense.setCostType("other");
                        break;
                    }
                    case "105": {
                        costExpense.setCostType("sale");
                    }
                }
                if (headObj.get((Object)"submit_date") != null) {
                    Long submit_date = (Long)headObj.get((Object)"submit_date");
                    Date submitDate = new Date(Long.parseLong(String.valueOf(submit_date)));
                    costExpense.setCreateTime(submitDate);
                }
                costExpense.setCheckStatus("3");
                costExpense.setPassTime(new Date());
                if (headObj.get((Object)"submit_user") != null) {
                    ElsSubAccountDTO accountDTO;
                    JSONObject submitUser = (JSONObject)headObj.get((Object)"submit_user");
                    String fullName = "";
                    if (submitUser.get((Object)"email_address") != null) {
                        fullName = (String)submitUser.get((Object)"email_address");
                    }
                    if ((accountDTO = this.accountExtendRpcService.getAccountByName(elsAccount, fullName)) != null) {
                        costExpense.setUserId(accountDTO.getId());
                        costExpense.setUserName(fullName);
                        costExpense.setCreateBy(accountDTO.getSubAccount());
                        costExpense.setCreateById(accountDTO.getId());
                        costExpense.setCreateTime(new Date());
                        PurchaseOrganizationInfoDTO orgInfo = this.orgRpcService.getOrgInfoById(accountDTO.getOrgCode());
                        if (orgInfo != null) {
                            costExpense.setDepartmentId(orgInfo.getId());
                            costExpense.setDepartmentName(orgInfo.getOrgName());
                        }
                    } else {
                        if (!((JSONObject)headObj.get((Object)"project")).get((Object)"project_name").toString().equals("\u4e2d\u56fd\u6c7d\u7814\u91c7\u8d2d\u7ba1\u7406\u4fe1\u606f\u5316\u5e73\u53f0")) continue;
                        log.error("----------------------------REALNAMEWY" + accountDTO.getRealname());
                        continue;
                    }
                }
                JSONArray claim_lines = (JSONArray)headObj.get((Object)"claim_lines");
                JSONObject column14_obj = (JSONObject)headObj.get((Object)"column14_obj");
                if ("101".equals(code)) {
                    JSONObject project = (JSONObject)headObj.get((Object)"project");
                    String projectName = project.get((Object)"project_name").toString();
                    ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"project_name", (Object)projectName)).last("limit 1")));
                    if (baseInfo == null) continue;
                    costExpense.setProjectName(projectName);
                    costExpense.setProjectId(baseInfo.getId());
                } else if (!"105".equals(code) && !"104".equals(code) && "102".equals(code) && column14_obj != null && !column14_obj.isEmpty() && (value_meaning = (String)column14_obj.get((Object)"value_meaning")) != null && value_meaning.contains("/")) {
                    String[] split = value_meaning.split("/");
                    String projectName = split[0];
                    costExpense.setProjectName(projectName);
                    ElsSubAccountDTO accountDTO = this.accountExtendRpcService.getAccountByName(elsAccount, projectName);
                    if (accountDTO != null) {
                        costExpense.setProjectId(accountDTO.getId());
                    }
                }
                BigDecimal totalAmount = (BigDecimal)headObj.get((Object)"total_amount");
                costExpense.setAmount(totalAmount);
                costExpense.setCheckExpensesAmount(totalAmount);
                BigDecimal totalFinClaimAmount = (BigDecimal)headObj.get((Object)"total_fin_claim_amount");
                if (totalFinClaimAmount != null) {
                    costExpense.setCheckExpensesAmount(totalFinClaimAmount);
                }
                this.costExpenseService.save((Object)costExpense);
                if (claim_lines != null && !claim_lines.isEmpty()) {
                    List claimLines = JSONArray.parseArray((String)claim_lines.toJSONString(), Object.class);
                    int sortNo = 0;
                    if (claimLines == null || claimLines.isEmpty()) continue;
                    ArrayList<CostExpenseItem> expenseItemList = new ArrayList<CostExpenseItem>();
                    for (Object claimLine : claimLines) {
                        JSONObject claimLine1 = (JSONObject)claimLine;
                        CostExpenseItem costExpenseItem = new CostExpenseItem();
                        costExpenseItem.setId(IdWorker.getIdStr());
                        costExpenseItem.setHeadId(costExpense.getId());
                        costExpenseItem.setSortIndex(++sortNo);
                        costExpenseItem.setElsAccount(elsAccount);
                        Long receipt_date = (Long)claimLine1.get((Object)"receipt_date");
                        if (receipt_date != null) {
                            Date receiptDate = new Date(Long.parseLong(String.valueOf(receipt_date)));
                            costExpenseItem.setCostDate(receiptDate);
                        }
                        costExpenseItem.setCostType(costExpense.getCostType());
                        JSONObject exp_type = (JSONObject)claimLine1.get((Object)"exp_type");
                        if (exp_type == null || exp_type.get((Object)"type_code") == null) continue;
                        String type = exp_type.get((Object)"type_code").toString();
                        String[] types = new String[]{"CL001", "CL002", "CL003", "CL004", "CL005", "CL006", "CL007", "CL008", "CL009", "CL010", "CL011", "ZD001", "XZ001", "XZ002", "XZ021", "XZ003", "XZ004", "XZ005", "XZ006", "FL001", "FL002", "FL003", "FL004", "JK001", "JK002"};
                        if (Arrays.asList(types).contains(type)) {
                            switch (type) {
                                case "CL001": {
                                    costExpenseItem.setReceiptType("plane");
                                    break;
                                }
                                case "CL002": {
                                    costExpenseItem.setReceiptType("train");
                                    break;
                                }
                                case "CL003": {
                                    costExpenseItem.setReceiptType("bus");
                                    break;
                                }
                                case "CL004": {
                                    costExpenseItem.setReceiptType("petrol");
                                    break;
                                }
                                case "CL005": {
                                    costExpenseItem.setReceiptType("traffic");
                                    break;
                                }
                                case "CL006": {
                                    costExpenseItem.setReceiptType("roadbridge");
                                    break;
                                }
                                case "CL007": {
                                    costExpenseItem.setReceiptType("hotel");
                                    break;
                                }
                                case "CL008": {
                                    costExpenseItem.setReceiptType("allowance");
                                    break;
                                }
                                case "CL009": {
                                    costExpenseItem.setReceiptType("transportationSubsidy");
                                    break;
                                }
                                case "CL010": {
                                    costExpenseItem.setReceiptType("parking");
                                    break;
                                }
                                case "CL011": {
                                    costExpenseItem.setReceiptType("allowance2");
                                    break;
                                }
                                case "ZD001": {
                                    costExpenseItem.setReceiptType("receive");
                                    break;
                                }
                                case "XZ001": {
                                    costExpenseItem.setReceiptType("working");
                                    break;
                                }
                                case "XZ002": {
                                    costExpenseItem.setReceiptType("working");
                                    break;
                                }
                                case "XZ021": {
                                    costExpenseItem.setReceiptType("express");
                                    break;
                                }
                                case "XZ003": {
                                    costExpenseItem.setReceiptType("working");
                                    break;
                                }
                                case "XZ004": {
                                    costExpenseItem.setReceiptType("working");
                                    break;
                                }
                                case "XZ005": {
                                    costExpenseItem.setReceiptType("rent");
                                    break;
                                }
                                case "XZ006": {
                                    costExpenseItem.setReceiptType("working");
                                    break;
                                }
                                case "FL001": {
                                    costExpenseItem.setReceiptType("toiletry");
                                    break;
                                }
                                case "FL002": {
                                    costExpenseItem.setReceiptType("nucleicTest");
                                    break;
                                }
                                case "FL003": {
                                    costExpenseItem.setReceiptType("welfare");
                                    break;
                                }
                                case "FL004": {
                                    costExpenseItem.setReceiptType("training");
                                }
                            }
                            String baseinfoId = costExpense.getProjectId();
                            if (StrUtil.isNotEmpty((CharSequence)baseinfoId) && ("project".equals(costExpense.getCostType()) || "presale".equals(costExpense.getCostType()))) {
                                costExpenseItem.setProjectId(baseinfoId);
                                costExpenseItem.setProjectName(costExpense.getProjectName());
                                ProjectBaseInfo projectmgrBaseinfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)baseinfoId)));
                                if (projectmgrBaseinfo != null && "project".equals(costExpense.getCostType())) {
                                    costExpenseItem.setCostDepartmentId(projectmgrBaseinfo.getAffiliatedDepartmentId());
                                    costExpenseItem.setCostDepartmentName(projectmgrBaseinfo.getAffiliatedDepartmentName());
                                }
                            }
                            BigDecimal claimAmount = (BigDecimal)claimLine1.get((Object)"claim_amount");
                            costExpenseItem.setAmount(BigDecimal.ZERO);
                            if (claimAmount != null) {
                                costExpenseItem.setAmount(claimAmount);
                            }
                            BigDecimal finClaimAmount = (BigDecimal)claimLine1.get((Object)"fin_claim_amount");
                            costExpenseItem.setCheckExpensesAmount(BigDecimal.ZERO);
                            if (finClaimAmount != null) {
                                costExpenseItem.setCheckExpensesAmount(finClaimAmount);
                            }
                            expenseItemList.add(costExpenseItem);
                            continue;
                        }
                        if (!((JSONObject)headObj.get((Object)"project")).get((Object)"project_name").toString().equals("\u4e2d\u56fd\u6c7d\u7814\u91c7\u8d2d\u7ba1\u7406\u4fe1\u606f\u5316\u5e73\u53f0")) continue;
                        log.error("----------------------------TYPEWY------------------------");
                    }
                    log.info("\u5355\u636e\u53f7\u4e3a\uff1a" + costExpense.getOrderNo() + "\u7684\u62a5\u9500\u5355\u6709==========={}\u6761\u6570\u636e", (Object)sortNo);
                    this.costExpenseItemService.saveBatch(expenseItemList);
                    continue;
                }
                log.info("\u5355\u636e\u53f7\u4e3a\uff1a" + costExpense.getOrderNo() + "\u7684\u62a5\u9500\u5355\u6709===========0\u6761\u6570\u636e");
            }
        }
        return totalCount;
    }

    private String getToken() {
        HashMap<String, String> reqtokenMap = new HashMap<String, String>();
        reqtokenMap.put("grant_type", "client_credentials");
        reqtokenMap.put("client_id", this.clientId);
        reqtokenMap.put("client_secret", this.clientSecret);
        HttpRequest httpRequest = HttpUtil.createGet((String)this.tokenUrl);
        httpRequest.form(reqtokenMap);
        String result = httpRequest.execute().body();
        JSONObject responseObj = JSONObject.parseObject((String)result);
        JSONObject jsonObject = (JSONObject)responseObj.get((Object)"data");
        String token = (String)jsonObject.get((Object)"access_token");
        return token;
    }
}

