/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.expense.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.expense.entity.CostExpense;
import com.els.modules.expense.entity.CostExpenseItem;
import com.els.modules.expense.mapper.CostExpenseMapper;
import com.els.modules.expense.service.CostExpenseItemService;
import com.els.modules.expense.service.CostExpenseService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CostExpenseServiceImpl
extends BaseServiceImpl<CostExpenseMapper, CostExpense>
implements CostExpenseService {
    @Resource
    private CostExpenseItemService costExpenseItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(CostExpense costExpense, List<CostExpenseItem> costExpenseItemList) {
        ((CostExpenseMapper)this.baseMapper).insert((Object)costExpense);
        super.setHeadDefaultValue((BaseEntity)costExpense);
        this.insertData(costExpense, costExpenseItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CostExpense costExpense, List<CostExpenseItem> costExpenseItemList) {
        int count = ((CostExpenseMapper)this.baseMapper).updateById((Object)costExpense);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.costExpenseItemService.deleteByMainId(costExpense.getId());
        this.insertData(costExpense, costExpenseItemList);
    }

    private void insertData(CostExpense costExpense, List<CostExpenseItem> costExpenseItemList) {
        if (!CollectionUtils.isEmpty(costExpenseItemList)) {
            for (CostExpenseItem entity : costExpenseItemList) {
                entity.setHeadId(costExpense.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)costExpense);
            }
            this.costExpenseItemService.saveBatch(costExpenseItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.costExpenseItemService.deleteByMainId(id);
        ((CostExpenseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.costExpenseItemService.deleteByMainId(serializable.toString());
            ((CostExpenseMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void duplicateCheck() {
        List list = this.list();
        ArrayList<String> costExpenseList = new ArrayList<String>();
        ArrayList<String> costExpenseIdList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CostExpense costExpense : list) {
                if (CollectionUtils.isEmpty(costExpenseList)) {
                    costExpenseList.add(costExpense.getOrderNo());
                    continue;
                }
                if (!costExpenseList.contains(costExpense.getOrderNo())) {
                    costExpenseList.add(costExpense.getOrderNo());
                    continue;
                }
                costExpenseIdList.add(costExpense.getId());
            }
        }
        if (!CollectionUtils.isEmpty(costExpenseIdList)) {
            this.deleteBatchMain(costExpenseIdList);
        }
    }
}

