/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.email.EmailSendService;
import com.els.modules.project.entity.BpSystemDeployApply;
import com.els.modules.project.enumerate.SystemDeployApplyStatusEnum;
import com.els.modules.project.service.BpSystemDeployApplyService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BpSystemDeployApplyAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LogManager.getLogger(BpSystemDeployApplyAuditOptCallBackServiceImpl.class);
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private BpSystemDeployApplyService bpSystemDeployApplyService;
    @Autowired
    private EmailSendService emailSendService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        head.setStatus(SystemDeployApplyStatusEnum.AUDITING.getValue());
        this.bpSystemDeployApplyService.updateById((Object)head);
        this.updateStatus(inputParamVO, outputParamVO);
        this.autoBindEmailAndEnableSend(outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    private void autoBindEmailAndEnableSend(AuditOutputParamDTO outputParamVO) {
        for (String account : outputParamVO.getNextAuditUserList()) {
            String[] accountArray = account.split("_");
            if (accountArray == null || accountArray.length == 0) continue;
            String elsAccount = accountArray[0];
            String subAccount = accountArray[1];
            this.emailSendService.checkBindEmail(elsAccount, subAccount);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
            this.updateStatus(inputParamVO, outputParamVO);
            this.sendEmailToTSO(inputParamVO);
        } else {
            this.autoBindEmailAndEnableSend(outputParamVO);
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private void sendEmailToTSO(AuditInputParamDTO inputParamVO) {
        BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        if (head != null) {
            String projectName = head.getProjectName();
            ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig("1517606");
            String subject = "\u7cfb\u7edf\u90e8\u7f72\u7533\u8bf7\u5df2\u5ba1\u6279\u901a\u8fc7\u63d0\u9192";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("projectName", projectName);
            GroupTemplate groupTemplate = new GroupTemplate();
            Template template = groupTemplate.getTemplate("bpSystemDeployApply.html");
            template.binding(params);
            String render = template.render();
            ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)"tso@51qqt.com", (String)subject, (String)render, null, (boolean)false);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String auditStatus = outputParamVO.getAuditStatus();
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
            head.setStatus(SystemDeployApplyStatusEnum.RETURNED.getValue());
            this.bpSystemDeployApplyService.updateById((Object)head);
            this.updateStatus(inputParamVO, outputParamVO);
            this.autoBindEmailAndEnableSend(outputParamVO);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
        }
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        head.setStatus(SystemDeployApplyStatusEnum.NEW.getValue());
        this.bpSystemDeployApplyService.updateById((Object)head);
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            head.setStatus(SystemDeployApplyStatusEnum.AUDITED.getValue());
            head.setAuditDatetime(new Date());
        }
        this.bpSystemDeployApplyService.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        try {
            String headId = inputParamVO.getBusinessId();
            BpSystemDeployApply head = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)headId)));
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
            paramMap.put("outAuditPassUrl", outAuditPassUrl);
            paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
            msgParamsVO.setParams((Object)paramMap);
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            JSONObject paramObj = new JSONObject();
            paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
            paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
            if (account.split("_").length > 2) {
                paramObj.put("taskId", (Object)account.split("_")[2]);
            }
            if (account.split("_").length > 3) {
                paramObj.put("processInstanceId", (Object)account.split("_")[3]);
            }
            receiveParamMap.put(TenantContext.getTenant(), paramObj);
            msgParamsVO.setReceiveParamMap(receiveParamMap);
        }
        catch (Exception e) {
            log.error("send message error {} ", (Object)e.getMessage());
        }
        return msgParamsVO;
    }
}

