/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.adapter;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.contract.service.SalesContractApiService;
import com.els.modules.contract.service.SalesContractModuleProgressRpcService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.CoreInvokeOtherRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectBaseInfoCallBackServiceImpl")
public class ProjectBaseInfoCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SalesContractModuleProgressRpcService salesContractModuleProgressRpcService;
    @Autowired
    private SalesContractApiService salesContractApiService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
            this.invokePanshiCreateProject(inputParamDTO.getBusinessId());
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        ProjectBaseInfo baseInfo = new ProjectBaseInfo();
        baseInfo.setId(inputParamVO.getBusinessId());
        baseInfo.setApprovalStatus(outputParamVO.getAuditStatus());
        baseInfo.setFlowId(outputParamVO.getProcessRootId());
        this.projectBaseInfoService.updateById((Object)baseInfo);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void invokePanshiCreateProject(String id) {
        ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id)));
        CoreInvokeOtherRpcService rpcService = (CoreInvokeOtherRpcService)SpringContextUtils.getBean(CoreInvokeOtherRpcService.class);
        ElsSubAccountDTO accountDTO = this.invokeAccountRpcService.getAccountById(baseInfo.getProjectManagerId());
        JSONObject body = new JSONObject();
        body.put("projectName", (Object)baseInfo.getProjectName());
        if (accountDTO != null) {
            body.put("projectPrincipal", (Object)accountDTO.getSubAccount());
        }
        body.put("projectStatus", (Object)"0");
        if (baseInfo.getStartDate() != null) {
            body.put("startDate", (Object)DateUtil.formatDate((Date)baseInfo.getStartDate()));
        }
        body.put("signatory", (Object)baseInfo.getContractBody());
        body.put("businessManager", (Object)baseInfo.getCustomerManagerName());
        body.put("clientName", (Object)baseInfo.getParentCustomerName());
        body.put("deployWay", (Object)this.getPanshiDeployWay(baseInfo.getDeployMode()));
        body.put("fbk1", (Object)baseInfo.getAffiliatedDepartmentName());
        body.put("fbk2", (Object)baseInfo.getProjectManagerName());
        body.put("fbk3", (Object)this.salesContractApiService.getSignUpTypeById(baseInfo.getParentContractBaseinfoId()));
        List moduleList = this.salesContractModuleProgressRpcService.getModuleListByMainId(baseInfo.getParentContractBaseinfoId());
        JSONArray array = new JSONArray();
        for (String moduleName : moduleList) {
            JSONObject item = new JSONObject();
            item.put("businessType", (Object)moduleName);
            array.add((Object)item);
        }
        body.put("projectItemList", (Object)array);
        rpcService.callPanshi("createProject", body);
    }

    private String getPanshiDeployWay(String bpDeploy) {
        String panshiDeployWay = "0";
        switch (bpDeploy) {
            case "1": {
                panshiDeployWay = "1";
                break;
            }
            case "2": {
                panshiDeployWay = "3";
                break;
            }
            case "3": {
                panshiDeployWay = "2";
                break;
            }
            case "4": {
                panshiDeployWay = "2";
                break;
            }
            case "5": {
                panshiDeployWay = "3";
                break;
            }
        }
        return panshiDeployWay;
    }
}

