/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.adapter;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectInfoChange;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectInfoChangeService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.CoreInvokeOtherRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectInfoChangeCallBackServiceImpl")
public class ProjectInfoChangeCallBackServiceImpl
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(ProjectInfoChangeCallBackServiceImpl.class);
    @Autowired
    private ProjectInfoChangeService projectInfoChangeService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ProjectMainPlanService projectMainPlanService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    @Transactional
    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
            ProjectInfoChange infoChange = (ProjectInfoChange)((Object)this.projectInfoChangeService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
            JSONObject changeObj = new JSONObject();
            JSONArray filedArray = JSONObject.parseArray((String)infoChange.getFieldData());
            for (Object obj : filedArray) {
                JSONObject filedObj = (JSONObject)obj;
                changeObj.put(filedObj.getString("fieldName"), (Object)filedObj.getString("newFieldValue"));
            }
            ProjectBaseInfo updateProject = (ProjectBaseInfo)((Object)JSONObject.parseObject((String)changeObj.toJSONString(), ProjectBaseInfo.class));
            updateProject.setId(infoChange.getProjectId());
            PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService = (PurchaseOrganizationInfoRpcService)SpringContextUtils.getBean(PurchaseOrganizationInfoRpcService.class);
            PurchaseOrganizationInfoDTO dept = purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", updateProject.getAffiliatedDepartmentId());
            if (dept != null) {
                updateProject.setAffiliatedDepartmentName(dept.getOrgName());
            }
            LambdaUpdateWrapper lambdaQueryWrapper = new UpdateWrapper().lambda();
            lambdaQueryWrapper.eq(ProjectMainPlan::getProjectId, (Object)infoChange.getProjectId());
            ((LambdaUpdateWrapper)lambdaQueryWrapper.set(ProjectMainPlan::getProjectManagerName, (Object)updateProject.getProjectManagerName())).set(ProjectMainPlan::getProjectManagerId, (Object)updateProject.getProjectManagerId());
            this.projectMainPlanService.update((Wrapper)lambdaQueryWrapper);
            updateProject.setOpened("1");
            this.projectBaseInfoService.updateById((Object)updateProject);
            this.invokePanshiUpdateProject(updateProject.getId());
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        ProjectInfoChange InfoChange = new ProjectInfoChange();
        InfoChange.setId(inputParamVO.getBusinessId());
        InfoChange.setAuditStatus(outputParamVO.getAuditStatus());
        InfoChange.setFlowId(outputParamVO.getProcessRootId());
        this.projectInfoChangeService.updateById((Object)InfoChange);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void invokePanshiUpdateProject(String id) {
        try {
            ProjectBaseInfo baseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id)));
            CoreInvokeOtherRpcService rpcService = (CoreInvokeOtherRpcService)SpringContextUtils.getBean(CoreInvokeOtherRpcService.class);
            ElsSubAccountDTO accountDTO = this.invokeAccountRpcService.getAccountById(baseInfo.getProjectManagerId());
            JSONObject body = new JSONObject();
            body.put("projectName", (Object)baseInfo.getProjectName());
            if (accountDTO != null) {
                body.put("projectPrincipal", (Object)accountDTO.getSubAccount());
            }
            body.put("projectStatus", (Object)"0");
            if (baseInfo.getStartDate() != null) {
                body.put("startDate", (Object)DateUtil.formatDate((Date)baseInfo.getStartDate()));
            }
            body.put("signatory", (Object)baseInfo.getContractBody());
            body.put("businessManager", (Object)baseInfo.getCustomerManagerName());
            body.put("clientName", (Object)baseInfo.getParentCustomerName());
            rpcService.callPanshi("updateProject", body);
        }
        catch (Exception e) {
            log.error("invokePanshiUpdateProject_failed:", (Throwable)e);
        }
    }
}

