/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.adapter;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectMainPlanCallBackServiceImpl")
public class ProjectMainPlanCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ProjectMainPlanService projectMainPlanService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateStatus("1", auditInputParamDTO, auditOutputParamDTO);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus("1", inputParamDTO, outputParamDTO);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus("0", inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus("0", inputParamDTO, outputParamDTO);
    }

    private void updateStatus(String mainPlanStatus, AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        ProjectBaseInfo baseInfo = new ProjectBaseInfo();
        baseInfo.setId(inputParamVO.getBusinessId());
        baseInfo.setMainPlanFlowId(outputParamVO.getProcessRootId());
        baseInfo.setMainPlanStatus(mainPlanStatus);
        this.projectBaseInfoService.updateById((Object)baseInfo);
        ProjectMainPlan updateMainPlan = new ProjectMainPlan();
        updateMainPlan.setProjectId(inputParamVO.getBusinessId());
        this.projectMainPlanService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ProjectMainPlan::getAuditStatus, (Object)outputParamVO.getAuditStatus())).set(ProjectMainPlan::getMainPlanStatus, (Object)mainPlanStatus)).eq(ProjectMainPlan::getProjectId, (Object)inputParamVO.getBusinessId()));
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            List<ProjectMainPlan> mainPlanList = this.projectMainPlanService.selectByMainId(inputParamVO.getBusinessId());
            for (ProjectMainPlan plan : mainPlanList) {
                plan.setInitPlanStartDate(plan.getPlanStartDate());
                plan.setInitPlanFinishDate(plan.getPlanFinishDate());
            }
            this.projectMainPlanService.updateBatchById(mainPlanList);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO auditOutputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

