/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.project.entity.BpProjectAccountingHead;
import com.els.modules.project.excel.BpProjectAccountingHeadExportServiceImpl;
import com.els.modules.project.service.BpProjectAccountingHeadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u9879\u76ee\u6838\u7b97\u8868"})
@RestController
@RequestMapping(value={"/project/bpProjectAccountingHead"})
public class BpProjectAccountingHeadController
extends BaseController<BpProjectAccountingHead, BpProjectAccountingHeadService> {
    @Autowired
    private BpProjectAccountingHeadService bpProjectAccountingHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"project#bpProjectAccountingHead:list"})
    public Result<?> queryPageList(BpProjectAccountingHead bpProjectAccountingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)bpProjectAccountingHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.buildQueryWrapper((QueryWrapper<BpProjectAccountingHead>)queryWrapper);
        IPage pageList = this.bpProjectAccountingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    private void buildQueryWrapper(QueryWrapper<BpProjectAccountingHead> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("ProjectAccounting")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(this.getTenantId(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        accountIdList.add(currentUserId);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)q.in((Object)"project_manager_id", (Collection)accountIdList);
        });
    }

    @AutoLog(value="\u9879\u76ee\u6838\u7b97-\u8ba1\u7b97\u8d39\u7528")
    @ApiOperation(value="\u8ba1\u7b97\u8d39\u7528", notes="\u8ba1\u7b97\u8d39\u7528")
    @PostMapping(value={"/calculate"})
    @SrmValidated
    public Result<?> calculate() {
        this.bpProjectAccountingHeadService.calculate();
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"project#bpProjectAccountingHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BpProjectAccountingHead bpProjectAccountingHead = (BpProjectAccountingHead)((Object)this.bpProjectAccountingHeadService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)bpProjectAccountingHead));
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"project#bpProjectAccountingHead:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, BpProjectAccountingHeadExportServiceImpl.class);
    }
}

