/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.project.entity.BpDeployModuleProgress;
import com.els.modules.project.entity.BpSystemDeployApply;
import com.els.modules.project.enumerate.SystemDeployApplyStatusEnum;
import com.els.modules.project.service.BpDeployModuleProgressService;
import com.els.modules.project.service.BpSystemDeployApplyService;
import com.els.modules.project.vo.BpSystemDeployApplyVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u90e8\u7f72\u7533\u8bf7\u8868"})
@RestController
@RequestMapping(value={"/project/bpSystemDeployApply"})
public class BpSystemDeployApplyController
extends BaseController<BpSystemDeployApply, BpSystemDeployApplyService> {
    @Autowired
    private BpSystemDeployApplyService bpSystemDeployApplyService;
    @Autowired
    private BpDeployModuleProgressService bpDeployModuleProgressService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"project#systemDeployApply:list"})
    public Result<?> queryPageList(BpSystemDeployApply bpSystemDeployApply, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)bpSystemDeployApply), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.buildQueryWrapper((QueryWrapper<BpSystemDeployApply>)queryWrapper, bpSystemDeployApply);
        IPage pageList = this.bpSystemDeployApplyService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCounts(BpSystemDeployApply apply, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)apply), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<BpSystemDeployApply>)queryWrapper, apply);
        queryWrapper.groupBy((Object)"status");
        List list = ((BpSystemDeployApplyService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(BpSystemDeployApply::getStatus, BpSystemDeployApply::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("deployApplyStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    private void buildQueryWrapper(QueryWrapper<BpSystemDeployApply> queryWrapper, BpSystemDeployApply head) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || "auditor".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("RecruitAuditor")) {
            return;
        }
        if (roleSet.contains("3rdPartner")) {
            return;
        }
        if (roleSet.contains("tso")) {
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add(SystemDeployApplyStatusEnum.AUDITED.getValue());
            statusList.add(SystemDeployApplyStatusEnum.DONE.getValue());
            statusList.add(SystemDeployApplyStatusEnum.DOWN_SERVE.getValue());
            queryWrapper.in((Object)"status", statusList);
            return;
        }
        queryWrapper.eq((Object)"create_by_id", (Object)loginUser.getId());
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"project#systemDeployApply:add"})
    public Result<?> add(@RequestBody BpSystemDeployApplyVO vo) {
        this.bpSystemDeployApplyService.saveBpSystemDeployApply(vo);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"project#systemDeployApply:edit"})
    public Result<?> edit(@RequestBody BpSystemDeployApplyVO vo) {
        this.bpSystemDeployApplyService.updateBpSystemDeployApply(vo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"project#systemDeployApply:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.bpSystemDeployApplyService.delBpSystemDeployApply(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"project#systemDeployApply:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BpSystemDeployApply bpSystemDeployApply = (BpSystemDeployApply)((Object)this.bpSystemDeployApplyService.getById((Serializable)((Object)id)));
        BpSystemDeployApplyVO vo = new BpSystemDeployApplyVO();
        BeanUtils.copyProperties((Object)((Object)bpSystemDeployApply), (Object)((Object)vo));
        List<BpDeployModuleProgress> progressList = this.bpDeployModuleProgressService.selectByMainId(id);
        vo.setProgressList(progressList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        vo.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u9000\u56de")
    @ApiOperation(value="\u9000\u56de", notes="\u9000\u56de")
    @PostMapping(value={"/handleReturn"})
    @RequiresPermissions(value={"project#systemDeployApply:handleReturn"})
    public Result<?> handleReturn(@RequestBody BpSystemDeployApply bpSystemDeployApply) {
        this.bpSystemDeployApplyService.handleReturn(bpSystemDeployApply);
        return Result.ok((Object)((Object)bpSystemDeployApply));
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u5b8c\u6210")
    @ApiOperation(value="\u5b8c\u6210", notes="\u5b8c\u6210")
    @PostMapping(value={"/handleFinish"})
    @RequiresPermissions(value={"project#systemDeployApply:handleFinish"})
    @SrmValidated
    public Result<?> handleFinish(@RequestBody BpSystemDeployApply bpSystemDeployApply) {
        this.bpSystemDeployApplyService.handleFinish(bpSystemDeployApply);
        return Result.ok((Object)((Object)bpSystemDeployApply));
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u505c\u670d")
    @ApiOperation(value="\u505c\u670d", notes="\u505c\u670d")
    @PostMapping(value={"/downServe"})
    @RequiresPermissions(value={"project#systemDeployApply:downServe"})
    @SrmValidated
    public Result<?> downServe(@RequestBody BpSystemDeployApply bpSystemDeployApply) {
        this.bpSystemDeployApplyService.downServe(bpSystemDeployApply);
        return Result.ok((Object)((Object)bpSystemDeployApply));
    }

    @AutoLog(value="\u90e8\u7f72\u7533\u8bf7\u8868-\u8ba1\u7b97\u8d39\u7528")
    @ApiOperation(value="\u8ba1\u7b97\u8d39\u7528", notes="\u8ba1\u7b97\u8d39\u7528")
    @PostMapping(value={"/calculate"})
    @SrmValidated
    public Result<?> calculate(@RequestBody BpSystemDeployApply bpSystemDeployApply) {
        this.bpSystemDeployApplyService.calculate(bpSystemDeployApply);
        return Result.ok((Object)((Object)bpSystemDeployApply));
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u9879\u76ee\u90e8\u7f72\u7533\u8bf7", notes="\u521d\u59cb\u5316\u9879\u76ee\u90e8\u7f72\u7533\u8bf7")
    @PostMapping(value={"/noToken/init"})
    @SrmValidated
    public Result<?> init() {
        List<BpSystemDeployApply> list = this.bpSystemDeployApplyService.init();
        return Result.ok(list);
    }
}

