/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.contract.service.SalesContractPlanApiService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectCost;
import com.els.modules.project.entity.ProjectEnclosure;
import com.els.modules.project.entity.ProjectReceivables;
import com.els.modules.project.excel.ProjectInfoExportServiceImpl;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectCostService;
import com.els.modules.project.service.ProjectEnclosureService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.project.service.ProjectReceivablesService;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/project/projectBaseInfo"})
@Api(tags={"\u9879\u76ee\u4fe1\u606f"})
public class ProjectBaseInfoController
extends BaseController<ProjectBaseInfo, ProjectBaseInfoService> {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private ProjectCostService projectCostService;
    @Autowired
    private ProjectReceivablesService projectReceivablesService;
    @Autowired
    private ProjectEnclosureService projectEnclosureService;
    @Autowired
    private ProjectMainPlanService projectMainPlanService;
    @Resource
    private SalesContractPlanApiService salesContractPlanApiService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"project#projectBaseInfo:list"})
    public Result<?> queryPageList(ProjectBaseInfo projectBaseInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectBaseInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<ProjectBaseInfo>)queryWrapper, projectBaseInfo);
        String filterProjectBaseInfoStatus = req.getParameter("filterProjectBaseInfoStatus");
        if (CharSequenceUtil.isNotEmpty((CharSequence)filterProjectBaseInfoStatus)) {
            List status = Arrays.stream(filterProjectBaseInfoStatus.split(",")).collect(Collectors.toList());
            queryWrapper.lambda().notIn(ProjectBaseInfo::getProjectStatus, status);
        }
        IPage pageList = this.projectBaseInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/otherModulelist"})
    public Result<?> otherModulelist(ProjectBaseInfo projectBaseInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectBaseInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.select(new String[]{"id", "project_number", "project_name", "project_type", "contract_body", "start_date", "end_date", "project_status"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.projectBaseInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    private void buildQueryWrapper(QueryWrapper<ProjectBaseInfo> queryWrapper, ProjectBaseInfo projectBaseInfo) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("projectAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(this.getTenantId(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.in((Object)"project_manager_id", (Collection)accountIdList)).or()).eq((Object)"project_chief_inspector_id", (Object)currentUserId)).or()).eq((Object)"dev_chargeman_id", (Object)currentUserId)).or()).eq((Object)"customer_manager_id", (Object)currentUserId)).or()).eq((Object)"dep_director_id", (Object)currentUserId)).or()).eq((Object)"create_by_id", (Object)currentUserId)).or()).eq((Object)"customer_success_manager_id", (Object)currentUserId);
        });
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"project#projectBaseInfo:list"})
    public Result<?> queryTabsCounts(ProjectBaseInfo projectBaseInfo, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectBaseInfo), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"project_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<ProjectBaseInfo>)queryWrapper, projectBaseInfo);
        queryWrapper.groupBy((Object)"project_status");
        List list = ((ProjectBaseInfoService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ProjectBaseInfo::getProjectStatus, ProjectBaseInfo::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "projectStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("bpProjectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"project#projectBaseInfo:add"})
    public Result<?> add(@RequestBody ProjectBaseInfoVO projectBaseInfoPage) {
        ProjectBaseInfo projectBaseInfo = new ProjectBaseInfo();
        BeanUtils.copyProperties((Object)((Object)projectBaseInfoPage), (Object)((Object)projectBaseInfo));
        projectBaseInfo.setProjectNumber(this.invokeBaseRpcService.getNextCode("bpProjectNumber", (Object)projectBaseInfoPage));
        this.projectBaseInfoService.saveMain(projectBaseInfo, projectBaseInfoPage.getProjectCostList(), projectBaseInfoPage.getProjectReceivablesList(), projectBaseInfoPage.getProjectEnclosureList());
        return Result.ok((Object)((Object)projectBaseInfo));
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"project#projectBaseInfo:edit"})
    public Result<?> edit(@RequestBody ProjectBaseInfoVO projectBaseInfoPage) {
        ProjectBaseInfo projectBaseInfo = new ProjectBaseInfo();
        BeanUtils.copyProperties((Object)((Object)projectBaseInfoPage), (Object)((Object)projectBaseInfo));
        this.projectBaseInfoService.updateMain(projectBaseInfo, projectBaseInfoPage.getProjectCostList(), projectBaseInfoPage.getProjectReceivablesList(), projectBaseInfoPage.getProjectEnclosureList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u8f6c\u8fd0\u7ef4", notes="\u8f6c\u8fd0\u7ef4")
    @PostMapping(value={"/transport"})
    @RequiresPermissions(value={"project#projectBaseInfo:transport"})
    public Result<?> transport(@RequestBody ProjectBaseInfoVO projectBaseInfoPage) {
        ProjectBaseInfo projectBaseInfo = new ProjectBaseInfo();
        BeanUtils.copyProperties((Object)((Object)projectBaseInfoPage), (Object)((Object)projectBaseInfo));
        this.projectBaseInfoService.transport(projectBaseInfo, projectBaseInfoPage.getProjectEnclosureList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"project#projectBaseInfo:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.projectBaseInfoService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"project#projectBaseInfo:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ProjectBaseInfo projectBaseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id)));
        ProjectBaseInfoVO projectBaseInfoVO = new ProjectBaseInfoVO();
        BeanUtils.copyProperties((Object)((Object)projectBaseInfo), (Object)((Object)projectBaseInfoVO));
        List<ProjectCost> projectCostList = this.projectCostService.selectByMainId(id);
        projectBaseInfoVO.setProjectCostList(projectCostList);
        List<ProjectReceivables> projectReceivablesList = this.projectReceivablesService.selectByMainId(id);
        projectBaseInfoVO.setProjectReceivablesList(projectReceivablesList);
        List<ProjectEnclosure> projectEnclosureList = this.projectEnclosureService.selectByMainId(id);
        projectBaseInfoVO.setProjectEnclosureList(projectEnclosureList);
        projectBaseInfoVO.setProjectMainPlanList(this.projectMainPlanService.selectByMainId(id));
        return Result.ok((Object)((Object)projectBaseInfoVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u8d39\u7528", notes="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u8d39\u7528")
    @GetMapping(value={"/queryProjectCostByMainId"})
    @RequiresPermissions(value={"project#projectBaseInfo:list"})
    public Result<?> queryProjectCostListByMainId(@RequestParam(name="id") String id) {
        List<ProjectCost> projectCostList = this.projectCostService.selectByMainId(id);
        return Result.ok(projectCostList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u6536\u6b3e", notes="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u6536\u6b3e")
    @GetMapping(value={"/queryProjectReceivablesByMainId"})
    @RequiresPermissions(value={"project#projectBaseInfo:list"})
    public Result<?> queryProjectReceivablesListByMainId(@RequestParam(name="id") String id) {
        List<ProjectReceivables> projectReceivablesList = this.projectReceivablesService.selectByMainId(id);
        return Result.ok(projectReceivablesList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u9644\u4ef6", notes="\u901a\u8fc7\u9879\u76ee\u4fe1\u606fid\u67e5\u8be2\u9879\u76ee\u9644\u4ef6")
    @GetMapping(value={"/queryProjectEnclosureByMainId"})
    @RequiresPermissions(value={"project#projectBaseInfo:list"})
    public Result<?> queryProjectEnclosureListByMainId(@RequestParam(name="id") String id) {
        List<ProjectEnclosure> projectEnclosureList = this.projectEnclosureService.selectByMainId(id);
        return Result.ok(projectEnclosureList);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"project#projectBaseInfo:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, ProjectInfoExportServiceImpl.class);
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u5237\u65b0\u6570\u636e")
    @ApiOperation(value="\u5237\u65b0\u6570\u636e", notes="\u5237\u65b0\u6570\u636e")
    @GetMapping(value={"/refresh"})
    @RequiresPermissions(value={"project#projectBaseInfo:refresh"})
    public Result<?> refresh(@RequestParam(name="id") String id) {
        this.projectBaseInfoService.refreshData((ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)id))));
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/updateCollectionInfo"})
    public int updateCollectionInfo() {
        return this.projectBaseInfoService.updateCollectionInfo();
    }

    @AutoLog(busModule="\u9879\u76ee\u4fe1\u606f", value="\u5237\u65b0\u6570\u636e")
    @ApiOperation(value="\u5237\u65b0\u9644\u4ef6\u6570\u636e", notes="\u5237\u65b0\u9644\u4ef6\u6570\u636e")
    @PostMapping(value={"/updateProjectEnclosure"})
    public Result<?> updateProjectEnclosure() {
        return Result.ok(this.projectBaseInfoService.updateProjectEnclosure());
    }
}

