/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.project.entity.ProjectMainPlanChange;
import com.els.modules.project.service.ProjectMainPlanChangeService;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9879\u76ee\u4e3b\u8ba1\u5212\u53d8\u66f4"})
@RestController
@RequestMapping(value={"/project/projectMainPlanChange"})
public class ProjectMainPlanChangeController
extends BaseController<ProjectMainPlanChange, ProjectMainPlanChangeService> {
    @Autowired
    private ProjectMainPlanChangeService projectMainPlanChangeService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    private void buildQueryWrapper(QueryWrapper<ProjectMainPlanChange> queryWrapper, ProjectMainPlanChange projectMainPlanChange) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("projectAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(this.getTenantId(), SysUtil.getLoginUser().getSubAccount());
        queryWrapper.eq((Object)"create_by_id", (Object)loginUser.getId());
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"project#projectMainPlanChange:list"})
    public Result<?> queryPageList(ProjectMainPlanChange projectMainPlanChange, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectMainPlanChange), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<ProjectMainPlanChange>)queryWrapper, projectMainPlanChange);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.projectMainPlanChangeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"project#projectMainPlanChange:list"})
    public Result<?> queryTabsCounts(ProjectMainPlanChange projectMainPlanChange, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectMainPlanChange), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"audit_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"audit_status");
        this.buildQueryWrapper((QueryWrapper<ProjectMainPlanChange>)queryWrapper, projectMainPlanChange);
        List list = ((ProjectMainPlanChangeService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ProjectMainPlanChange::getAuditStatus, ProjectMainPlanChange::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "auditStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAuditStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "auditStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212\u53d8\u66f4-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"project#projectMainPlanChange:add"})
    public Result<?> add(@RequestBody ProjectBaseInfoVO infoVO) {
        this.projectMainPlanChangeService.save(infoVO);
        return Result.ok((Object)((Object)infoVO));
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212\u53d8\u66f4-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"project#projectMainPlanChange:edit"})
    public Result<?> edit(@RequestBody ProjectBaseInfoVO infoVO) {
        this.projectMainPlanChangeService.save(infoVO);
        return Result.ok((Object)((Object)infoVO));
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212\u53d8\u66f4-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"project#projectMainPlanChange:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.projectMainPlanChangeService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"project#projectMainPlanChange:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.projectMainPlanChangeService.queryById(id));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryEditById"})
    @RequiresPermissions(value={"project#projectMainPlanChange:add"})
    public Result<?> queryEditById(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.projectMainPlanChangeService.queryEditById(id));
    }

    @GetMapping(value={"/checkId"})
    @RequiresPermissions(value={"project#projectMainPlanChange:add"})
    public Result<?> checkId(@RequestParam(name="id") String id) {
        int count = this.projectMainPlanChangeService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)id)).ne((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
        if (count > 0) {
            throw new ELSBootException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e3b\u8ba1\u5212\u53d8\u66f4\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        int mainPlan = ((ProjectMainPlanService)SpringContextUtils.getBean(ProjectMainPlanService.class)).count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)id)).eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue()));
        if (mainPlan == 0) {
            throw new ELSBootException("\u8be5\u9879\u76ee\u672a\u5b58\u5728\u5ba1\u6279\u901a\u8fc7\u7684\u4e3b\u8ba1\u5212\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return Result.ok();
    }
}

