/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.excel.ProjectMainPlanExportServiceImpl;
import com.els.modules.project.service.ProjectMainPlanService;
import com.els.modules.project.vo.ProjectBaseInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u9879\u76ee\u4e3b\u8ba1\u5212"})
@RestController
@RequestMapping(value={"/project/projectMainPlan"})
public class ProjectMainPlanController
extends BaseController<ProjectMainPlan, ProjectMainPlanService> {
    @Autowired
    private ProjectMainPlanService projectMainPlanService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"project#projectMainPlan:list"})
    public Result<?> queryPageList(ProjectMainPlan projectMainPlan, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectMainPlan), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.ne((Object)"main_plan_status", (Object)"0");
        this.buildQueryWrapper((QueryWrapper<ProjectMainPlan>)queryWrapper, projectMainPlan);
        IPage pageList = this.projectMainPlanService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"project#projectMainPlan:list"})
    public Result<?> queryTabsCounts(ProjectMainPlan projectMainPlan, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)projectMainPlan), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"main_plan_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.ne((Object)"main_plan_status", (Object)"0");
        this.buildQueryWrapper((QueryWrapper<ProjectMainPlan>)queryWrapper, projectMainPlan);
        queryWrapper.groupBy((Object)"main_plan_status");
        List list = ((ProjectMainPlanService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ProjectMainPlan::getMainPlanStatus, ProjectMainPlan::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "mainPlanStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("mainPlanStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "mainPlanStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    private void buildQueryWrapper(QueryWrapper<ProjectMainPlan> queryWrapper, ProjectMainPlan projectMainPlan) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("projectAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(this.getTenantId(), SysUtil.getLoginUser().getSubAccount());
        queryWrapper.in((Object)"project_manager_id", (Collection)accountIdList);
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212-\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"project#projectMainPlan:save"})
    public Result<?> save(@RequestBody ProjectBaseInfoVO infoVO) {
        this.projectMainPlanService.save(infoVO);
        return Result.ok((Object)((Object)infoVO));
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212-\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"project#projectMainPlan:submit"})
    public Result<?> submit(@RequestBody ProjectBaseInfoVO infoVO) {
        this.projectMainPlanService.submit(infoVO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"project#projectMainPlan:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.projectMainPlanService.queryByMainId(id)));
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212-\u542f\u52a8")
    @ApiOperation(value="\u542f\u52a8", notes="\u542f\u52a8")
    @PostMapping(value={"/start"})
    @RequiresPermissions(value={"project#projectMainPlan:start"})
    public Result<?> start(@RequestBody ProjectMainPlan mainPlan) {
        this.projectMainPlanService.start(mainPlan);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9879\u76ee\u4e3b\u8ba1\u5212-\u5b8c\u6210")
    @ApiOperation(value="\u5b8c\u6210", notes="\u5b8c\u6210")
    @PostMapping(value={"/finish"})
    @RequiresPermissions(value={"project#projectMainPlan:finish"})
    public Result<?> finish(@RequestBody ProjectMainPlan mainPlan) {
        this.projectMainPlanService.finish(mainPlan);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5f53\u524d\u4e3b\u8ba1\u5212", notes="\u901a\u8fc7id\u67e5\u8be2\u5f53\u524d\u4e3b\u8ba1\u5212")
    @GetMapping(value={"/findCurrentPlanByMainId"})
    @RequiresPermissions(value={"project#projectMainPlan:findCurrentPlanByMainId"})
    public Result<?> findCurrentPlanByMainId(@RequestParam(name="id") String id) {
        return Result.ok((Object)this.projectMainPlanService.findCurrentPlanByMainId(id));
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"project#projectMainPlan:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, ProjectMainPlanExportServiceImpl.class);
    }

    @ApiOperation(value="\u540c\u6b65\u4e3b\u8ba1\u5212\u9879\u76ee\u7ecf\u7406", notes="\u540c\u6b65\u4e3b\u8ba1\u5212\u9879\u76ee\u7ecf\u7406")
    @PostMapping(value={"/syncProjectManange"})
    public void syncProjectManange() {
        this.projectMainPlanService.syncProjectManange();
    }
}

