/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.project.entity.BpProjectAccountingHead;
import com.els.modules.project.service.BpProjectAccountingHeadService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpProjectAccountingHeadExportServiceImpl")
public class BpProjectAccountingHeadExportServiceImpl
extends BaseExportService<BpProjectAccountingHead, BpProjectAccountingHead, BpProjectAccountingHead>
implements ExportDataLoaderService {
    @Autowired
    private BpProjectAccountingHeadService bpProjectAccountingHeadService;

    public List<BpProjectAccountingHead> queryExportData(QueryWrapper<BpProjectAccountingHead> queryWrapper, BpProjectAccountingHead param, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper(queryWrapper);
        List pageList = this.bpProjectAccountingHeadService.list((Wrapper)queryWrapper);
        return pageList;
    }

    public long queryExportDataCount(QueryWrapper<BpProjectAccountingHead> queryWrapper, BpProjectAccountingHead map, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper(queryWrapper);
        return this.bpProjectAccountingHeadService.count((Wrapper)queryWrapper);
    }

    public String getBusinessType() {
        return "projectAccounting";
    }

    public String getBeanName() {
        return "bpProjectAccountingHeadExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.buildQueryWrapper((QueryWrapper<BpProjectAccountingHead>)queryWrapper);
        List records = ((Page)this.bpProjectAccountingHeadService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        return JSON.toJSONString((Object)records);
    }

    private void buildQueryWrapper(QueryWrapper<BpProjectAccountingHead> queryWrapper) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("ProjectAccounting")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        accountIdList.add(currentUserId);
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)q.in((Object)"project_manager_id", (Collection)accountIdList);
        });
    }
}

