/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectInfoExportServiceImpl")
public class ProjectInfoExportServiceImpl
extends BaseExportService<ProjectBaseInfo, ProjectBaseInfo, ProjectBaseInfo>
implements ExportDataLoaderService {
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;

    public List<ProjectBaseInfo> queryExportData(QueryWrapper<ProjectBaseInfo> queryWrapper, ProjectBaseInfo param, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper(queryWrapper, param);
        List pageList = this.projectBaseInfoService.list((Wrapper)queryWrapper);
        return pageList;
    }

    public long queryExportDataCount(QueryWrapper<ProjectBaseInfo> queryWrapper, ProjectBaseInfo map, Map<String, String[]> paramMap) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        this.buildQueryWrapper(queryWrapper, map);
        return this.projectBaseInfoService.count((Wrapper)queryWrapper);
    }

    private void buildQueryWrapper(QueryWrapper<ProjectBaseInfo> queryWrapper, ProjectBaseInfo projectBaseInfo) {
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("projectAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        String currentUserId = SysUtil.getLoginUser().getId();
        queryWrapper.and(q -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.in((Object)"project_manager_id", (Collection)accountIdList)).or()).eq((Object)"project_chief_inspector_id", (Object)currentUserId)).or()).eq((Object)"dev_chargeman_id", (Object)currentUserId)).or()).eq((Object)"customer_manager_id", (Object)currentUserId)).or()).eq((Object)"dep_director_id", (Object)currentUserId)).or()).eq((Object)"create_by_id", (Object)currentUserId)).or()).eq((Object)"customer_success_manager_id", (Object)currentUserId);
        });
    }

    public String getBusinessType() {
        return "bpProjectBaseInfo";
    }

    public String getBeanName() {
        return "projectInfoExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        this.buildQueryWrapper((QueryWrapper<ProjectBaseInfo>)queryWrapper, null);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List records = ((Page)this.projectBaseInfoService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        return JSON.toJSONString((Object)records);
    }
}

