/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.service.AccountExtendRpcService;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.project.entity.ProjectMainPlan;
import com.els.modules.project.service.ProjectMainPlanService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectMainPlanExportServiceImpl")
public class ProjectMainPlanExportServiceImpl
extends BaseExportService<ProjectMainPlan, ProjectMainPlan, ProjectMainPlan>
implements ExportDataLoaderService {
    @Autowired
    private ProjectMainPlanService projectMainPlanService;

    public List<ProjectMainPlan> queryExportData(QueryWrapper<ProjectMainPlan> queryWrapper, ProjectMainPlan param, Map<String, String[]> paramMap) {
        this.buildQueryWrapper(queryWrapper, param);
        List pageList = this.projectMainPlanService.list((Wrapper)queryWrapper);
        return pageList;
    }

    public long queryExportDataCount(QueryWrapper<ProjectMainPlan> queryWrapper, ProjectMainPlan map, Map<String, String[]> paramMap) {
        this.buildQueryWrapper(queryWrapper, map);
        return this.projectMainPlanService.count((Wrapper)queryWrapper);
    }

    private void buildQueryWrapper(QueryWrapper<ProjectMainPlan> queryWrapper, ProjectMainPlan projectMainPlan) {
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.ne((Object)"main_plan_status", (Object)"0");
        LoginUser loginUser = SysUtil.getLoginUser();
        Set roleSet = ((AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class)).getUserRolesSet(TenantContext.getTenant(), loginUser.getSubAccount());
        if ("1".equals(AdminFlagUtil.getAdminFlag()) || roleSet.contains("projectAuditor")) {
            return;
        }
        List accountIdList = ((AccountExtendRpcService)SpringContextUtils.getBean(AccountExtendRpcService.class)).getAccountIdListByLeader(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        queryWrapper.in((Object)"project_manager_id", (Collection)accountIdList);
    }

    public String getBusinessType() {
        return "projectMainPlanList";
    }

    public String getBeanName() {
        return "projectMainPlanExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        this.buildQueryWrapper((QueryWrapper<ProjectMainPlan>)queryWrapper, null);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List records = ((Page)this.projectMainPlanService.page((IPage)page, (Wrapper)queryWrapper)).getRecords();
        return JSON.toJSONString((Object)records);
    }
}

