/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.project.entity.BpSystemDeployApply;
import com.els.modules.project.enumerate.SystemDeployApplyStatusEnum;
import com.els.modules.project.service.BpSystemDeployApplyService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpServerFeesServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(BpServerFeesServiceImpl.class);
    @Autowired
    private BpSystemDeployApplyService bpSystemDeployApplyService;

    public void execute(String parameter) {
        log.info("execute_BpServerFeesServiceImpl:" + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String elsAccount = paramObj.getString("elsAccount");
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException("elsAccount_isBlank !");
        }
        TenantContext.setTenant((String)elsAccount);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.and(wrapper -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BpSystemDeployApply::getStatus, (Object)SystemDeployApplyStatusEnum.DONE.getValue())).or()).eq(BpSystemDeployApply::getStatus, (Object)SystemDeployApplyStatusEnum.DOWN_SERVE.getValue());
        });
        List applyList = this.bpSystemDeployApplyService.list((Wrapper)lambdaUpdateWrapper);
        if (CollectionUtils.isEmpty((Collection)applyList)) {
            return;
        }
        for (BpSystemDeployApply bpSystemDeployApply : applyList) {
            try {
                this.bpSystemDeployApplyService.calculate(bpSystemDeployApply);
            }
            catch (Exception e) {
                log.error("\u9879\u76ee\u7f16\u53f7\uff1a" + bpSystemDeployApply.getProjectNumber() + " \u6267\u884c\u8ba1\u7b97\u903b\u8f91\u62a5\u9519\uff01", (Throwable)e);
            }
        }
    }
}

