/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectCostRefreshServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(ProjectCostRefreshServiceImpl.class);
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;

    public void execute(String parameter) {
        log.info("execute_ProjectCostRefreshServiceImpl:" + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String elsAccount = paramObj.getString("elsAccount");
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException("elsAccount_isBlank !");
        }
        TenantContext.setTenant((String)elsAccount);
        List baseInfoList = this.projectBaseInfoService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        if (!baseInfoList.isEmpty()) {
            for (ProjectBaseInfo baseInfo : baseInfoList) {
                try {
                    this.projectBaseInfoService.refreshData(baseInfo);
                }
                catch (Exception e) {
                    log.error("\u9879\u76ee\u7f16\u53f7\uff1a" + baseInfo.getProjectNumber() + " \u6267\u884c\u8ba1\u7b97\u903b\u8f91\u62a5\u9519\uff01", (Throwable)e);
                }
            }
        } else {
            log.info("baseInfoList_size_0");
        }
    }
}

