/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.job;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.service.SalesContractApiService;
import com.els.modules.employ.api.dto.ElsEmployeInfoDTO;
import com.els.modules.employ.api.service.EmployeeInfoRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.service.ProjectBaseInfoService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProjectInfoSyncServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(ProjectInfoSyncServiceImpl.class);
    @Value(value="${finance.config.tokenUrl}")
    private String tokenUrl;
    @Value(value="${finance.config.projectUrl}")
    private String projectUrl;
    @Value(value="${finance.config.clientId}")
    private String clientId;
    @Value(value="${finance.config.clientSecret}")
    private String clientSecret;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private EmployeeInfoRpcService employeeInfoRpcService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Autowired
    private SalesContractApiService salesContractApiService;

    public void execute(String parameter) {
        log.info("execute_ProjectInfoSyncServiceImpl:" + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String elsAccount = paramObj.getString("elsAccount");
        PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO = null;
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException("elsAccount_isBlank !");
        }
        List baseInfoList = this.projectBaseInfoService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        if (!baseInfoList.isEmpty()) {
            JSONArray array = new JSONArray();
            for (ProjectBaseInfo baseInfo : baseInfoList) {
                String contractNumber;
                ElsEmployeInfoDTO elsEmployeInfoDTO1;
                JSONObject itemObj = new JSONObject();
                itemObj.put("code", (Object)baseInfo.getProjectNumber());
                itemObj.put("project_name", (Object)baseInfo.getProjectName());
                ElsEmployeInfoDTO elsEmployeInfoDTO = this.employeeInfoRpcService.getEmployeeInfoBySubAccountId1(baseInfo.getProjectManagerId());
                if (elsEmployeInfoDTO != null) {
                    itemObj.put("project_owner", (Object)elsEmployeInfoDTO.getWorkNum());
                }
                if (StringUtils.isNotBlank((CharSequence)baseInfo.getAffiliatedDepartmentId())) {
                    purchaseOrganizationInfoDTO = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "dept", baseInfo.getAffiliatedDepartmentId());
                }
                if (purchaseOrganizationInfoDTO != null) {
                    itemObj.put("project_department", (Object)purchaseOrganizationInfoDTO.getOrgCode());
                }
                itemObj.put("description", (Object)baseInfo.getRemark());
                String isOpend = "Y";
                if ("stop".equals(baseInfo.getProjectStatus())) {
                    isOpend = "N";
                }
                itemObj.put("enabled_flag", (Object)isOpend);
                String projectStatus = baseInfo.getProjectStatus();
                projectStatus = "conclusion".equals(projectStatus) || "stop".equals(projectStatus) ? "complete" : "incomplete";
                if (StringUtils.isNotBlank((CharSequence)baseInfo.getProjectChiefInspectorId()) && (elsEmployeInfoDTO1 = this.employeeInfoRpcService.getEmployeeInfoBySubAccountId(baseInfo.getProjectChiefInspectorId())) != null) {
                    itemObj.put("column9", (Object)elsEmployeInfoDTO1.getLoginName());
                }
                if (StringUtils.isNotBlank((CharSequence)baseInfo.getParentContractBaseinfoId()) && StringUtils.isNotBlank((CharSequence)(contractNumber = this.salesContractApiService.selectById(baseInfo.getParentContractBaseinfoId())))) {
                    itemObj.put("column10", (Object)contractNumber);
                }
                itemObj.put("project_status", (Object)projectStatus);
                itemObj.put("parent_code", (Object)baseInfo.getParentProjectId());
                array.add((Object)itemObj);
            }
            JSONObject requestParam = new JSONObject();
            requestParam.put("bizld", (Object)IdWorker.get32UUID());
            requestParam.put("timestamp", (Object)System.currentTimeMillis());
            requestParam.put("data", (Object)array);
            String synchronizationUrl = this.projectUrl + "?access_token=" + this.getToken();
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            log.info("ProjectInfoSyncServiceImpl request : {} ", (Object)JSON.toJSONString((Object)requestParam));
            String response = ((HttpRequest)HttpRequest.post((String)synchronizationUrl).addHeaders(header)).body(requestParam.toJSONString()).execute().body();
            log.info("ProjectInfoSyncServiceImpl response\uff1a{} ", (Object)response);
        } else {
            log.info("baseInfoList_size_0");
        }
    }

    private String getToken() {
        HashMap<String, String> reqtokenMap = new HashMap<String, String>();
        reqtokenMap.put("grant_type", "client_credentials");
        reqtokenMap.put("client_id", this.clientId);
        reqtokenMap.put("client_secret", this.clientSecret);
        HttpRequest httpRequest = HttpUtil.createGet((String)this.tokenUrl);
        httpRequest.form(reqtokenMap);
        String result = httpRequest.execute().body();
        JSONObject responseObj = JSONObject.parseObject((String)result);
        JSONObject jsonObject = (JSONObject)responseObj.get((Object)"data");
        String token = (String)jsonObject.get((Object)"access_token");
        return token;
    }
}

