/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.dto.BpContractCollectionDto;
import com.els.modules.contract.dto.PurchaseContractDto;
import com.els.modules.contract.service.BpContractCollectionApiService;
import com.els.modules.contract.service.PurchaseContractHeadApiService;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.project.entity.BpProjectAccountingHead;
import com.els.modules.project.entity.BpServerFeesHead;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.entity.ProjectWeekReport;
import com.els.modules.project.mapper.BpProjectAccountingHeadMapper;
import com.els.modules.project.service.BpProjectAccountingHeadService;
import com.els.modules.project.service.BpServerFeesHeadService;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.ProjectWeekReportService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BpProjectAccountingHeadServiceImpl
extends BaseServiceImpl<BpProjectAccountingHeadMapper, BpProjectAccountingHead>
implements BpProjectAccountingHeadService {
    private static final Logger log = LogManager.getLogger(BpProjectAccountingHeadServiceImpl.class);
    @Autowired
    private ProjectWeekReportService projectWeekReportService;
    @Autowired
    private BpContractCollectionApiService bpContractCollectionApiService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private BpServerFeesHeadService bpServerFeesHeadService;
    @Autowired
    private PurchaseContractHeadApiService purchaseContractHeadApiService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;

    @Override
    public void calculate() {
        List reportList = this.projectWeekReportService.list();
        if (CollectionUtils.isEmpty((Collection)reportList)) {
            return;
        }
        Map<String, List<ProjectWeekReport>> reportMap = reportList.stream().filter(report -> !StringUtils.isEmpty((Object)report.getProjectCode())).collect(Collectors.groupingBy(ProjectWeekReport::getProjectCode));
        for (Map.Entry<String, List<ProjectWeekReport>> entry : reportMap.entrySet()) {
            try {
                this.handleProjectAccount(entry);
            }
            catch (Exception e) {
                log.error("project id: {} , error : {} ", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
    }

    private void handleProjectAccount(Map.Entry<String, List<ProjectWeekReport>> entry) {
        List contractCollectionList;
        BigDecimal projectProgress;
        String projectId = entry.getKey();
        List<ProjectWeekReport> reports = entry.getValue();
        ProjectWeekReport report = this.getReport(reports);
        if (report != null && ((projectProgress = report.getProjectProgress()) == null || BigDecimal.ZERO.compareTo(projectProgress) == 0)) {
            return;
        }
        ProjectBaseInfo project = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)projectId)));
        if (project == null) {
            return;
        }
        BpProjectAccountingHead projectAccounting = this.getBpProjectAccountingHead(projectId);
        String contractId = project.getParentContractBaseinfoId();
        BigDecimal comprehensivePurchaseAmount = BigDecimal.ZERO;
        BigDecimal otherProcurementCosts = BigDecimal.ZERO;
        List purchaseContractHeadList = this.purchaseContractHeadApiService.selectByProjectId(projectId);
        if (!CollectionUtils.isEmpty((Collection)purchaseContractHeadList)) {
            comprehensivePurchaseAmount = purchaseContractHeadList.parallelStream().filter(item -> item.getTotalTaxAmount() != null).map(PurchaseContractDto::getTotalTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            otherProcurementCosts = this.getOtherProcurementCosts(purchaseContractHeadList);
        }
        BigDecimal outsourcingContractAmount = null;
        List projectOutsourcingContractList = this.purchaseContractHeadApiService.selectProjectOutsourcingContractByProjectId(projectId);
        if (!CollectionUtils.isEmpty((Collection)projectOutsourcingContractList)) {
            outsourcingContractAmount = projectOutsourcingContractList.parallelStream().filter(item -> item.getTotalTaxAmount() != null).map(PurchaseContractDto::getTotalTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal collectionAmount = BigDecimal.ZERO;
        if (!StringUtils.isEmpty((Object)contractId) && !CollectionUtils.isEmpty((Collection)(contractCollectionList = this.bpContractCollectionApiService.selectBpContractById(contractId)))) {
            collectionAmount = contractCollectionList.parallelStream().filter(item -> item.getCollectionAmount() != null).map(BpContractCollectionDto::getCollectionAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("projectId: {} , \u7d2f\u8ba1\u56de\u6b3e\u91d1\u989d: {}", (Object)projectId, (Object)collectionAmount);
        }
        BigDecimal serverFees = BigDecimal.ZERO;
        LambdaQueryWrapper feesQueryWrapper = new LambdaQueryWrapper();
        feesQueryWrapper.eq(BpServerFeesHead::getProjectId, (Object)projectId);
        List feesList = this.bpServerFeesHeadService.list((Wrapper)feesQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)feesList)) {
            serverFees = feesList.parallelStream().filter(item -> item.getServerFees() != null).map(BpServerFeesHead::getServerFees).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("projectId: {} , \u670d\u52a1\u5668\u6210\u672c: {}", (Object)projectId, (Object)serverFees);
        }
        BigDecimal totalContractAmount = project.getTotalContractAmount();
        String fbk7 = project.getFbk7();
        BigDecimal actualPersonDayCost = project.getActualPersonDayCost();
        BigDecimal actualTravelCost = project.getActualTravelCost();
        BigDecimal projectRevenue = BigDecimal.ZERO;
        BigDecimal outsourcingCosts = BigDecimal.ZERO;
        if (report != null) {
            boolean flag2;
            boolean flag;
            String cycle = report.getCycle();
            log.info("projectId: {} , \u62a5\u544a\u5468\u671f: {}", (Object)projectId, (Object)cycle);
            BigDecimal outsourcingProgress = report.getOutsourcingProgress();
            boolean bl = flag = outsourcingProgress != null && BigDecimal.ZERO.compareTo(outsourcingProgress) != 0 && outsourcingContractAmount != null && BigDecimal.ZERO.compareTo(outsourcingContractAmount) != 0;
            if (flag) {
                BigDecimal rate = new BigDecimal("0.01");
                outsourcingCosts = rate.multiply(outsourcingProgress).multiply(outsourcingContractAmount);
            }
            BigDecimal projectProgress2 = report.getProjectProgress();
            boolean bl2 = flag2 = totalContractAmount != null && BigDecimal.ZERO.compareTo(totalContractAmount) != 0;
            if (flag2) {
                BigDecimal rate = new BigDecimal("0.01");
                projectRevenue = rate.multiply(projectProgress2).multiply(totalContractAmount);
            }
            projectAccounting.setProjectStage(report.getProjectStage());
            projectAccounting.setProjectProgress(report.getProjectProgress());
            projectAccounting.setOutsourcingProgress(report.getOutsourcingProgress());
            projectAccounting.setWeeklyCycle(report.getWeeklyCycle());
        }
        actualPersonDayCost = this.initData(actualPersonDayCost);
        actualTravelCost = this.initData(actualTravelCost);
        otherProcurementCosts = this.initData(otherProcurementCosts);
        outsourcingCosts = this.initData(outsourcingCosts);
        serverFees = this.initData(serverFees);
        BigDecimal totalCost = actualPersonDayCost.add(actualTravelCost).add(otherProcurementCosts).add(outsourcingCosts).add(serverFees);
        projectRevenue = this.initData(projectRevenue);
        BigDecimal profitAmount = projectRevenue.subtract(totalCost);
        BigDecimal projectGrossMargin = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(profitAmount) != 0 && BigDecimal.ZERO.compareTo(projectRevenue) != 0) {
            projectGrossMargin = profitAmount.multiply(new BigDecimal("100")).divide(projectRevenue, 1, 4);
        }
        PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService = (PurchaseOrganizationInfoRpcService)SpringContextUtils.getBean(PurchaseOrganizationInfoRpcService.class);
        String affiliatedDepartmentName = project.getAffiliatedDepartmentName();
        affiliatedDepartmentName = this.handleDepartmentInfo(purchaseOrganizationInfoRpcService, affiliatedDepartmentName);
        projectAccounting.setProjectId(projectId);
        projectAccounting.setProjectNumber(project.getProjectNumber());
        projectAccounting.setProjectName(project.getProjectName());
        projectAccounting.setProjectType(project.getProjectType());
        projectAccounting.setStartDate(project.getStartDate());
        projectAccounting.setProjectManagerId(project.getProjectManagerId());
        projectAccounting.setProjectManagerName(project.getProjectManagerName());
        projectAccounting.setProjectChiefInspectorId(project.getProjectChiefInspectorId());
        projectAccounting.setProjectChiefInspectorName(project.getProjectChiefInspectorName());
        projectAccounting.setAffiliatedDepartmentId(project.getAffiliatedDepartmentId());
        projectAccounting.setAffiliatedDepartmentName(affiliatedDepartmentName);
        projectAccounting.setCustomerSuccessManager(project.getCustomerSuccessManager());
        projectAccounting.setCustomerSuccessManagerId(project.getCustomerSuccessManagerId());
        projectAccounting.setDeployMode(project.getDeployMode());
        projectAccounting.setDeploymentSystem(project.getDeploymentSystem());
        projectAccounting.setTotalContractAmount(project.getTotalContractAmount());
        projectAccounting.setFirstYearContractAmount(project.getFbk7());
        projectAccounting.setParentContractBaseinfoId(project.getParentContractBaseinfoId());
        projectAccounting.setParentContractName(project.getParentContractName());
        projectAccounting.setDirectManDayCost(project.getActualPersonDayCost());
        projectAccounting.setTravelExpenses(project.getActualTravelCost());
        projectAccounting.setCumulativePaybackAmount(collectionAmount);
        projectAccounting.setOutsourcingContractAmount(outsourcingContractAmount);
        projectAccounting.setComprehensivePurchaseAmount(comprehensivePurchaseAmount);
        projectAccounting.setOutsourcingCosts(outsourcingCosts);
        projectAccounting.setServerCosts(serverFees);
        projectAccounting.setOtherProcurementCosts(otherProcurementCosts);
        projectAccounting.setProjectRevenue(projectRevenue);
        projectAccounting.setProjectGrossMargin(projectGrossMargin);
        projectAccounting.setTotalCost(totalCost);
        this.saveOrUpdate((Object)projectAccounting);
    }

    private String handleDepartmentInfo(PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService, String affiliatedDepartmentName) {
        Optional optional;
        PurchaseOrganizationInfoDTO organizationInfo;
        ArrayList<String> departmentId = new ArrayList<String>();
        departmentId.add(affiliatedDepartmentName);
        List organizationInfoDTOList = purchaseOrganizationInfoRpcService.listByIds(departmentId);
        if (!CollectionUtils.isEmpty((Collection)organizationInfoDTOList) && !StringUtils.isEmpty((Object)(organizationInfo = (PurchaseOrganizationInfoDTO)(optional = organizationInfoDTOList.stream().findFirst()).get()).getOrgName())) {
            affiliatedDepartmentName = organizationInfo.getOrgName();
        }
        return affiliatedDepartmentName;
    }

    private BigDecimal initData(BigDecimal actualPersonDayCost) {
        if (actualPersonDayCost == null) {
            actualPersonDayCost = BigDecimal.ZERO;
        }
        return actualPersonDayCost;
    }

    private BigDecimal getOtherProcurementCosts(List<PurchaseContractDto> purchaseContractHeadList) {
        BigDecimal otherProcurementCosts = BigDecimal.ZERO;
        List contractIds = purchaseContractHeadList.stream().filter(contract -> !StringUtils.isEmpty((Object)contract.getId())).map(PurchaseContractDto::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchasePaymentApplyItem::getSourceId, contractIds);
        List list = this.purchasePaymentApplyItemService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return otherProcurementCosts;
        }
        Set headIds = list.stream().map(PurchasePaymentApplyItem::getHeadId).collect(Collectors.toSet());
        List purchasePaymentApplyHeadList = this.purchasePaymentApplyHeadService.listByIds(headIds);
        if (CollectionUtils.isEmpty((Collection)purchasePaymentApplyHeadList)) {
            return otherProcurementCosts;
        }
        List ids = purchasePaymentApplyHeadList.stream().filter(applyHead -> "2".equals(applyHead.getAuditStatus())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list = list.stream().filter(paymentItem -> ids.contains(paymentItem.getHeadId())).collect(Collectors.toList()))) {
            return otherProcurementCosts;
        }
        otherProcurementCosts = list.parallelStream().filter(item -> item.getApplyAmount() != null).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return otherProcurementCosts;
    }

    private BpProjectAccountingHead getBpProjectAccountingHead(String projectId) {
        LambdaQueryWrapper projectAccountingQueryWrapper = new LambdaQueryWrapper();
        projectAccountingQueryWrapper.eq(BpProjectAccountingHead::getProjectId, (Object)projectId);
        BpProjectAccountingHead projectAccounting = null;
        List projectAccountingList = this.list((Wrapper)projectAccountingQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)projectAccountingList)) {
            Optional projectAccountingHeadOptional = projectAccountingList.stream().findFirst();
            projectAccounting = (BpProjectAccountingHead)((Object)projectAccountingHeadOptional.get());
        } else {
            projectAccounting = new BpProjectAccountingHead();
            String accountingNumber = this.invokeBaseRpcService.getNextCode("accountingNumber", (Object)projectAccounting);
            projectAccounting.setAccountingNumber(accountingNumber);
            this.buildTemplate(projectAccounting);
        }
        return projectAccounting;
    }

    private void buildTemplate(BpProjectAccountingHead projectAccounting) {
        List templateHeadDTOList = this.invokeBaseRpcService.getDefaultTemplateByType("projectAccounting");
        if (CollectionUtils.isEmpty((Collection)templateHeadDTOList)) {
            return;
        }
        Optional templateHeadOptional = templateHeadDTOList.stream().findFirst();
        TemplateHeadDTO templateHead = (TemplateHeadDTO)templateHeadOptional.get();
        projectAccounting.setTemplateAccount(templateHead.getElsAccount());
        projectAccounting.setTemplateName(templateHead.getTemplateName());
        projectAccounting.setTemplateNumber(templateHead.getTemplateNumber());
        projectAccounting.setTemplateVersion(templateHead.getTemplateVersion());
    }

    private ProjectWeekReport getReport(List<ProjectWeekReport> reports) {
        if (CollectionUtils.isEmpty(reports)) {
            return null;
        }
        List collect = reports.stream().filter(report -> report.getPublishTime() != null).sorted(Comparator.comparing(ProjectWeekReport::getPublishTime).reversed()).collect(Collectors.toList());
        Optional optional = collect.stream().findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return (ProjectWeekReport)((Object)optional.get());
    }
}

