/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.els.modules.project.vo.BpServerFeesCalculateVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BpServerFeesCalculateServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(BpServerFeesCalculateServiceImpl.class);

    public List<BpServerFeesCalculateVO> getCycleList(Date startDate, Date endDate) {
        ArrayList<BpServerFeesCalculateVO> calculateList = new ArrayList<BpServerFeesCalculateVO>();
        List<String> specialDate = this.getSpecialDateList();
        log.info("\u8d77\u59cb\u65f6\u95f4: {} , \u7ed3\u675f\u65f6\u95f4: {}", (Object)startDate, (Object)endDate);
        DateTime tempStartDate = null;
        DateTime tempEndDate = null;
        tempStartDate = new DateTime(startDate);
        DateTime endDateTime = new DateTime(endDate);
        log.info("==========\u8ba1\u7b97\u5f00\u59cb==========");
        while (tempStartDate.before((Date)endDateTime)) {
            BpServerFeesCalculateVO vo = new BpServerFeesCalculateVO();
            calculateList.add(vo);
            int day = DateUtil.dayOfMonth((Date)tempStartDate);
            int nowMonth = DateUtil.month((Date)tempStartDate) + 1;
            vo.setNowStartDay(day);
            vo.setNowMonth(nowMonth);
            if (specialDate.contains(day + "") && (nowMonth == 1 || nowMonth == 2)) {
                tempEndDate = DateUtil.offsetDay((Date)tempStartDate, (int)30);
                vo.setCalculateType("\u52a030\u5929");
            } else {
                tempEndDate = DateUtil.offsetMonth((Date)tempStartDate, (int)1);
                vo.setCalculateType("\u52a0\u4e00\u4e2a\u6708");
            }
            tempEndDate = DateUtil.offsetDay((Date)tempEndDate, (int)-1);
            if (tempEndDate.after((Date)endDateTime)) {
                tempEndDate = endDateTime;
            }
            vo.setIntervalStart(tempStartDate);
            vo.setIntervalEnd(tempEndDate);
            long betweenDays = DateUtil.between((Date)tempEndDate, (Date)tempStartDate, (DateUnit)DateUnit.DAY);
            vo.setIntervalDates(betweenDays);
            tempStartDate = DateUtil.offsetDay((Date)tempEndDate, (int)1);
        }
        return calculateList;
    }

    private List<String> getSpecialDateList() {
        ArrayList<String> specialDate = new ArrayList<String>();
        specialDate.add("28");
        specialDate.add("29");
        specialDate.add("30");
        specialDate.add("31");
        return specialDate;
    }
}

