/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.project.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.service.SalesContractApiService;
import com.els.modules.email.EmailSendService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.project.entity.BpDeployModuleProgress;
import com.els.modules.project.entity.BpServerFeesHead;
import com.els.modules.project.entity.BpServerFeesItem;
import com.els.modules.project.entity.BpSystemDeployApply;
import com.els.modules.project.entity.ProjectBaseInfo;
import com.els.modules.project.enumerate.SystemDeployApplyStatusEnum;
import com.els.modules.project.enumerate.SystemDeployedModeEnum;
import com.els.modules.project.mapper.BpSystemDeployApplyMapper;
import com.els.modules.project.service.BpDeployModuleProgressService;
import com.els.modules.project.service.BpServerFeesHeadService;
import com.els.modules.project.service.BpServerFeesItemService;
import com.els.modules.project.service.BpSystemDeployApplyService;
import com.els.modules.project.service.ProjectBaseInfoService;
import com.els.modules.project.service.impl.BpServerFeesCalculateServiceImpl;
import com.els.modules.project.utils.DateUtils;
import com.els.modules.project.vo.BpServerFeesCalculateVO;
import com.els.modules.project.vo.BpSystemDeployApplyVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpSystemDeployApplyServiceImpl
extends BaseServiceImpl<BpSystemDeployApplyMapper, BpSystemDeployApply>
implements BpSystemDeployApplyService {
    private static final Logger log = LoggerFactory.getLogger(BpSystemDeployApplyServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SalesContractApiService salesContractApiService;
    @Autowired
    private ProjectBaseInfoService projectBaseInfoService;
    @Autowired
    private BpDeployModuleProgressService bpDeployModuleProgressService;
    @Autowired
    private BpServerFeesHeadService bpServerFeesHeadService;
    @Autowired
    private BpServerFeesItemService bpServerFeesItemService;
    @Autowired
    private BpServerFeesCalculateServiceImpl bpServerFeesCalculateService;
    @Autowired
    private EmailSendService emailSendService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveBpSystemDeployApply(BpSystemDeployApplyVO vo) {
        BpSystemDeployApply bpSystemDeployApply = new BpSystemDeployApply();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)bpSystemDeployApply));
        String applyNumber = this.invokeBaseRpcService.getNextCode("systemDeployApplyNumber", (Object)bpSystemDeployApply);
        bpSystemDeployApply.setApplyNumber(applyNumber);
        this.handleDockingPeople(bpSystemDeployApply);
        Object salesContract = this.salesContractApiService.getById(bpSystemDeployApply.getParentContractBaseinfoId());
        if (salesContract != null) {
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)salesContract), Map.class);
            String customerName = map.get("customerName") + "";
            bpSystemDeployApply.setCustomerName(customerName);
        }
        bpSystemDeployApply.setStatus(SystemDeployApplyStatusEnum.NEW.getValue());
        ((BpSystemDeployApplyMapper)this.baseMapper).insert((Object)bpSystemDeployApply);
        this.insertBpDeployModuleProgress(bpSystemDeployApply, vo.getProgressList());
        vo.setId(bpSystemDeployApply.getId());
    }

    private void handleDockingPeople(BpSystemDeployApply bpSystemDeployApply) {
        if (!StringUtils.isEmpty((CharSequence)bpSystemDeployApply.getDockingPeople())) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        bpSystemDeployApply.setDockingPeople(loginUser.getRealname());
        bpSystemDeployApply.setDockingPeopleId(loginUser.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateBpSystemDeployApply(BpSystemDeployApplyVO vo) {
        BpSystemDeployApply bpSystemDeployApply = new BpSystemDeployApply();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)bpSystemDeployApply));
        String projectId = bpSystemDeployApply.getProjectId();
        this.checkData(projectId);
        this.handleDockingPeople(bpSystemDeployApply);
        ((BpSystemDeployApplyMapper)this.baseMapper).updateById((Object)bpSystemDeployApply);
        this.bpDeployModuleProgressService.deleteByMainId(vo.getId());
        this.insertBpDeployModuleProgress(bpSystemDeployApply, vo.getProgressList());
    }

    private void checkData(String projectId) {
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        ProjectBaseInfo projectBaseInfo = (ProjectBaseInfo)((Object)this.projectBaseInfoService.getById((Serializable)((Object)projectId)));
        if (projectBaseInfo == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)projectBaseInfo.getProjectChiefInspectorId())) {
            throw new ELSBootException("\u9879\u76ee\u603b\u76d1\u4e0d\u5b58\u5728, \u8bf7\u7ef4\u62a4'\u9879\u76ee\u4fe1\u606f'\u7684\u9879\u76ee\u603b\u76d1\u4fe1\u606f!");
        }
        if (StringUtils.isEmpty((CharSequence)projectBaseInfo.getProjectManagerId())) {
            throw new ELSBootException("\u9879\u76ee\u7ecf\u7406\u4e0d\u5b58\u5728, \u8bf7\u7ef4\u62a4'\u9879\u76ee\u4fe1\u606f'\u7684\u9879\u76ee\u7ecf\u7406\u4fe1\u606f!");
        }
    }

    private void insertBpDeployModuleProgress(BpSystemDeployApply apply, List<BpDeployModuleProgress> progressList) {
        if (CollectionUtils.isEmpty(progressList)) {
            return;
        }
        for (BpDeployModuleProgress progress : progressList) {
            progress.setHeadId(apply.getId());
            SysUtil.setSysParam((BaseEntity)progress, (BaseEntity)apply);
            progress.setId(null);
            progress.setToElsAccount("");
        }
        this.bpDeployModuleProgressService.saveBatch(progressList, 2000);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBpSystemDeployApply(String id) {
        ((BpSystemDeployApplyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.bpDeployModuleProgressService.deleteByMainId(id);
    }

    @Override
    public void delBatchBpSystemDeployApply(List<String> idList) {
        ((BpSystemDeployApplyMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void calculate(BpSystemDeployApply bpSystemDeployApply) {
        String id = bpSystemDeployApply.getId();
        BpSystemDeployApply apply = (BpSystemDeployApply)((Object)this.getById((Serializable)((Object)id)));
        if ("local".equals(apply.getDeploymentLocation()) || "Private".equals(apply.getDeploymentLocation())) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpServerFeesHead::getDeployId, (Object)id);
        BpServerFeesHead head = (BpServerFeesHead)((Object)this.bpServerFeesHeadService.getOne((Wrapper)lambdaQueryWrapper));
        if (head == null) {
            head = this.createServerFeesHead(id, apply);
        } else {
            this.bpServerFeesItemService.deleteByMainId(head.getId());
        }
        String systemDeployedMode = apply.getSystemDeployedMode();
        Date downtime = apply.getDowntime();
        if (downtime == null) {
            downtime = new Date();
        }
        if (downtime.after(new Date())) {
            downtime = new Date();
        }
        downtime = DateUtils.formatDate(downtime);
        Date deployDatetime = apply.getDeployDatetime();
        deployDatetime = DateUtils.formatDate(deployDatetime);
        List<BpServerFeesCalculateVO> cycleList = this.bpServerFeesCalculateService.getCycleList(deployDatetime, downtime);
        ArrayList<BpServerFeesItem> items = new ArrayList<BpServerFeesItem>();
        if (!CollectionUtils.isEmpty(cycleList)) {
            for (BpServerFeesCalculateVO calculateVO : cycleList) {
                long intervalDates;
                BpServerFeesItem item2 = new BpServerFeesItem();
                BeanUtils.copyProperties((Object)calculateVO, (Object)((Object)item2));
                item2.setHeadId(head.getId());
                item2.setDeployId(apply.getId());
                item2.setProjectId(head.getProjectId());
                item2.setProjectName(head.getProjectName());
                item2.setProjectNumber(head.getProjectNumber());
                item2.setProjectEnvironment(head.getProjectEnvironment());
                item2.setSystemDeployedMode(head.getSystemDeployedMode());
                item2.setDeployDatetime(head.getDeployDatetime());
                if (calculateVO.getIntervalStart() != null && calculateVO.getIntervalEnd() != null) {
                    item2.setBillingDate(calculateVO.getIntervalStart().toDateStr() + " ~ " + calculateVO.getIntervalEnd().toDateStr());
                }
                if (30L == (intervalDates = calculateVO.getIntervalDates() + 1L) || 31L == intervalDates || 2 == calculateVO.getNowMonth() && (28L == intervalDates || 29L == intervalDates)) {
                    BigDecimal amount = this.getStandAmount(systemDeployedMode);
                    item2.setAmount(amount);
                } else {
                    BigDecimal intervalDatesDecimal = new BigDecimal(intervalDates + "");
                    BigDecimal month = new BigDecimal("30");
                    BigDecimal standAmount = this.getStandAmount(systemDeployedMode);
                    BigDecimal amount = standAmount.multiply(intervalDatesDecimal).divide(month, 2, 4);
                    item2.setAmount(amount);
                }
                items.add(item2);
            }
        }
        if (!CollectionUtils.isEmpty(items)) {
            this.bpServerFeesItemService.saveBatch(items);
            BigDecimal amount = items.parallelStream().filter(item -> item.getAmount() != null).map(BpServerFeesItem::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            head.setServerFees(amount);
            this.bpServerFeesHeadService.updateById((Object)head);
        }
    }

    private BpServerFeesHead createServerFeesHead(String id, BpSystemDeployApply apply) {
        BpServerFeesHead head = new BpServerFeesHead();
        BeanUtils.copyProperties((Object)((Object)apply), (Object)((Object)head));
        head.setDeployId(id);
        head.setId(null);
        head.setCreateById(null);
        head.setCreateBy(null);
        head.setCreateTime(null);
        head.setUpdateById(null);
        head.setUpdateBy(null);
        head.setUpdateTime(null);
        List templateHeadDTOList = this.invokeBaseRpcService.getDefaultTemplateByType("serverFees");
        if (!CollectionUtils.isEmpty((Collection)templateHeadDTOList)) {
            Optional templateHeadOptional = templateHeadDTOList.stream().findFirst();
            TemplateHeadDTO templateHead = (TemplateHeadDTO)templateHeadOptional.get();
            head.setTemplateAccount(templateHead.getElsAccount());
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
        }
        this.bpServerFeesHeadService.save((Object)head);
        return head;
    }

    private BigDecimal getStandAmount(String systemDeployedMode) {
        BigDecimal amount = BigDecimal.ONE;
        if (SystemDeployedModeEnum.MONOMER.getKey().equals(systemDeployedMode) || SystemDeployedModeEnum.MONOLITHIC_CLUSTERS.getKey().equals(systemDeployedMode)) {
            amount = new BigDecimal("2000");
        } else if (SystemDeployedModeEnum.CONTAINER.getKey().equals(systemDeployedMode) || SystemDeployedModeEnum.CONTAINER_K8S_CLUSTER.getKey().equals(systemDeployedMode)) {
            amount = new BigDecimal("3000");
        }
        return amount;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void downServe(BpSystemDeployApply bpSystemDeployApply) {
        bpSystemDeployApply.setStatus(SystemDeployApplyStatusEnum.DOWN_SERVE.getValue());
        if (bpSystemDeployApply.getDowntime() == null) {
            bpSystemDeployApply.setDowntime(new Date());
        }
        this.updateById((Object)bpSystemDeployApply);
        this.calculate(bpSystemDeployApply);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void handleFinish(BpSystemDeployApply bpSystemDeployApply) {
        bpSystemDeployApply.setStatus(SystemDeployApplyStatusEnum.DONE.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        bpSystemDeployApply.setDeployerId(loginUser.getId());
        bpSystemDeployApply.setDeployerName(loginUser.getRealname());
        this.updateById((Object)bpSystemDeployApply);
        this.calculate(bpSystemDeployApply);
        bpSystemDeployApply = (BpSystemDeployApply)((Object)this.getById((Serializable)((Object)bpSystemDeployApply.getId())));
        this.sendEmail(bpSystemDeployApply);
    }

    private void sendEmail(BpSystemDeployApply bpSystemDeployApply) {
        this.emailSendService.checkBindEmail(bpSystemDeployApply.getElsAccount(), bpSystemDeployApply.getCreateBy());
        String email = this.emailSendService.getEmail(bpSystemDeployApply.getElsAccount(), bpSystemDeployApply.getCreateBy());
        String projectName = bpSystemDeployApply.getProjectName();
        ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig("1517606");
        String subject = "\u7cfb\u7edf\u90e8\u7f72\u7533\u8bf7\u5ba1\u6279\u901a\u8fc7\u63d0\u9192";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("projectName", projectName);
        GroupTemplate groupTemplate = new GroupTemplate();
        Template template = groupTemplate.getTemplate("bpSystemDeployApplyFinish.html");
        template.binding(params);
        String render = template.render();
        ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)config, (String)email, (String)subject, (String)render, (String)"tso@51qqt.com", (boolean)true);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public List<BpSystemDeployApply> init() {
        List<BpSystemDeployApply> list = this.projectBaseInfoService.init();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<BpSystemDeployApply>();
        }
        LambdaQueryWrapper applyLambdaQueryWrapper = new LambdaQueryWrapper();
        ArrayList<String> createByList = new ArrayList<String>();
        createByList.add("yukaitao");
        createByList.add("system");
        applyLambdaQueryWrapper.in(BaseEntity::getCreateBy, createByList);
        List existList = this.list((Wrapper)applyLambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)existList)) {
            Set ids = existList.stream().map(BaseEntity::getId).collect(Collectors.toSet());
            for (String id : ids) {
                this.delBpSystemDeployApply(id);
            }
        }
        ArrayList<BpSystemDeployApply> resultList = new ArrayList<BpSystemDeployApply>();
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<String, String> prdMap = new HashMap<String, String>();
        HashMap<String, String> testMap = new HashMap<String, String>();
        PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService = (PurchaseOrganizationInfoRpcService)SpringContextUtils.getBean(PurchaseOrganizationInfoRpcService.class);
        Set departmentIds = list.stream().map(BpSystemDeployApply::getAffiliatedDepartmentName).collect(Collectors.toSet());
        List organizationInfoDTOList = purchaseOrganizationInfoRpcService.listByIds(new ArrayList(departmentIds));
        HashMap<String, String> departmentMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)organizationInfoDTOList)) {
            for (PurchaseOrganizationInfoDTO organizationInfoDTO : organizationInfoDTOList) {
                departmentMap.put(organizationInfoDTO.getId(), organizationInfoDTO.getOrgName());
            }
        }
        for (BpSystemDeployApply bpSystemDeployApply : list) {
            BpSystemDeployApply prd = new BpSystemDeployApply();
            BeanUtils.copyProperties((Object)((Object)bpSystemDeployApply), (Object)((Object)prd));
            String applyNumberPrd = this.invokeBaseRpcService.getNextCode("systemDeployApplyNumber", (Object)bpSystemDeployApply);
            prd.setApplyNumber(applyNumberPrd);
            prd.setId(IdWorker.getIdStr());
            prdMap.put(prd.getParentContractBaseinfoId(), prd.getId());
            String departmentName = (String)departmentMap.get(prd.getAffiliatedDepartmentName());
            if (!StringUtils.isEmpty((CharSequence)departmentName)) {
                prd.setAffiliatedDepartmentName(departmentName);
            }
            prd.setProjectEnvironment("prd");
            prd.setCreateBy(bpSystemDeployApply.getProjectManagerName());
            prd.setCreateById(bpSystemDeployApply.getProjectManagerId());
            resultList.add(prd);
            BpSystemDeployApply test = new BpSystemDeployApply();
            BeanUtils.copyProperties((Object)((Object)bpSystemDeployApply), (Object)((Object)test));
            String applyNumberTest = this.invokeBaseRpcService.getNextCode("systemDeployApplyNumber", (Object)bpSystemDeployApply);
            test.setApplyNumber(applyNumberTest);
            test.setId(IdWorker.getIdStr());
            testMap.put(test.getParentContractBaseinfoId(), test.getId());
            String departmentNameTest = (String)departmentMap.get(test.getAffiliatedDepartmentName());
            if (!StringUtils.isEmpty((CharSequence)departmentNameTest)) {
                test.setAffiliatedDepartmentName(departmentNameTest);
            }
            test.setProjectEnvironment("test");
            test.setCreateBy(bpSystemDeployApply.getProjectManagerName());
            test.setCreateById(bpSystemDeployApply.getProjectManagerId());
            resultList.add(test);
            if (StringUtils.isEmpty((CharSequence)bpSystemDeployApply.getParentContractBaseinfoId())) continue;
            ids.add(bpSystemDeployApply.getParentContractBaseinfoId());
        }
        this.saveBatch(resultList);
        ArrayList<BpDeployModuleProgress> progressList = new ArrayList<BpDeployModuleProgress>();
        List<BpDeployModuleProgress> itemList = this.bpDeployModuleProgressService.initItem(ids);
        if (!CollectionUtils.isEmpty(itemList)) {
            for (BpDeployModuleProgress progress : itemList) {
                String testHeadId;
                String prdHeadId = (String)prdMap.get(progress.getHeadId());
                if (!StringUtils.isEmpty((CharSequence)prdHeadId)) {
                    BpDeployModuleProgress prd = new BpDeployModuleProgress();
                    BeanUtils.copyProperties((Object)((Object)progress), (Object)((Object)prd));
                    prd.setHeadId(prdHeadId);
                    prd.setToElsAccount(prd.getElsAccount());
                    prd.setId(null);
                    progressList.add(prd);
                }
                if (StringUtils.isEmpty((CharSequence)(testHeadId = (String)testMap.get(progress.getHeadId())))) continue;
                BpDeployModuleProgress test = new BpDeployModuleProgress();
                BeanUtils.copyProperties((Object)((Object)progress), (Object)((Object)test));
                test.setHeadId(testHeadId);
                test.setToElsAccount(test.getElsAccount());
                test.setId(null);
                progressList.add(test);
            }
        }
        if (!CollectionUtils.isEmpty(progressList)) {
            this.bpDeployModuleProgressService.saveBatch(progressList);
        }
        return resultList;
    }

    @Override
    public void handleReturn(BpSystemDeployApply bpSystemDeployApply) {
        bpSystemDeployApply.setStatus(SystemDeployApplyStatusEnum.RETURNED.getValue());
        this.updateById((Object)bpSystemDeployApply);
        bpSystemDeployApply = (BpSystemDeployApply)((Object)this.getById((Serializable)((Object)bpSystemDeployApply.getId())));
        this.emailSendService.checkBindEmail(bpSystemDeployApply.getElsAccount(), bpSystemDeployApply.getCreateBy());
        super.sendMsg(bpSystemDeployApply.getElsAccount(), bpSystemDeployApply.getElsAccount(), bpSystemDeployApply.getCreateBy(), (Object)bpSystemDeployApply, "", "systemDeployApply", "handleReturn");
    }
}

